/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdocbook.xslt;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedList;
import org.jboss.jdocbook.JDocBookProcessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.EntityResolver2;

public class EntityResolverChain
implements EntityResolver2 {
    private static final Logger log = LoggerFactory.getLogger(EntityResolverChain.class);
    private LinkedList<EntityResolver> entityResolvers = new LinkedList();

    public EntityResolverChain(EntityResolver rootResolver) {
        this.entityResolvers.addLast(rootResolver);
    }

    public void addEntityResolver(EntityResolver entityResolver) {
        this.entityResolvers.addFirst(entityResolver);
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        log.trace("EntityResolver#resolveEntity: publicId=[" + publicId + "]; systemId=[" + systemId + "]");
        for (EntityResolver entityResolver : this.entityResolvers) {
            InputSource source = entityResolver.resolveEntity(publicId, systemId);
            if (source == null) continue;
            return source;
        }
        return null;
    }

    public InputSource getExternalSubset(String name, String baseURI) throws SAXException, IOException {
        log.trace("EntityResolver2#getExternalSubset: name=[{}]; baseURI=[{}]", (Object)name, (Object)baseURI);
        for (EntityResolver entityResolver : this.entityResolvers) {
            InputSource source;
            if (!(entityResolver instanceof EntityResolver2) || (source = ((EntityResolver2)entityResolver).getExternalSubset(name, baseURI)) == null) continue;
            return source;
        }
        return null;
    }

    public InputSource resolveEntity(String name, String publicId, String baseURI, String systemId) throws SAXException, IOException {
        log.trace("EntityResolver2#resolveEntity: name=[" + name + "]; publicId=[" + publicId + "]; baseURI=[" + baseURI + "]; systemId=[" + systemId + "]");
        String expandedSystemId = null;
        for (EntityResolver entityResolver : this.entityResolvers) {
            InputSource source;
            if (entityResolver instanceof EntityResolver2) {
                source = ((EntityResolver2)entityResolver).resolveEntity(name, publicId, baseURI, systemId);
                if (source == null) continue;
                return source;
            }
            if (expandedSystemId == null) {
                expandedSystemId = this.expandSystemId(baseURI, systemId);
            }
            if ((source = entityResolver.resolveEntity(publicId, expandedSystemId)) == null) continue;
            return source;
        }
        return null;
    }

    private String expandSystemId(String base, String systemId) {
        if (systemId == null || systemId.length() == 0) {
            return null;
        }
        try {
            URI systemIdURI = new URI(systemId);
            if (systemIdURI.isAbsolute()) {
                return systemId;
            }
            return this.resolveBase(base).resolve(systemId).normalize().toString();
        }
        catch (URISyntaxException e) {
            throw new JDocBookProcessException("Could not parse systemId [" + systemId + "] as URI", e);
        }
    }

    /*
     * Loose catch block
     */
    private URI resolveBase(String base) {
        block5: {
            if (base != null && base.length() != 0) break block5;
            return new URI("file", "", "", null, null);
            {
                catch (URISyntaxException e) {
                    throw new JDocBookProcessException("Unable to parse base [" + base + "] as URI", e);
                }
            }
        }
        try {
            return new URI(base);
        }
        catch (URISyntaxException e) {
            return new URI("file", "", "", null, null);
        }
    }
}

