/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdocbook.xslt;

import java.io.IOException;
import java.net.URL;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import org.jboss.jdocbook.Environment;
import org.jboss.jdocbook.JDocBookComponentRegistry;

public class VersionResolver
implements URIResolver {
    public static final String BASE_HREF = "http://docbook.sourceforge.net/release/xsl/";
    public static final int BASE_HREF_LEN = "http://docbook.sourceforge.net/release/xsl/".length();
    private final JDocBookComponentRegistry componentRegistry;
    private final VersionMatcher versionMatcher;

    public VersionResolver(JDocBookComponentRegistry componentRegistry) {
        this.componentRegistry = componentRegistry;
        if (Environment.DocBookXsltResolutionStrategy.INCLUSIVE == componentRegistry.getEnvironment().getDocBookXsltResolutionStrategy()) {
            this.versionMatcher = new VersionMatcher(){

                public boolean matched(String version) {
                    return true;
                }

                public String toString() {
                    return "inclusive";
                }
            };
        } else {
            final String versionToMatch = componentRegistry.getConfiguration().getDocBookVersion() == null ? "current" : componentRegistry.getConfiguration().getDocBookVersion();
            this.versionMatcher = new VersionMatcher(){

                public boolean matched(String version) {
                    return versionToMatch.equals(version);
                }

                public String toString() {
                    return "[versionToMatch=" + versionToMatch + "]";
                }
            };
        }
    }

    public Source resolve(String href, String base) throws TransformerException {
        int versionEndTokenPosition;
        String version;
        if (href.startsWith(BASE_HREF) && this.versionMatcher.matched(version = href.substring(BASE_HREF_LEN, versionEndTokenPosition = href.indexOf(47, BASE_HREF_LEN)))) {
            String name = href.substring(versionEndTokenPosition + 1);
            return this.resolveLocally(name);
        }
        if (base.startsWith(BASE_HREF) && this.versionMatcher.matched(version = base.substring(BASE_HREF_LEN, versionEndTokenPosition = base.indexOf(47, BASE_HREF_LEN)))) {
            String remainingBase = base.substring(versionEndTokenPosition + 1);
            return this.resolveLocally(remainingBase + '/' + href);
        }
        return null;
    }

    private Source resolveLocally(String resourceName) {
        try {
            URL resourceURL = this.componentRegistry.getEnvironment().getResourceDelegate().requireResource(resourceName);
            return new StreamSource(resourceURL.openStream(), resourceURL.toExternalForm());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    public String toString() {
        return super.toString() + " [versionMatcher=" + this.versionMatcher + "]";
    }

    private static interface VersionMatcher {
        public boolean matched(String var1);
    }
}

