/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jdocbook.xslt;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import java.util.LinkedHashSet;
import org.jboss.jdocbook.JDocBookComponentRegistry;
import org.jboss.jdocbook.ValueInjection;
import org.jboss.jdocbook.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.EntityResolver2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XIncludeEntityResolver
implements EntityResolver2 {
    private static final Logger log = LoggerFactory.getLogger(XIncludeEntityResolver.class);
    private final JDocBookComponentRegistry componentRegistry;

    public XIncludeEntityResolver(JDocBookComponentRegistry componentRegistry) {
        this.componentRegistry = componentRegistry;
    }

    protected LinkedHashSet<ValueInjection> getValueInjections() {
        return this.componentRegistry.getConfiguration().getValueInjections();
    }

    @Override
    public InputSource getExternalSubset(String name, String baseURI) throws SAXException, IOException {
        log.trace("generating external subset; name=[{}]; baseURI=[{}]", (Object)name, (Object)baseURI);
        LinkedHashSet<ValueInjection> injections = this.getValueInjections();
        if (injections == null || injections.isEmpty()) {
            log.trace("No value injections defined; skipping");
            return null;
        }
        StringBuilder subset = FileUtils.buildInjectedEntitySubset(injections);
        return new InputSource(new StringReader(subset.toString()));
    }

    @Override
    public InputSource resolveEntity(String name, String publicId, String baseURI, String systemId) throws SAXException, IOException {
        File baseFile;
        log.trace("resolving entity; name=[" + name + "]; publicId=[" + publicId + "]; baseURI=[" + baseURI + "]; systemId=[" + systemId + "]");
        LinkedHashSet<ValueInjection> injections = this.getValueInjections();
        if (injections == null || injections.isEmpty()) {
            log.trace("No value injections defined; skipping");
            return null;
        }
        if (publicId == null && baseURI.startsWith("file:") && systemId.trim().endsWith(".ent") && (baseFile = new File(new URL(baseURI).getFile())).exists()) {
            InputSource inputSource = this.createInputSource(new File(baseFile.getParentFile(), systemId), injections);
            inputSource.setSystemId(baseFile.toURI().toString());
            return inputSource;
        }
        return null;
    }

    private InputSource createInputSource(File entFile, LinkedHashSet<ValueInjection> injections) throws IOException {
        StringBuilder buffer = FileUtils.buildInjectedEntitySubset(injections);
        if (entFile.exists()) {
            String contents = FileUtils.fileRead((File)entFile);
            buffer.append(contents);
        } else {
            log.warn("referenced ENT file not found: " + entFile.getAbsolutePath());
        }
        return new InputSource(new StringReader(buffer.toString()));
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        return this.resolveEntity(null, publicId, null, systemId);
    }
}

