/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.processor.generator.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.processing.Filer;
import org.jboss.jdeparser.JAssignableExpr;
import org.jboss.jdeparser.JBlock;
import org.jboss.jdeparser.JCall;
import org.jboss.jdeparser.JClassDef;
import org.jboss.jdeparser.JExpr;
import org.jboss.jdeparser.JExprs;
import org.jboss.jdeparser.JMethodDef;
import org.jboss.jdeparser.JParamDeclaration;
import org.jboss.jdeparser.JType;
import org.jboss.jdeparser.JTypes;
import org.jboss.jdeparser.JVarDeclaration;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.Once;
import org.jboss.logging.annotations.Pos;
import org.jboss.logging.annotations.Transform;
import org.jboss.logging.processor.generator.model.ImplementationClassModel;
import org.jboss.logging.processor.model.MessageInterface;
import org.jboss.logging.processor.model.MessageMethod;
import org.jboss.logging.processor.model.Parameter;
import org.jboss.logging.processor.util.ElementHelper;

final class MessageLoggerImplementor
extends ImplementationClassModel {
    private static final String LOG_FIELD_NAME = "log";
    private static final String FQCN_FIELD_NAME = "FQCN";
    private final boolean useLogging31;
    private final Map<String, JVarDeclaration> logOnceVars = new HashMap<String, JVarDeclaration>();

    public MessageLoggerImplementor(Filer filer, MessageInterface messageInterface, boolean useLogging31) {
        super(filer, messageInterface);
        this.useLogging31 = useLogging31;
    }

    public boolean isUseLogging31() {
        return this.useLogging31;
    }

    @Override
    protected JClassDef generateModel() throws IllegalStateException {
        JVarDeclaration logVar;
        JAssignableExpr logger;
        JClassDef classDef = super.generateModel();
        JVarDeclaration fqcn = this.messageInterface().loggingFQCN() == null ? classDef.field(74, String.class, FQCN_FIELD_NAME, (JExpr)JTypes.$t((JClassDef)classDef)._class().call("getName")) : classDef.field(74, String.class, FQCN_FIELD_NAME, (JExpr)JTypes.$t((String)this.messageInterface().loggingFQCN())._class().call("getName"));
        JMethodDef constructor = classDef.constructor(32);
        JType loggerType = JTypes.$t(Logger.class);
        this.sourceFile._import(loggerType);
        this.sourceFile._import(Logger.Level.class);
        JParamDeclaration constructorParam = constructor.param(2, loggerType, LOG_FIELD_NAME);
        JBlock constructorBody = constructor.body();
        if (this.messageInterface().extendsLoggerInterface()) {
            if (this.useLogging31) {
                this.sourceFile._import(DelegatingBasicLogger.class);
                classDef._extends(DelegatingBasicLogger.class);
                constructorBody.callSuper().arg((JExpr)JExprs.$v((JParamDeclaration)constructorParam));
                logger = JExprs.$v((String)"super").field(LOG_FIELD_NAME);
            } else {
                logVar = classDef.field(18, loggerType, LOG_FIELD_NAME);
                constructorBody.assign(JExpr.THIS.field(logVar.name()), (JExpr)JExprs.$v((JParamDeclaration)constructorParam));
                logger = JExprs.$v((JVarDeclaration)logVar);
                this.generateDelegatingLoggerMethods(classDef, logger, fqcn);
            }
        } else {
            logVar = classDef.field(18, loggerType, LOG_FIELD_NAME);
            constructorBody.assign(JExpr.THIS.field(logVar.name()), (JExpr)JExprs.$v((JParamDeclaration)constructorParam));
            logger = JExprs.$v((JVarDeclaration)logVar);
        }
        LinkedHashSet<MessageMethod> messageMethods = new LinkedHashSet<MessageMethod>();
        messageMethods.addAll(this.messageInterface().methods());
        for (MessageInterface messageInterface : this.messageInterface().extendedInterfaces()) {
            if (messageInterface.getAnnotatedType() == MessageInterface.AnnotatedType.NONE) continue;
            messageMethods.addAll(messageInterface.methods());
        }
        for (MessageMethod messageMethod : messageMethods) {
            if (messageMethod.isLoggerMethod()) {
                this.createLoggerMethod(messageMethod, classDef, logger);
                continue;
            }
            this.createBundleMethod(classDef, messageMethod);
        }
        return classDef;
    }

    private void generateDelegatingLoggerMethods(JClassDef classDef, JAssignableExpr logVar, JVarDeclaration fqcn) {
        JType logLevelClass = JTypes.$t(Logger.Level.class);
        for (String level : Arrays.asList("TRACE", "DEBUG", "INFO", "WARN", "ERROR", "FATAL")) {
            String firstUppered = level.charAt(0) + level.substring(1).toLowerCase(Locale.US);
            String lowered = level.toLowerCase(Locale.US);
            if ("TRACE".equals(level) || "DEBUG".equals(level) || "INFO".equals(level)) {
                String isXxxEnabledStr = "is" + firstUppered + "Enabled";
                JMethodDef isXxxEnabled = classDef.method(34, JType.BOOLEAN, isXxxEnabledStr);
                isXxxEnabled.annotate(Override.class);
                isXxxEnabled.body()._return((JExpr)logVar.call(isXxxEnabledStr));
            }
            JMethodDef xxx1 = classDef.method(34, JType.VOID, lowered);
            xxx1.annotate(Override.class);
            JParamDeclaration xxx1message = xxx1.param(Object.class, "message");
            xxx1.body().add((JExpr)logVar.call(lowered).arg((JExpr)JExprs.$v((JVarDeclaration)fqcn)).arg((JExpr)JExprs.$v((JParamDeclaration)xxx1message)).arg(JExpr.NULL));
            JMethodDef xxx2 = classDef.method(34, JType.VOID, lowered);
            xxx2.annotate(Override.class);
            JParamDeclaration xxx2message = xxx2.param(Object.class, "message");
            JParamDeclaration xxx2t = xxx2.param(Throwable.class, "t");
            xxx2.body().add((JExpr)logVar.call(lowered).arg((JExpr)JExprs.$v((JVarDeclaration)fqcn)).arg((JExpr)JExprs.$v((JParamDeclaration)xxx2message)).arg((JExpr)JExprs.$v((JParamDeclaration)xxx2t)));
            JMethodDef xxx3 = classDef.method(34, JType.VOID, lowered);
            xxx3.annotate(Override.class);
            JParamDeclaration xxx3loggerFqcn = xxx3.param(String.class, "loggerFqcn");
            JParamDeclaration xxx3message = xxx3.param(Object.class, "message");
            JParamDeclaration xxx3t = xxx3.param(Throwable.class, "t");
            xxx3.body().add((JExpr)logVar.call(lowered).arg((JExpr)JExprs.$v((JParamDeclaration)xxx3loggerFqcn)).arg((JExpr)JExprs.$v((JParamDeclaration)xxx3message)).arg((JExpr)JExprs.$v((JParamDeclaration)xxx3t)));
            JMethodDef xxx4 = classDef.method(34, JType.VOID, lowered);
            xxx4.annotate(Override.class);
            JParamDeclaration xxx4loggerFqcn = xxx4.param(String.class, "loggerFqcn");
            JParamDeclaration xxx4message = xxx4.param(Object.class, "message");
            JParamDeclaration xxx4params = xxx4.param(JTypes.$t(Object.class).array(), "params");
            JParamDeclaration xxx4t = xxx4.param(Throwable.class, "t");
            xxx4.body().add((JExpr)logVar.call(lowered).arg((JExpr)JExprs.$v((JParamDeclaration)xxx4loggerFqcn)).arg((JExpr)JExprs.$v((JParamDeclaration)xxx4message)).arg((JExpr)JExprs.$v((JParamDeclaration)xxx4params)).arg((JExpr)JExprs.$v((JParamDeclaration)xxx4t)));
            for (String affix : Arrays.asList("v", "f")) {
                String name = lowered + affix;
                String target = LOG_FIELD_NAME + affix;
                for (boolean renderThr : new boolean[]{false, true}) {
                    JParamDeclaration thr = null;
                    JMethodDef xxx1x = classDef.method(34, JType.VOID, name);
                    xxx1x.annotate(Override.class);
                    if (renderThr) {
                        thr = xxx1x.param(Throwable.class, "t");
                    }
                    JParamDeclaration xxx1xFormat = xxx1x.param(String.class, "format");
                    JParamDeclaration xxx1xParams = xxx1x.varargParam(Object.class, "params");
                    xxx1x.body().add((JExpr)logVar.call(target).arg((JExpr)JExprs.$v((JVarDeclaration)fqcn)).arg((JExpr)logLevelClass.$v(level)).arg((JExpr)(renderThr ? JExprs.$v((JParamDeclaration)thr) : JExpr.NULL)).arg((JExpr)JExprs.$v((JParamDeclaration)xxx1xFormat)).arg((JExpr)JExprs.$v((JParamDeclaration)xxx1xParams)));
                    for (int i = 1; i <= 3; ++i) {
                        JMethodDef xxx2x = classDef.method(34, JType.VOID, name);
                        xxx2x.annotate(Override.class);
                        if (renderThr) {
                            thr = xxx2x.param(Throwable.class, "t");
                        }
                        JParamDeclaration xxx2xFormat = xxx2x.param(String.class, "format");
                        JParamDeclaration[] params = new JParamDeclaration[i];
                        for (int j = 0; j < i; ++j) {
                            params[j] = xxx2x.param(Object.class, "param" + (j + 1));
                        }
                        JCall xxx2xCaller = logVar.call(target);
                        xxx2xCaller.arg((JExpr)JExprs.$v((JVarDeclaration)fqcn)).arg((JExpr)logLevelClass.$v(level)).arg((JExpr)(renderThr ? JExprs.$v((JParamDeclaration)thr) : JExpr.NULL)).arg((JExpr)JExprs.$v((JParamDeclaration)xxx2xFormat));
                        for (int j = 0; j < i; ++j) {
                            xxx2xCaller.arg((JExpr)JExprs.$v((JParamDeclaration)params[j]));
                        }
                        xxx2x.body().add((JExpr)xxx2xCaller);
                    }
                }
            }
        }
        JMethodDef isEnabled = classDef.method(34, JType.BOOLEAN, "isEnabled");
        isEnabled.annotate(Override.class);
        JParamDeclaration isEnabledLevel = isEnabled.param(logLevelClass, "level");
        isEnabled.body()._return((JExpr)logVar.call("isEnabled").arg((JExpr)JExprs.$v((JParamDeclaration)isEnabledLevel)));
        JMethodDef log1 = classDef.method(34, JType.VOID, LOG_FIELD_NAME);
        log1.annotate(Override.class);
        JParamDeclaration log1Level = log1.param(logLevelClass, "level");
        JParamDeclaration log1Message = log1.param(Object.class, "message");
        log1.body().add((JExpr)logVar.call(LOG_FIELD_NAME).arg((JExpr)JExprs.$v((JVarDeclaration)fqcn)).arg((JExpr)JExprs.$v((JParamDeclaration)log1Level)).arg((JExpr)JExprs.$v((JParamDeclaration)log1Message)).arg(JExpr.NULL).arg(JExpr.NULL));
        JMethodDef log2 = classDef.method(34, JType.VOID, LOG_FIELD_NAME);
        log2.annotate(Override.class);
        JParamDeclaration log2Level = log2.param(logLevelClass, "level");
        JParamDeclaration log2message = log2.param(Object.class, "message");
        JParamDeclaration log2t = log2.param(Throwable.class, "t");
        log2.body().add((JExpr)logVar.call(LOG_FIELD_NAME).arg((JExpr)JExprs.$v((JVarDeclaration)fqcn)).arg((JExpr)JExprs.$v((JParamDeclaration)log2Level)).arg((JExpr)JExprs.$v((JParamDeclaration)log2message)).arg(JExpr.NULL).arg((JExpr)JExprs.$v((JParamDeclaration)log2t)));
        JMethodDef log3 = classDef.method(34, JType.VOID, LOG_FIELD_NAME);
        log3.annotate(Override.class);
        JParamDeclaration log3Level = log3.param(logLevelClass, "level");
        JParamDeclaration log3loggerFqcn = log3.param(String.class, "loggerFqcn");
        JParamDeclaration log3message = log3.param(Object.class, "message");
        JParamDeclaration log3t = log3.param(Throwable.class, "t");
        log3.body().add((JExpr)logVar.call(LOG_FIELD_NAME).arg((JExpr)JExprs.$v((JParamDeclaration)log3Level)).arg((JExpr)JExprs.$v((JParamDeclaration)log3loggerFqcn)).arg((JExpr)JExprs.$v((JParamDeclaration)log3message)).arg((JExpr)JExprs.$v((JParamDeclaration)log3t)));
        JMethodDef log4 = classDef.method(34, JType.VOID, LOG_FIELD_NAME);
        log4.annotate(Override.class);
        JParamDeclaration log4loggerFqcn = log4.param(String.class, "loggerFqcn");
        JParamDeclaration log4Level = log4.param(logLevelClass, "level");
        JParamDeclaration log4message = log4.param(Object.class, "message");
        JParamDeclaration log4params = log4.param(JTypes.$t(Object.class).array(), "params");
        JParamDeclaration log4t = log4.param(Throwable.class, "t");
        log4.body().add((JExpr)logVar.call(LOG_FIELD_NAME).arg((JExpr)JExprs.$v((JParamDeclaration)log4loggerFqcn)).arg((JExpr)JExprs.$v((JParamDeclaration)log4Level)).arg((JExpr)JExprs.$v((JParamDeclaration)log4message)).arg((JExpr)JExprs.$v((JParamDeclaration)log4params)).arg((JExpr)JExprs.$v((JParamDeclaration)log4t)));
        for (String affix : Arrays.asList("v", "f")) {
            String name = LOG_FIELD_NAME + affix;
            for (RenderLog render : RenderLog.values()) {
                JParamDeclaration logFqcn = null;
                JParamDeclaration thr = null;
                boolean renderThr = render.isThr();
                boolean renderFqcn = render.isFqcn();
                JMethodDef log1x = classDef.method(34, JType.VOID, name);
                log1x.annotate(Override.class);
                if (renderFqcn) {
                    logFqcn = log1x.param(String.class, "loggerFqcn");
                }
                JParamDeclaration log1xLevel = log1x.param(logLevelClass, "level");
                if (renderThr) {
                    thr = log1x.param(Throwable.class, "t");
                }
                JParamDeclaration log1xFormat = log1x.param(String.class, "format");
                JParamDeclaration log1xParams = log1x.varargParam(Object.class, "params");
                log1x.body().add((JExpr)logVar.call(name).arg((JExpr)(renderFqcn ? JExprs.$v((JParamDeclaration)logFqcn) : JExprs.$v((JVarDeclaration)fqcn))).arg((JExpr)JExprs.$v((JParamDeclaration)log1xLevel)).arg((JExpr)(renderThr ? JExprs.$v((JParamDeclaration)thr) : JExpr.NULL)).arg((JExpr)JExprs.$v((JParamDeclaration)log1xFormat)).arg((JExpr)JExprs.$v((JParamDeclaration)log1xParams)));
                for (int i = 1; i <= 3; ++i) {
                    JMethodDef log2x = classDef.method(34, JType.VOID, name);
                    log2x.annotate(Override.class);
                    if (renderFqcn) {
                        logFqcn = log2x.param(String.class, "loggerFqcn");
                    }
                    JParamDeclaration log2xLevel = log2x.param(logLevelClass, "level");
                    if (renderThr) {
                        thr = log2x.param(Throwable.class, "t");
                    }
                    JParamDeclaration log2xFormat = log2x.param(String.class, "format");
                    JParamDeclaration[] params = new JParamDeclaration[i];
                    for (int j = 0; j < i; ++j) {
                        params[j] = log2x.param(Object.class, "param" + (j + 1));
                    }
                    JCall log2xCaller = logVar.call(name);
                    log2xCaller.arg((JExpr)(renderFqcn ? JExprs.$v((JParamDeclaration)logFqcn) : JExprs.$v((JVarDeclaration)fqcn))).arg((JExpr)JExprs.$v((JParamDeclaration)log2xLevel)).arg((JExpr)(renderThr ? JExprs.$v((JParamDeclaration)thr) : JExpr.NULL)).arg((JExpr)JExprs.$v((JParamDeclaration)log2xFormat));
                    for (int j = 0; j < i; ++j) {
                        log2xCaller.arg((JExpr)JExprs.$v((JParamDeclaration)params[j]));
                    }
                    log2x.body().add((JExpr)log2xCaller);
                }
            }
        }
    }

    private void createLoggerMethod(MessageMethod messageMethod, JClassDef classDef, JAssignableExpr logger) {
        JBlock body;
        String msgMethodName = messageMethod.messageMethodName();
        JMethodDef method = classDef.method(34, messageMethod.returnType().name(), messageMethod.name());
        method.annotate(Override.class);
        this.addMessageMethod(messageMethod);
        this.addThrownTypes(messageMethod, method);
        Map<Parameter, JParamDeclaration> params = this.createParameters(messageMethod, method);
        ArrayList<String> parameterNames = new ArrayList<String>(params.size());
        for (Parameter param : params.keySet()) {
            parameterNames.add(param.name());
        }
        if (ElementHelper.isAnnotatedWith(messageMethod.reference(), Once.class) && messageMethod.isLoggerMethod()) {
            JVarDeclaration var;
            JType atomicBoolean = JTypes.$t(AtomicBoolean.class);
            this.sourceFile._import(atomicBoolean);
            String varName = messageMethod.name() + "_$Once";
            if (this.logOnceVars.containsKey(varName)) {
                var = this.logOnceVars.get(varName);
            } else {
                var = classDef.field(74, atomicBoolean, varName, (JExpr)atomicBoolean._new().arg(JExpr.FALSE));
                this.logOnceVars.put(varName, var);
            }
            body = method.body()._if(logger.call("isEnabled").arg((JExpr)JExprs.$v((String)messageMethod.logLevel())).and((JExpr)JExprs.$v((JVarDeclaration)var).call("compareAndSet").arg(JExpr.FALSE).arg(JExpr.TRUE))).block(JBlock.Braces.REQUIRED);
        } else {
            body = !messageMethod.parameters(Parameter.ParameterType.TRANSFORM).isEmpty() ? method.body()._if((JExpr)logger.call("isEnabled").arg((JExpr)JExprs.$v((String)messageMethod.logLevel()))).block(JBlock.Braces.REQUIRED) : method.body();
        }
        JCall logCaller = logger.call(messageMethod.loggerMethod());
        if (messageMethod.parameters(Parameter.ParameterType.FQCN).isEmpty()) {
            logCaller.arg((JExpr)JExprs.$v((String)FQCN_FIELD_NAME));
        } else {
            logCaller.arg((JExpr)JExprs.$v((JParamDeclaration)params.get(messageMethod.parameters(Parameter.ParameterType.FQCN).iterator().next())).call("getName"));
        }
        logCaller.arg((JExpr)JExprs.$v((String)messageMethod.logLevel()));
        MessageMethod.Message message = messageMethod.message();
        if (message.format() == Message.Format.NO_FORMAT) {
            logCaller.arg((JExpr)JExprs.call((String)msgMethodName));
            logCaller.arg(JExpr.NULL);
            if (messageMethod.hasCause()) {
                logCaller.arg((JExpr)JExprs.$v((String)messageMethod.cause().name()));
            } else {
                logCaller.arg(JExpr.NULL);
            }
        } else {
            if (messageMethod.hasCause()) {
                logCaller.arg((JExpr)JExprs.$v((String)messageMethod.cause().name()));
            } else {
                logCaller.arg(JExpr.NULL);
            }
            logCaller.arg((JExpr)JExprs.call((String)msgMethodName));
            ArrayList<Object> args = new ArrayList<Object>();
            for (Map.Entry<Parameter, JParamDeclaration> entry : params.entrySet()) {
                Parameter param = entry.getKey();
                String formatterClass = param.formatterClass();
                JParamDeclaration var = entry.getValue();
                switch (param.parameterType()) {
                    case FORMAT: {
                        if (formatterClass == null) {
                            if (param.isArray() || param.isVarArgs()) {
                                args.add(JTypes.$t(Arrays.class).call("toString").arg((JExpr)JExprs.$v((JParamDeclaration)var)));
                                break;
                            }
                            args.add(JExprs.$v((JParamDeclaration)var));
                            break;
                        }
                        args.add(JTypes.$t((String)formatterClass)._new().arg((JExpr)JExprs.$v((JParamDeclaration)var)));
                        break;
                    }
                    case TRANSFORM: {
                        JAssignableExpr transformVar = this.createTransformVar(parameterNames, body, param, (JExpr)JExprs.$v((JParamDeclaration)var));
                        if (formatterClass == null) {
                            args.add(transformVar);
                            break;
                        }
                        args.add(JTypes.$t((String)formatterClass)._new().arg((JExpr)transformVar));
                        break;
                    }
                    case POS: {
                        Pos pos = param.pos();
                        int[] positions = pos.value();
                        Transform[] transform = pos.transform();
                        for (int i = 0; i < positions.length; ++i) {
                            int index = positions[i] - 1;
                            if (transform != null && transform.length > 0) {
                                JAssignableExpr tVar = this.createTransformVar(parameterNames, body, param, transform[i], (JExpr)JExprs.$v((JParamDeclaration)var));
                                if (index < args.size()) {
                                    args.add(index, tVar);
                                    continue;
                                }
                                args.add(tVar);
                                continue;
                            }
                            if (index < args.size()) {
                                args.add(index, JExprs.$v((JParamDeclaration)var));
                                continue;
                            }
                            args.add(JExprs.$v((JParamDeclaration)var));
                        }
                        break;
                    }
                }
            }
            for (JExpr jExpr : args) {
                logCaller.arg(jExpr);
            }
        }
        body.add((JExpr)logCaller);
    }

    private Map<Parameter, JParamDeclaration> createParameters(MessageMethod messageMethod, JMethodDef method) {
        LinkedHashMap<Parameter, JParamDeclaration> result = new LinkedHashMap<Parameter, JParamDeclaration>();
        for (Parameter param : messageMethod.parameters(Parameter.ParameterType.ANY)) {
            JParamDeclaration var = this.addMethodParameter(method, param);
            result.put(param, var);
        }
        return result;
    }

    static enum RenderLog {
        NONE(false, false),
        CAUSE(true, false),
        FQCN(true, true);

        private final boolean thr;
        private final boolean fqcn;

        private RenderLog(boolean thr, boolean fqcn) {
            this.thr = thr;
            this.fqcn = fqcn;
        }

        public boolean isThr() {
            return this.thr;
        }

        public boolean isFqcn() {
            return this.fqcn;
        }
    }
}

