/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.processor.validation;

import javax.annotation.processing.Messager;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.tools.Diagnostic;
import org.jboss.logging.processor.model.DelegatingElement;

public interface ValidationMessage {
    public Type type();

    public Element getElement();

    public AnnotationMirror getAnnotationMirror();

    public AnnotationValue getAnnotationValue();

    public String getMessage();

    default public boolean printMessage(Messager messager) {
        Diagnostic.Kind kind;
        boolean error = false;
        Element element = this.getElement();
        element = element instanceof DelegatingElement ? ((DelegatingElement)element).getDelegate() : element;
        AnnotationMirror annotationMirror = this.getAnnotationMirror();
        AnnotationValue annotationValue = this.getAnnotationValue();
        if (this.type() == Type.ERROR) {
            kind = Diagnostic.Kind.ERROR;
            error = true;
        } else {
            kind = Diagnostic.Kind.WARNING;
        }
        if (annotationMirror == null) {
            messager.printMessage(kind, this.getMessage(), element);
        } else if (annotationValue == null) {
            messager.printMessage(kind, this.getMessage(), element, annotationMirror);
        } else {
            messager.printMessage(kind, this.getMessage(), element, annotationMirror, annotationValue);
        }
        return error;
    }

    public static enum Type {
        ERROR,
        WARN;

    }
}

