/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling.reflect;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamException;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.jboss.marshalling.reflect.SerializableClassRegistry;
import org.jboss.marshalling.reflect.SerializableField;
import sun.reflect.ReflectionFactory;

public final class SerializableClass {
    private static final ReflectionFactory reflectionFactory = (ReflectionFactory)AccessController.doPrivileged(new ReflectionFactory.GetReflectionFactoryAction());
    private final Class<?> subject;
    private final Method writeObject;
    private final Method writeReplace;
    private final Method readObject;
    private final Method readObjectNoData;
    private final Method readResolve;
    private final Constructor<?> noArgConstructor;
    private final Constructor<?> objectInputConstructor;
    private final Constructor<?> nonInitConstructor;
    private final SerializableField[] fields;
    private final Map<String, SerializableField> fieldsByName;
    private final long effectiveSerialVersionUID;
    private static final Comparator<? super SerializableField> NAME_COMPARATOR = new Comparator<SerializableField>(){

        @Override
        public int compare(SerializableField o1, SerializableField o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    public static final SerializableField[] NOFIELDS = new SerializableField[0];

    SerializableClass(Class<?> subject) {
        Class<?> superclass;
        this.subject = subject;
        Method writeObject = null;
        Method readObject = null;
        Method readObjectNoData = null;
        Method writeReplace = null;
        Method readResolve = null;
        for (Method method : subject.getDeclaredMethods()) {
            Class<?>[] parameterTypes;
            int modifiers = method.getModifiers();
            String methodName = method.getName();
            Class<?> methodReturnType = method.getReturnType();
            if (Modifier.isStatic(modifiers)) continue;
            if (Modifier.isPrivate(modifiers) && methodReturnType == Void.TYPE) {
                if (methodName.equals("writeObject")) {
                    parameterTypes = method.getParameterTypes();
                    if (parameterTypes.length != 1 || parameterTypes[0] != ObjectOutputStream.class) continue;
                    writeObject = method;
                    writeObject.setAccessible(true);
                    continue;
                }
                if (methodName.equals("readObject")) {
                    parameterTypes = method.getParameterTypes();
                    if (parameterTypes.length != 1 || parameterTypes[0] != ObjectInputStream.class) continue;
                    readObject = method;
                    readObject.setAccessible(true);
                    continue;
                }
                if (!methodName.equals("readObjectNoData") || (parameterTypes = method.getParameterTypes()).length != 0) continue;
                readObjectNoData = method;
                readObjectNoData.setAccessible(true);
                continue;
            }
            if (methodReturnType != Object.class) continue;
            if (methodName.equals("writeReplace")) {
                parameterTypes = method.getParameterTypes();
                if (parameterTypes.length != 0) continue;
                writeReplace = method;
                writeReplace.setAccessible(true);
                continue;
            }
            if (!methodName.equals("readResolve") || (parameterTypes = method.getParameterTypes()).length != 0) continue;
            readResolve = method;
            readResolve.setAccessible(true);
        }
        if ((readResolve == null || writeReplace == null) && (superclass = subject.getSuperclass()) != null) {
            SerializableClass superInfo = SerializableClassRegistry.getInstanceUnchecked().lookup(superclass);
            Method otherReadResolve = superInfo.readResolve;
            if (readResolve == null && otherReadResolve != null && !Modifier.isPrivate(otherReadResolve.getModifiers())) {
                readResolve = otherReadResolve;
            }
            Method otherWriteReplace = superInfo.writeReplace;
            if (writeReplace == null && otherWriteReplace != null && !Modifier.isPrivate(otherWriteReplace.getModifiers())) {
                writeReplace = otherWriteReplace;
            }
        }
        Constructor<?> noArgConstructor = null;
        Constructor<?> objectInputConstructor = null;
        for (Constructor<?> constructor : subject.getConstructors()) {
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            if (parameterTypes.length == 0) {
                noArgConstructor = constructor;
                noArgConstructor.setAccessible(true);
                continue;
            }
            if (parameterTypes.length != 1 || parameterTypes[0] != ObjectInput.class) continue;
            objectInputConstructor = constructor;
            noArgConstructor.setAccessible(true);
        }
        this.writeObject = writeObject;
        this.readObject = readObject;
        this.readObjectNoData = readObjectNoData;
        this.noArgConstructor = noArgConstructor;
        this.objectInputConstructor = objectInputConstructor;
        this.readResolve = readResolve;
        this.writeReplace = writeReplace;
        this.nonInitConstructor = SerializableClass.lookupNonInitConstructor(subject);
        ObjectStreamClass objectStreamClass = ObjectStreamClass.lookup(subject);
        this.effectiveSerialVersionUID = objectStreamClass == null ? 0L : objectStreamClass.getSerialVersionUID();
        HashMap<String, SerializableField> fieldsByName = new HashMap<String, SerializableField>();
        this.fields = SerializableClass.getSerializableFields(subject);
        for (SerializableField serializableField : this.fields) {
            fieldsByName.put(serializableField.getName(), serializableField);
        }
        this.fieldsByName = fieldsByName;
    }

    private static SerializableField[] getSerializableFields(Class<?> clazz) {
        Field[] declaredFields = clazz.getDeclaredFields();
        ObjectStreamField[] objectStreamFields = SerializableClass.getDeclaredSerialPersistentFields(clazz);
        if (objectStreamFields != null) {
            HashMap<String, Field> map = new HashMap<String, Field>();
            for (Field field : declaredFields) {
                field.setAccessible(true);
                map.put(field.getName(), field);
            }
            SerializableField[] fields = new SerializableField[objectStreamFields.length];
            for (int i = 0; i < objectStreamFields.length; ++i) {
                ObjectStreamField field = objectStreamFields[i];
                String name = field.getName();
                fields[i] = new SerializableField(field.getType(), name, field.isUnshared(), (Field)map.get(name));
            }
            Arrays.sort(fields, NAME_COMPARATOR);
            return fields;
        }
        ArrayList<SerializableField> fields = new ArrayList<SerializableField>(declaredFields.length);
        for (Field field : declaredFields) {
            if ((field.getModifiers() & 0x88) != 0) continue;
            field.setAccessible(true);
            fields.add(new SerializableField(field.getType(), field.getName(), false, field));
        }
        Collections.sort(fields, NAME_COMPARATOR);
        return fields.toArray(new SerializableField[fields.size()]);
    }

    private static ObjectStreamField[] getDeclaredSerialPersistentFields(Class<?> clazz) {
        Field field;
        try {
            field = clazz.getDeclaredField("serialPersistentFields");
        }
        catch (NoSuchFieldException e) {
            return null;
        }
        if (field == null) {
            return null;
        }
        int requiredModifiers = 26;
        if ((field.getModifiers() & 0x1A) != 26) {
            return null;
        }
        field.setAccessible(true);
        try {
            return (ObjectStreamField[])field.get(null);
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public SerializableField[] getFields() {
        return this.fields;
    }

    public SerializableField getSerializableField(String name, Class<?> fieldType, boolean unshared) throws ClassNotFoundException {
        SerializableField serializableField = this.fieldsByName.get(name);
        if (serializableField != null) {
            return serializableField;
        }
        return new SerializableField(fieldType, name, unshared, null);
    }

    public boolean hasWriteObject() {
        return this.writeObject != null;
    }

    public void callWriteObject(Object object, ObjectOutputStream outputStream) throws IOException {
        try {
            this.writeObject.invoke(object, outputStream);
        }
        catch (InvocationTargetException e) {
            Throwable te = e.getTargetException();
            if (te instanceof IOException) {
                throw (IOException)te;
            }
            if (te instanceof RuntimeException) {
                throw (RuntimeException)te;
            }
            if (te instanceof Error) {
                throw (Error)te;
            }
            throw new IllegalStateException("Unexpected exception", te);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Method is unexpectedly inaccessible");
        }
    }

    public boolean hasReadObject() {
        return this.readObject != null;
    }

    public void callReadObject(Object object, ObjectInputStream inputStream) throws IOException, ClassNotFoundException {
        try {
            this.readObject.invoke(object, inputStream);
        }
        catch (InvocationTargetException e) {
            Throwable te = e.getTargetException();
            if (te instanceof IOException) {
                throw (IOException)te;
            }
            if (te instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)te;
            }
            if (te instanceof RuntimeException) {
                throw (RuntimeException)te;
            }
            if (te instanceof Error) {
                throw (Error)te;
            }
            throw new IllegalStateException("Unexpected exception", te);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Method is unexpectedly inaccessible");
        }
    }

    public boolean hasReadObjectNoData() {
        return this.readObjectNoData != null;
    }

    public void callReadObjectNoData(Object object) throws ObjectStreamException {
        try {
            this.readObjectNoData.invoke(object, new Object[0]);
        }
        catch (InvocationTargetException e) {
            Throwable te = e.getTargetException();
            if (te instanceof ObjectStreamException) {
                throw (ObjectStreamException)te;
            }
            if (te instanceof RuntimeException) {
                throw (RuntimeException)te;
            }
            if (te instanceof Error) {
                throw (Error)te;
            }
            throw new IllegalStateException("Unexpected exception", te);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Method is unexpectedly inaccessible");
        }
    }

    public boolean hasWriteReplace() {
        return this.writeReplace != null;
    }

    public Object callWriteReplace(Object object) throws ObjectStreamException {
        try {
            return this.writeReplace.invoke(object, new Object[0]);
        }
        catch (InvocationTargetException e) {
            Throwable te = e.getTargetException();
            if (te instanceof ObjectStreamException) {
                throw (ObjectStreamException)te;
            }
            if (te instanceof RuntimeException) {
                throw (RuntimeException)te;
            }
            if (te instanceof Error) {
                throw (Error)te;
            }
            throw new IllegalStateException("Unexpected exception", te);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Method is unexpectedly inaccessible");
        }
    }

    public boolean hasReadResolve() {
        return this.readResolve != null;
    }

    public Object callReadResolve(Object object) throws ObjectStreamException {
        try {
            return this.readResolve.invoke(object, new Object[0]);
        }
        catch (InvocationTargetException e) {
            Throwable te = e.getTargetException();
            if (te instanceof ObjectStreamException) {
                throw (ObjectStreamException)te;
            }
            if (te instanceof RuntimeException) {
                throw (RuntimeException)te;
            }
            if (te instanceof Error) {
                throw (Error)te;
            }
            throw new IllegalStateException("Unexpected exception", te);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Method is unexpectedly inaccessible");
        }
    }

    public boolean hasNoArgConstructor() {
        return this.noArgConstructor != null;
    }

    public Object callNoArgConstructor() throws IOException {
        return SerializableClass.invokeConstructor(this.noArgConstructor, new Object[0]);
    }

    public boolean hasObjectInputConstructor() {
        return this.objectInputConstructor != null;
    }

    public Object callObjectInputConstructor(ObjectInput objectInput) throws IOException {
        return SerializableClass.invokeConstructor(this.objectInputConstructor, objectInput);
    }

    public boolean hasNoInitConstructor() {
        return this.nonInitConstructor != null;
    }

    public Object callNonInitConstructor() {
        return SerializableClass.invokeConstructorNoException(this.nonInitConstructor, new Object[0]);
    }

    private static Object invokeConstructor(Constructor<?> constructor, Object ... args) throws IOException {
        try {
            return constructor.newInstance(args);
        }
        catch (InvocationTargetException e) {
            Throwable te = e.getTargetException();
            if (te instanceof IOException) {
                throw (IOException)te;
            }
            if (te instanceof RuntimeException) {
                throw (RuntimeException)te;
            }
            if (te instanceof Error) {
                throw (Error)te;
            }
            throw new IllegalStateException("Unexpected exception", te);
        }
        catch (InstantiationException e) {
            throw new IllegalStateException("Instantiation failed unexpectedly");
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Constructor is unexpectedly inaccessible");
        }
    }

    private static Object invokeConstructorNoException(Constructor<?> constructor, Object ... args) {
        try {
            return constructor.newInstance(args);
        }
        catch (InvocationTargetException e) {
            Throwable te = e.getTargetException();
            if (te instanceof RuntimeException) {
                throw (RuntimeException)te;
            }
            if (te instanceof Error) {
                throw (Error)te;
            }
            throw new IllegalStateException("Unexpected exception", te);
        }
        catch (InstantiationException e) {
            throw new IllegalStateException("Instantiation failed unexpectedly");
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Constructor is unexpectedly inaccessible");
        }
    }

    public long getEffectiveSerialVersionUID() {
        return this.effectiveSerialVersionUID;
    }

    public Class<?> getSubjectClass() {
        return this.subject;
    }

    private static <T> Constructor<T> lookupNonInitConstructor(Class<T> subject) {
        Constructor<T> topConstructor;
        Class<T> current = subject;
        while (Serializable.class.isAssignableFrom(current)) {
            current = current.getSuperclass();
        }
        try {
            topConstructor = current.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        topConstructor.setAccessible(true);
        Constructor<?> generatedConstructor = reflectionFactory.newConstructorForSerialization(subject, topConstructor);
        generatedConstructor.setAccessible(true);
        return generatedConstructor;
    }

    <T> Constructor<T> getNoInitConstructor() {
        return this.nonInitConstructor;
    }

    <T> Constructor<T> getNoArgConstructor() {
        return this.noArgConstructor;
    }

    public String toString() {
        return String.format("Serializable %s", this.getSubjectClass());
    }
}

