/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.annotation.creator.ejb.jboss;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Collection;
import javax.ejb.AccessTimeout;
import org.jboss.metadata.annotation.creator.AbstractFinderUser;
import org.jboss.metadata.annotation.creator.Processor;
import org.jboss.metadata.annotation.creator.ProcessorUtils;
import org.jboss.metadata.annotation.finder.AnnotationFinder;
import org.jboss.metadata.ejb.jboss.JBossSessionBean31MetaData;
import org.jboss.metadata.ejb.spec.AccessTimeoutMetaData;
import org.jboss.metadata.ejb.spec.ConcurrentMethodMetaData;
import org.jboss.metadata.ejb.spec.MethodParametersMetaData;
import org.jboss.metadata.ejb.spec.NamedMethodMetaData;

public class AccessTimeoutMethodProcessor
extends AbstractFinderUser
implements Processor<JBossSessionBean31MetaData, Method> {
    public AccessTimeoutMethodProcessor(AnnotationFinder<AnnotatedElement> finder) {
        super(finder);
    }

    public Collection<Class<? extends Annotation>> getAnnotationTypes() {
        return ProcessorUtils.createAnnotationSet(AccessTimeout.class);
    }

    public void process(JBossSessionBean31MetaData metaData, Method method) {
        AccessTimeout accessTimeout = (AccessTimeout)this.finder.getAnnotation((AnnotatedElement)method, AccessTimeout.class);
        if (accessTimeout == null) {
            return;
        }
        AccessTimeoutMetaData accessTimeoutMetaData = new AccessTimeoutMetaData();
        accessTimeoutMetaData.setTimeout(accessTimeout.value());
        if (accessTimeout.unit() != null) {
            accessTimeoutMetaData.setUnit(accessTimeout.unit());
        }
        NamedMethodMetaData namedMethod = new NamedMethodMetaData();
        namedMethod.setName(method.getName());
        MethodParametersMetaData methodParamsMetaData = new MethodParametersMetaData();
        for (Class<?> parameterType : method.getParameterTypes()) {
            methodParamsMetaData.add(parameterType.getName());
        }
        namedMethod.setMethodParams(methodParamsMetaData);
        ConcurrentMethodMetaData concurrentMethod = metaData.getConcurrentMethods().get((Object)namedMethod);
        if (concurrentMethod == null) {
            concurrentMethod = new ConcurrentMethodMetaData();
            concurrentMethod.setMethod(namedMethod);
            metaData.getConcurrentMethods().put(namedMethod, concurrentMethod);
        }
        concurrentMethod.setAccessTimeout(accessTimeoutMetaData);
    }
}

