/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.service;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.modules.management.ObjectProperties;
import org.jboss.modules.ref.Reaper;
import org.jboss.modules.ref.Reference;
import org.jboss.modules.ref.WeakReference;
import org.jboss.msc.Version;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.CircularDependencyException;
import org.jboss.msc.service.Dependency;
import org.jboss.msc.service.Dependent;
import org.jboss.msc.service.DuplicateServiceException;
import org.jboss.msc.service.IdentityHashSet;
import org.jboss.msc.service.MultipleRemoveListener;
import org.jboss.msc.service.OptionalDependency;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceBuilderImpl;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceControllerImpl;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceLogger;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceNotFoundException;
import org.jboss.msc.service.ServiceRegistrationImpl;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTargetImpl;
import org.jboss.msc.service.UnlockedReadHashMap;
import org.jboss.msc.service.ValueInjection;
import org.jboss.msc.service.management.ServiceContainerMXBean;
import org.jboss.msc.service.management.ServiceStatus;
import org.jboss.msc.value.InjectedValue;

final class ServiceContainerImpl
extends ServiceTargetImpl
implements ServiceContainer {
    private static final AtomicInteger SERIAL = new AtomicInteger(1);
    static final String PROFILE_OUTPUT = AccessController.doPrivileged(new PrivilegedAction<String>(){

        @Override
        public String run() {
            return System.getProperty("jboss.msc.profile.output");
        }
    });
    private final ConcurrentMap<ServiceName, ServiceRegistrationImpl> registry = new UnlockedReadHashMap<ServiceName, ServiceRegistrationImpl>(512);
    private final long start = System.nanoTime();
    private long shutdownInitiated;
    private final List<ServiceContainer.TerminateListener> terminateListeners = new ArrayList<ServiceContainer.TerminateListener>(1);
    private final Writer profileOutput;
    private ServiceContainer.TerminateListener.Info terminateInfo = null;
    private volatile boolean down = false;
    private final ContainerExecutor executor;
    private final String name;
    private final MBeanServer mBeanServer;
    private final ObjectName objectName;
    private final ServiceContainerMXBean containerMXBean = new ServiceContainerMXBean(){

        @Override
        public ServiceStatus getServiceStatus(String name) {
            ServiceControllerImpl<?> instance;
            ServiceRegistrationImpl registration = (ServiceRegistrationImpl)ServiceContainerImpl.this.registry.get(ServiceName.parse(name));
            if (registration != null && (instance = registration.getInstance()) != null) {
                return instance.getStatus();
            }
            return null;
        }

        @Override
        public List<String> queryServiceNames() {
            Set names = ServiceContainerImpl.this.registry.keySet();
            ArrayList<String> list = new ArrayList<String>(names.size());
            for (ServiceName serviceName : names) {
                list.add(serviceName.getCanonicalName());
            }
            Collections.sort(list);
            return list;
        }

        @Override
        public List<ServiceStatus> queryServiceStatuses() {
            Collection registrations = ServiceContainerImpl.this.registry.values();
            ArrayList<ServiceStatus> list = new ArrayList<ServiceStatus>(registrations.size());
            for (ServiceRegistrationImpl registration : registrations) {
                ServiceControllerImpl<?> instance = registration.getInstance();
                if (instance == null) continue;
                list.add(instance.getStatus());
            }
            Collections.sort(list, new Comparator<ServiceStatus>(){

                @Override
                public int compare(ServiceStatus o1, ServiceStatus o2) {
                    return o1.getServiceName().compareTo(o2.getServiceName());
                }
            });
            return list;
        }

        @Override
        public void setServiceMode(String name, String mode) {
            ServiceControllerImpl<?> instance;
            ServiceRegistrationImpl registration = (ServiceRegistrationImpl)ServiceContainerImpl.this.registry.get(ServiceName.parse(name));
            if (registration != null && (instance = registration.getInstance()) != null) {
                instance.setMode(ServiceController.Mode.valueOf(mode.toUpperCase(Locale.US)));
            }
        }

        @Override
        public void dumpServices() {
            ServiceContainerImpl.this.dumpServices();
        }

        @Override
        public String dumpServicesToString() {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintStream ps = null;
            try {
                ps = new PrintStream((OutputStream)baos, false, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException(e);
            }
            ServiceContainerImpl.this.dumpServices(ps);
            ps.flush();
            try {
                return new String(baos.toByteArray(), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException(e);
            }
        }
    };
    private static final AtomicInteger executorSeq;
    private static final Thread.UncaughtExceptionHandler HANDLER;
    private static final ThreadPoolExecutor.CallerRunsPolicy POLICY;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ServiceContainerImpl(String name, int coreSize, long timeOut, TimeUnit timeOutUnit) {
        super(null);
        int serialNo = SERIAL.getAndIncrement();
        if (name == null) {
            name = String.format("anonymous-%d", serialNo);
        }
        this.name = name;
        this.executor = new ContainerExecutor(coreSize, coreSize, timeOut, timeOutUnit);
        ObjectName objectName = null;
        MBeanServer mBeanServer = null;
        try {
            objectName = new ObjectName("jboss.msc", (Hashtable<String, String>)ObjectProperties.properties((ObjectProperties.Property[])new ObjectProperties.Property[]{ObjectProperties.property((String)"type", (String)"container"), ObjectProperties.property((String)"name", (String)name)}));
            mBeanServer = ManagementFactory.getPlatformMBeanServer();
            mBeanServer.registerMBean(this.containerMXBean, objectName);
        }
        catch (Exception e) {
            ServiceLogger.ROOT.mbeanFailed(e);
        }
        this.mBeanServer = mBeanServer;
        this.objectName = objectName;
        Set set = ShutdownHookHolder.containers;
        OutputStreamWriter profileOutput = null;
        if (PROFILE_OUTPUT != null) {
            try {
                profileOutput = new OutputStreamWriter(new FileOutputStream(PROFILE_OUTPUT));
            }
            catch (FileNotFoundException e) {
                // empty catch block
            }
        }
        this.profileOutput = profileOutput;
        Set set2 = set;
        synchronized (set2) {
            if (ShutdownHookHolder.down) {
                this.down = true;
            } else {
                set.add(new WeakReference((Object)this, null, (Reaper)new Reaper<ServiceContainerImpl, Void>(){

                    public void reap(Reference<ServiceContainerImpl, Void> reference) {
                        ShutdownHookHolder.containers.remove(reference);
                    }
                }));
            }
        }
        if (objectName != null && mBeanServer != null) {
            this.addTerminateListener(new ServiceContainer.TerminateListener(){

                @Override
                public void handleTermination(ServiceContainer.TerminateListener.Info info) {
                    try {
                        ServiceContainerImpl.this.mBeanServer.unregisterMBean(ServiceContainerImpl.this.objectName);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    Writer getProfileOutput() {
        return this.profileOutput;
    }

    long getStart() {
        return this.start;
    }

    @Override
    public synchronized void addTerminateListener(ServiceContainer.TerminateListener listener) {
        if (this.terminateInfo != null) {
            listener.handleTermination(this.terminateInfo);
        } else {
            this.terminateListeners.add(listener);
        }
    }

    @Override
    public void awaitTermination() throws InterruptedException {
        LatchListener listener = new LatchListener(1);
        this.addTerminateListener(listener);
        listener.await();
    }

    @Override
    public void awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        LatchListener listener = new LatchListener(1);
        this.addTerminateListener(listener);
        listener.await(timeout, unit);
    }

    @Override
    public ServiceRegistry getServiceRegistry() {
        return this;
    }

    boolean isShutdown() {
        return this.down;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        ServiceContainerImpl serviceContainerImpl = this;
        synchronized (serviceContainerImpl) {
            if (this.down) {
                return;
            }
            this.down = true;
            this.shutdownInitiated = System.nanoTime();
        }
        MultipleRemoveListener<Runnable> shutdownListener = MultipleRemoveListener.create(new Runnable(){

            @Override
            public void run() {
                ServiceContainerImpl.this.executor.shutdown();
            }
        });
        HashSet done = new HashSet();
        for (ServiceRegistrationImpl registration : this.registry.values()) {
            ServiceControllerImpl<?> serviceInstance = registration.getInstance();
            if (serviceInstance == null || serviceInstance.getSubstate() == ServiceController.Substate.CANCELLED || !done.add(serviceInstance)) continue;
            try {
                serviceInstance.addListener(shutdownListener);
            }
            catch (IllegalArgumentException e) {
                continue;
            }
            serviceInstance.setMode(ServiceController.Mode.REMOVE);
        }
        shutdownListener.done();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isShutdownComplete() {
        ServiceContainerImpl serviceContainerImpl = this;
        synchronized (serviceContainerImpl) {
            return this.terminateInfo != null;
        }
    }

    @Override
    public void dumpServices() {
        this.dumpServices(System.out);
    }

    @Override
    public void dumpServices(PrintStream out) {
        out.printf("Services for %s:\n", this.getName());
        ConcurrentMap<ServiceName, ServiceRegistrationImpl> registry = this.registry;
        if (registry.isEmpty()) {
            out.printf("(Registry is empty)\n", new Object[0]);
        } else {
            int i = 0;
            HashSet set = new HashSet();
            for (ServiceName name : new TreeSet(registry.keySet())) {
                ServiceControllerImpl<?> instance;
                ServiceRegistrationImpl registration = (ServiceRegistrationImpl)registry.get(name);
                if (registration == null || (instance = registration.getInstance()) == null || !set.add(instance)) continue;
                ++i;
                out.printf("%s\n", instance.getStatus());
            }
            out.printf("%s services displayed\n", i);
        }
    }

    protected void finalize() throws Throwable {
        this.shutdown();
    }

    private synchronized void shutdownComplete(long started) {
        this.terminateInfo = new ServiceContainer.TerminateListener.Info(started, System.nanoTime());
        for (ServiceContainer.TerminateListener terminateListener : this.terminateListeners) {
            try {
                terminateListener.handleTermination(this.terminateInfo);
            }
            catch (Throwable t) {}
        }
    }

    Executor getExecutor() {
        return this.executor;
    }

    private ServiceRegistrationImpl getOrCreateRegistration(ServiceName name) {
        ConcurrentMap<ServiceName, ServiceRegistrationImpl> registry = this.registry;
        ServiceRegistrationImpl registration = (ServiceRegistrationImpl)registry.get(name);
        if (registration == null) {
            registration = new ServiceRegistrationImpl(this, name);
            ServiceRegistrationImpl existing = registry.putIfAbsent(name, registration);
            if (existing != null) {
                return existing;
            }
            return registration;
        }
        return registration;
    }

    @Override
    public ServiceController<?> getRequiredService(ServiceName serviceName) throws ServiceNotFoundException {
        ServiceController<?> controller = this.getService(serviceName);
        if (controller == null) {
            throw new ServiceNotFoundException("Service " + serviceName + " not found");
        }
        return controller;
    }

    @Override
    public ServiceController<?> getService(ServiceName serviceName) {
        ServiceRegistrationImpl registration = (ServiceRegistrationImpl)this.registry.get(serviceName);
        return registration == null ? null : registration.getInstance();
    }

    @Override
    public List<ServiceName> getServiceNames() {
        ArrayList<ServiceName> result = new ArrayList<ServiceName>(this.registry.size());
        for (Map.Entry registryEntry : this.registry.entrySet()) {
            if (((ServiceRegistrationImpl)registryEntry.getValue()).getInstance() == null) continue;
            result.add((ServiceName)registryEntry.getKey());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void apply(ServiceBuilderImpl<?> builder, ServiceControllerImpl<?> parent, boolean first) {
        ServiceController parentParent;
        ServiceControllerImpl<?> serviceControllerImpl = parent;
        synchronized (serviceControllerImpl) {
            IdentityHashMap<ServiceListener<?>, ServiceListener.Inheritance> genericListeners = parent.getListeners();
            ArrayList<ServiceListener> inherited = new ArrayList<ServiceListener>(4);
            ArrayList<ServiceListener> once = first ? new ArrayList<ServiceListener>(4) : null;
            for (ServiceListener listener : genericListeners.keySet()) {
                ServiceListener.Inheritance inheritance = (ServiceListener.Inheritance)((Object)genericListeners.get(listener));
                switch (inheritance) {
                    case ONCE: {
                        if (!first) break;
                        once.add(listener);
                        break;
                    }
                    case ALL: {
                        inherited.add(listener);
                        break;
                    }
                }
            }
            if (first) {
                builder.addListenerNoCheck(ServiceListener.Inheritance.NONE, once);
            }
            builder.addListenerNoCheck(ServiceListener.Inheritance.ALL, inherited);
            parentParent = parent.getParent();
        }
        if (parentParent != null) {
            this.apply(builder, (ServiceControllerImpl<?>)parentParent, false);
        }
    }

    @Override
    void apply(ServiceBuilderImpl<?> builder) {
        super.apply(builder);
        ServiceControllerImpl<?> parent = builder.getParent();
        if (parent != null) {
            this.apply(builder, parent, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    <T> ServiceController<T> install(ServiceBuilderImpl<T> serviceBuilder) throws DuplicateServiceException {
        if (this.down) {
            throw new IllegalStateException("Container is down");
        }
        this.apply(serviceBuilder);
        ServiceName name = serviceBuilder.getName();
        ServiceName[] aliases = serviceBuilder.getAliases();
        int aliasCount = aliases.length;
        ServiceRegistrationImpl primaryRegistration = this.getOrCreateRegistration(name);
        ServiceRegistrationImpl[] aliasRegistrations = new ServiceRegistrationImpl[aliasCount];
        for (int i = 0; i < aliasCount; ++i) {
            aliasRegistrations[i] = this.getOrCreateRegistration(aliases[i]);
        }
        Map<ServiceName, ServiceBuilderImpl.Dependency> dependencyMap = serviceBuilder.getDependencies();
        int dependencyCount = dependencyMap.size();
        Dependency[] dependencies = new Dependency[dependencyCount];
        List<ValueInjection<?>> valueInjections = serviceBuilder.getValueInjections();
        ArrayList outInjections = new ArrayList();
        InjectedValue<T> serviceValue = new InjectedValue<T>();
        for (Injector<T> outInjection : serviceBuilder.getOutInjections()) {
            outInjections.add(new ValueInjection(serviceValue, outInjection));
        }
        int i = 0;
        for (ServiceName serviceName : dependencyMap.keySet()) {
            Dependency registration = this.getOrCreateRegistration(serviceName);
            ServiceBuilderImpl.Dependency dependency = dependencyMap.get(serviceName);
            if (dependency.getDependencyType() == ServiceBuilder.DependencyType.OPTIONAL) {
                registration = new OptionalDependency(registration);
            }
            dependencies[i++] = registration;
            for (Injector<Object> injector : dependency.getInjectorList()) {
                valueInjections.add(new ValueInjection<Object>(registration, injector));
            }
        }
        ValueInjection[] valueInjectionArray = valueInjections.toArray(new ValueInjection[valueInjections.size()]);
        ValueInjection[] outInjectionArray = outInjections.toArray(new ValueInjection[outInjections.size()]);
        ServiceControllerImpl<T> instance = new ServiceControllerImpl<T>(serviceBuilder.getServiceValue(), dependencies, valueInjectionArray, outInjectionArray, primaryRegistration, aliasRegistrations, serviceBuilder.getListeners(), serviceBuilder.getParent());
        boolean ok = false;
        try {
            serviceValue.setValue(instance);
            instance.startInstallation();
            this.detectCircularity(instance);
            instance.commitInstallation(serviceBuilder.getInitialMode());
            ok = true;
            ServiceControllerImpl<T> serviceControllerImpl = instance;
            return serviceControllerImpl;
        }
        finally {
            if (!ok) {
                instance.rollbackInstallation();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void detectCircularity(ServiceControllerImpl<T> instance) throws CircularDependencyException {
        IdentityHashSet visited = new IdentityHashSet();
        ArrayDeque<ServiceName> visitStack = new ArrayDeque<ServiceName>();
        ServiceRegistrationImpl reg = instance.getPrimaryRegistration();
        IdentityHashSet<Dependent> dependents = null;
        ServiceRegistrationImpl serviceRegistrationImpl = reg;
        synchronized (serviceRegistrationImpl) {
            visitStack.push(instance.getName());
            dependents = reg.getDependents();
            Object object = dependents;
            synchronized (object) {
                this.detectCircularity(reg.getDependents(), instance, visited, visitStack);
            }
            object = instance;
            synchronized (object) {
                this.detectCircularity(instance.getChildren(), instance, visited, visitStack);
            }
        }
        ServiceRegistrationImpl[] arr$ = instance.getAliasRegistrations();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            ServiceRegistrationImpl alias;
            ServiceRegistrationImpl serviceRegistrationImpl2 = alias = arr$[i$];
            synchronized (serviceRegistrationImpl2) {
                IdentityHashSet<Dependent> identityHashSet = dependents = alias.getDependents();
                synchronized (identityHashSet) {
                    this.detectCircularity(dependents, instance, visited, visitStack);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void detectCircularity(IdentityHashSet<? extends Dependent> dependents, ServiceControllerImpl<?> instance, Set<ServiceControllerImpl<?>> visited, Deque<ServiceName> visitStack) {
        for (Dependent dependent : dependents) {
            ServiceRegistrationImpl reg;
            ServiceName[] cycle;
            ServiceControllerImpl<?> controller = dependent.getController();
            if (controller == instance) {
                cycle = new ServiceName[visitStack.size()];
                visitStack.toArray(cycle);
                int j = cycle.length - 1;
                for (int i = 0; i < j; ++i, --j) {
                    ServiceName temp = cycle[i];
                    cycle[i] = cycle[j];
                    cycle[j] = temp;
                }
                throw new CircularDependencyException("Container " + this.name + " has a circular dependency: " + Arrays.asList(cycle), cycle);
            }
            if (!visited.add(controller)) continue;
            cycle = controller;
            synchronized (cycle) {
                if (controller.getSubstateLocked() == ServiceController.Substate.CANCELLED) {
                    continue;
                }
            }
            ServiceRegistrationImpl j = reg = controller.getPrimaryRegistration();
            synchronized (j) {
                if (reg.getInstance() == null) {
                    continue;
                }
                visitStack.push(controller.getName());
                IdentityHashSet<Dependent> controllerDependents = reg.getDependents();
                Object temp = controllerDependents;
                synchronized (temp) {
                    this.detectCircularity(reg.getDependents(), instance, visited, visitStack);
                }
                temp = controller;
                synchronized (temp) {
                    this.detectCircularity(controller.getChildren(), instance, visited, visitStack);
                }
            }
            ServiceRegistrationImpl[] arr$ = controller.getAliasRegistrations();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                ServiceRegistrationImpl alias;
                ServiceRegistrationImpl serviceRegistrationImpl = alias = arr$[i$];
                synchronized (serviceRegistrationImpl) {
                    IdentityHashSet<Dependent> controllerDependents;
                    IdentityHashSet<Dependent> identityHashSet = controllerDependents = alias.getDependents();
                    synchronized (identityHashSet) {
                        this.detectCircularity(controllerDependents, instance, visited, visitStack);
                    }
                }
            }
            visitStack.poll();
        }
    }

    static /* synthetic */ AtomicInteger access$600() {
        return executorSeq;
    }

    static {
        ServiceLogger.ROOT.greeting(Version.getVersionString());
        executorSeq = new AtomicInteger(1);
        HANDLER = new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                ServiceLogger.ROOT.uncaughtException(e, t);
            }
        };
        POLICY = new ThreadPoolExecutor.CallerRunsPolicy();
    }

    final class ContainerExecutor
    extends ThreadPoolExecutor {
        ContainerExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit) {
            super(corePoolSize, maximumPoolSize, keepAliveTime, unit, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){
                private final int id = ServiceContainerImpl.access$600().getAndIncrement();
                private final AtomicInteger threadSeq = new AtomicInteger(1);

                @Override
                public Thread newThread(Runnable r) {
                    ServiceThread thread = new ServiceThread(r, ServiceContainerImpl.this);
                    thread.setName(String.format("MSC service thread %d-%d", this.id, this.threadSeq.getAndIncrement()));
                    thread.setUncaughtExceptionHandler(HANDLER);
                    return thread;
                }
            }, POLICY);
        }

        @Override
        protected void afterExecute(Runnable r, Throwable t) {
            super.afterExecute(r, t);
            if (t != null) {
                HANDLER.uncaughtException(Thread.currentThread(), t);
            }
        }

        @Override
        protected void terminated() {
            ServiceContainerImpl.this.shutdownComplete(ServiceContainerImpl.this.shutdownInitiated);
        }
    }

    static class ServiceThread
    extends Thread {
        private final ServiceContainerImpl container;

        ServiceThread(Runnable runnable, ServiceContainerImpl container) {
            super(runnable);
            this.container = container;
        }

        ServiceContainerImpl getContainer() {
            return this.container;
        }
    }

    static final class LatchListener
    extends CountDownLatch
    implements ServiceContainer.TerminateListener {
        LatchListener(int count) {
            super(count);
        }

        @Override
        public void handleTermination(ServiceContainer.TerminateListener.Info info) {
            this.countDown();
        }
    }

    private static final class ShutdownHookHolder {
        private static final Set<Reference<ServiceContainerImpl, Void>> containers;
        private static boolean down;

        private ShutdownHookHolder() {
        }

        static {
            down = false;
            containers = new HashSet<Reference<ServiceContainerImpl, Void>>();
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    Thread hook = new Thread(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            LatchListener listener;
                            Set set;
                            Set set2 = set = containers;
                            synchronized (set2) {
                                down = true;
                                listener = new LatchListener(set.size());
                                for (Reference containerRef : set) {
                                    ServiceContainerImpl container = (ServiceContainerImpl)containerRef.get();
                                    if (container == null) {
                                        listener.countDown();
                                        continue;
                                    }
                                    container.addTerminateListener(listener);
                                    container.shutdown();
                                }
                                set.clear();
                            }
                            while (true) {
                                try {
                                    listener.await();
                                }
                                catch (InterruptedException interruptedException) {
                                    continue;
                                }
                                break;
                            }
                        }
                    }, "MSC Shutdown Thread");
                    hook.setDaemon(false);
                    Runtime.getRuntime().addShutdownHook(hook);
                    return null;
                }
            });
        }
    }
}

