/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.service;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Locale;
import org.jboss.logging.Logger;
import org.jboss.msc.service.ServiceLogger;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.ValueInjection;

public class ServiceLogger_$logger
implements ServiceLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ServiceLogger_$logger.class.getName();
    protected final Logger log;
    private static final Locale LOCALE = Locale.ROOT;

    public ServiceLogger_$logger(Logger log) {
        this.log = log;
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void greeting(String version) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.greeting$str(), (Object)version);
    }

    protected String greeting$str() {
        return "JBoss MSC version %s";
    }

    @Override
    public final void startFailed(StartException cause, ServiceName serviceName) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)cause, this.startFailed$str(), (Object)serviceName);
    }

    protected String startFailed$str() {
        return "MSC000001: Failed to start %s";
    }

    @Override
    public final void listenerFailed(Throwable cause, Object listener) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.listenerFailed$str(), listener);
    }

    protected String listenerFailed$str() {
        return "MSC000002: Invocation of listener \"%s\" failed";
    }

    @Override
    public final void exceptionAfterComplete(Throwable cause, ServiceName serviceName) {
        this.log.logf(FQCN, Logger.Level.WARN, cause, this.exceptionAfterComplete$str(), (Object)serviceName);
    }

    protected String exceptionAfterComplete$str() {
        return "MSC000003: Exception thrown after start was already completed in %s";
    }

    @Override
    public final void stopFailed(Throwable cause, ServiceName serviceName) {
        this.log.logf(FQCN, Logger.Level.WARN, cause, this.stopFailed$str(), (Object)serviceName);
    }

    protected String stopFailed$str() {
        return "MSC000004: Failure during stop of %s";
    }

    @Override
    public final void stopServiceMissing(ServiceName serviceName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.stopServiceMissing$str(), (Object)serviceName);
    }

    protected String stopServiceMissing$str() {
        return "MSC000005: Unexpected disappearance of %s during stop";
    }

    @Override
    public final void uninjectFailed(Throwable cause, ServiceName serviceName, ValueInjection<?> valueInjection) {
        this.log.logf(FQCN, Logger.Level.WARN, cause, this.uninjectFailed$str(), (Object)serviceName, valueInjection);
    }

    protected String uninjectFailed$str() {
        return "MSC000006: Uninjection \"%2$s\" of %1$s failed unexpectedly";
    }

    @Override
    public final void internalServiceError(Throwable cause, ServiceName serviceName) {
        this.log.logf(FQCN, Logger.Level.WARN, cause, this.internalServiceError$str(), (Object)serviceName);
    }

    protected String internalServiceError$str() {
        return "MSC000007: An internal service error has occurred while processing an operation on %s";
    }

    @Override
    public final void uncaughtException(Throwable cause, Thread thread) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.uncaughtException$str(), (Object)thread);
    }

    protected String uncaughtException$str() {
        return "MSC000008: Worker thread %s threw an uncaught exception";
    }

    @Override
    public final void profileOutputCloseFailed(IOException cause) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.profileOutputCloseFailed$str(), (Object)cause);
    }

    protected String profileOutputCloseFailed$str() {
        return "MSC000009: An error occurred while trying to close the profile output file: %s";
    }

    @Override
    public final void mbeanFailed(Exception e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.mbeanFailed$str(), new Object[0]);
    }

    protected String mbeanFailed$str() {
        return "MSC000010: Failed to register MBean with MBeanServer";
    }

    protected String serviceNotStarted$str() {
        return "MSC000011: Service not started";
    }

    @Override
    public final IllegalStateException serviceNotStarted() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.serviceNotStarted$str(), new Object[0]));
        ServiceLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    @Override
    public final void injectFailed(Throwable cause, ServiceName serviceName) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.injectFailed$str(), (Object)serviceName);
    }

    protected String injectFailed$str() {
        return "MSC000012: Injection failed for service %s";
    }
}

