/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.arjuna.objectstore.jdbc.accessors;

import com.arjuna.ats.internal.arjuna.objectstore.jdbc.accessors.DynamicDataSourceJDBCAccess;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;

public class SimplePooledDynamicDataSourceJDBCAccess
extends DynamicDataSourceJDBCAccess {
    private List<WrappedConnection> unallocatedConnections = Collections.synchronizedList(new ArrayList());
    private List<WrappedConnection> allocatedConnections = Collections.synchronizedList(new ArrayList());

    public void finalize() {
        for (WrappedConnection connection : this.unallocatedConnections) {
            try {
                connection.closeImpl();
            }
            catch (SQLException sQLException) {}
        }
        this.unallocatedConnections.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection getConnection() throws SQLException {
        WrappedConnection connection;
        List<WrappedConnection> list = this.unallocatedConnections;
        synchronized (list) {
            if (this.unallocatedConnections.isEmpty()) {
                Connection connectionImpl = super.getConnection();
                this.unallocatedConnections.add(new WrappedConnection(connectionImpl));
            }
            connection = this.unallocatedConnections.remove(0);
            this.allocatedConnections.add(connection);
        }
        return connection;
    }

    private class WrappedConnection
    implements Connection {
        private final Connection connectionImpl;

        public WrappedConnection(Connection connectionImpl) {
            this.connectionImpl = connectionImpl;
        }

        @Override
        public <T> T unwrap(Class<T> iface) throws SQLException {
            return this.connectionImpl.unwrap(iface);
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) throws SQLException {
            return this.connectionImpl.isWrapperFor(iface);
        }

        @Override
        public Statement createStatement() throws SQLException {
            return this.connectionImpl.createStatement();
        }

        @Override
        public PreparedStatement prepareStatement(String sql) throws SQLException {
            return this.connectionImpl.prepareStatement(sql);
        }

        @Override
        public CallableStatement prepareCall(String sql) throws SQLException {
            return this.connectionImpl.prepareCall(sql);
        }

        @Override
        public String nativeSQL(String sql) throws SQLException {
            return this.connectionImpl.nativeSQL(sql);
        }

        @Override
        public void setAutoCommit(boolean autoCommit) throws SQLException {
            this.connectionImpl.setAutoCommit(autoCommit);
        }

        @Override
        public boolean getAutoCommit() throws SQLException {
            return this.connectionImpl.getAutoCommit();
        }

        @Override
        public void commit() throws SQLException {
            this.connectionImpl.commit();
        }

        @Override
        public void rollback() throws SQLException {
            this.connectionImpl.rollback();
        }

        @Override
        public void close() throws SQLException {
            SimplePooledDynamicDataSourceJDBCAccess.this.allocatedConnections.remove(this);
            SimplePooledDynamicDataSourceJDBCAccess.this.unallocatedConnections.add(this);
        }

        @Override
        public boolean isClosed() throws SQLException {
            return this.connectionImpl.isClosed();
        }

        @Override
        public DatabaseMetaData getMetaData() throws SQLException {
            return this.connectionImpl.getMetaData();
        }

        @Override
        public void setReadOnly(boolean readOnly) throws SQLException {
            this.connectionImpl.setReadOnly(readOnly);
        }

        @Override
        public boolean isReadOnly() throws SQLException {
            return this.connectionImpl.isReadOnly();
        }

        @Override
        public void setCatalog(String catalog) throws SQLException {
            this.connectionImpl.setCatalog(catalog);
        }

        @Override
        public String getCatalog() throws SQLException {
            return this.connectionImpl.getCatalog();
        }

        @Override
        public void setTransactionIsolation(int level) throws SQLException {
            this.connectionImpl.setTransactionIsolation(level);
        }

        @Override
        public int getTransactionIsolation() throws SQLException {
            return this.connectionImpl.getTransactionIsolation();
        }

        @Override
        public SQLWarning getWarnings() throws SQLException {
            return this.connectionImpl.getWarnings();
        }

        @Override
        public void clearWarnings() throws SQLException {
            this.connectionImpl.clearWarnings();
        }

        @Override
        public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
            return this.connectionImpl.createStatement(resultSetType, resultSetConcurrency);
        }

        @Override
        public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
            return this.connectionImpl.prepareStatement(sql, resultSetType, resultSetConcurrency);
        }

        @Override
        public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
            return this.connectionImpl.prepareCall(sql, resultSetType, resultSetConcurrency);
        }

        @Override
        public Map<String, Class<?>> getTypeMap() throws SQLException {
            return this.connectionImpl.getTypeMap();
        }

        @Override
        public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
            this.connectionImpl.setTypeMap(map);
        }

        @Override
        public void setHoldability(int holdability) throws SQLException {
            this.connectionImpl.setHoldability(holdability);
        }

        @Override
        public int getHoldability() throws SQLException {
            return this.connectionImpl.getHoldability();
        }

        @Override
        public Savepoint setSavepoint() throws SQLException {
            return this.connectionImpl.setSavepoint();
        }

        @Override
        public Savepoint setSavepoint(String name) throws SQLException {
            return this.connectionImpl.setSavepoint(name);
        }

        @Override
        public void rollback(Savepoint savepoint) throws SQLException {
            this.connectionImpl.rollback(savepoint);
        }

        @Override
        public void releaseSavepoint(Savepoint savepoint) throws SQLException {
            this.connectionImpl.releaseSavepoint(savepoint);
        }

        @Override
        public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
            return this.connectionImpl.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
        }

        @Override
        public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
            return this.connectionImpl.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }

        @Override
        public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
            return this.connectionImpl.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }

        @Override
        public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
            return this.connectionImpl.prepareStatement(sql, autoGeneratedKeys);
        }

        @Override
        public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
            return this.connectionImpl.prepareStatement(sql, columnIndexes);
        }

        @Override
        public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
            return this.connectionImpl.prepareStatement(sql, columnNames);
        }

        @Override
        public Clob createClob() throws SQLException {
            return this.connectionImpl.createClob();
        }

        @Override
        public Blob createBlob() throws SQLException {
            return this.connectionImpl.createBlob();
        }

        @Override
        public NClob createNClob() throws SQLException {
            return this.connectionImpl.createNClob();
        }

        @Override
        public SQLXML createSQLXML() throws SQLException {
            return this.connectionImpl.createSQLXML();
        }

        @Override
        public boolean isValid(int timeout) throws SQLException {
            return this.connectionImpl.isValid(timeout);
        }

        @Override
        public void setClientInfo(String name, String value) throws SQLClientInfoException {
            this.connectionImpl.setClientInfo(name, value);
        }

        @Override
        public void setClientInfo(Properties properties) throws SQLClientInfoException {
            this.connectionImpl.setClientInfo(properties);
        }

        @Override
        public String getClientInfo(String name) throws SQLException {
            return this.connectionImpl.getClientInfo(name);
        }

        @Override
        public Properties getClientInfo() throws SQLException {
            return this.connectionImpl.getClientInfo();
        }

        @Override
        public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
            return this.connectionImpl.createArrayOf(typeName, elements);
        }

        @Override
        public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
            return this.connectionImpl.createStruct(typeName, attributes);
        }

        @Override
        public void setSchema(String schema) throws SQLException {
            this.connectionImpl.setSchema(schema);
        }

        @Override
        public String getSchema() throws SQLException {
            return this.connectionImpl.getSchema();
        }

        @Override
        public void abort(Executor executor) throws SQLException {
            this.connectionImpl.abort(executor);
        }

        @Override
        public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
            this.connectionImpl.setNetworkTimeout(executor, milliseconds);
        }

        @Override
        public int getNetworkTimeout() throws SQLException {
            return this.connectionImpl.getNetworkTimeout();
        }

        public void closeImpl() throws SQLException {
            this.connectionImpl.close();
        }
    }
}

