/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.arjuna.recovery;

import com.arjuna.ats.arjuna.common.recoveryPropertyManager;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.recovery.RecoveryActivator;
import com.arjuna.common.internal.util.ClassloadingUtility;
import java.util.ArrayList;
import java.util.List;

public class RecActivatorLoader {
    private final List<RecoveryActivator> _recoveryActivators = new ArrayList<RecoveryActivator>();

    public RecActivatorLoader() {
        this.loadRecoveryActivators();
    }

    private void loadRecoveryActivators() {
        List<String> activatorNames = recoveryPropertyManager.getRecoveryEnvironmentBean().getRecoveryActivatorClassNames();
        for (String activatorName : activatorNames) {
            RecoveryActivator recoveryActivator = (RecoveryActivator)ClassloadingUtility.loadAndInstantiateClass(RecoveryActivator.class, (String)activatorName, null);
            if (recoveryActivator == null) continue;
            this._recoveryActivators.add(recoveryActivator);
        }
    }

    public void startRecoveryActivators() throws RuntimeException {
        tsLogger.logger.debug((Object)"Start RecoveryActivators");
        for (RecoveryActivator recoveryActivator : this._recoveryActivators) {
            if (recoveryActivator.startRCservice()) continue;
            throw new RuntimeException(tsLogger.i18NLogger.get_recovery_RecActivatorLoader_initfailed(recoveryActivator.getClass().getCanonicalName()));
        }
    }
}

