/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jts.orbspecific;

import com.arjuna.ArjunaOTS.ActionControl;
import com.arjuna.ArjunaOTS.ActionControlHelper;
import com.arjuna.ats.arjuna.coordinator.CheckedAction;
import com.arjuna.ats.arjuna.coordinator.TxControl;
import com.arjuna.ats.internal.jts.ControlWrapper;
import com.arjuna.ats.internal.jts.OTSImpleManager;
import com.arjuna.ats.internal.jts.context.ContextManager;
import com.arjuna.ats.internal.jts.coordinator.CheckedActions;
import com.arjuna.ats.internal.jts.orbspecific.ControlImple;
import com.arjuna.ats.internal.jts.orbspecific.coordinator.ArjunaTransactionImple;
import com.arjuna.ats.jts.extensions.ThreadAssociationControl;
import com.arjuna.ats.jts.logging.jtsLogger;
import com.arjuna.ats.jts.utils.Utility;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INVALID_TRANSACTION;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.NO_MEMORY;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.OBJ_ADAPTER;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSACTION_ROLLEDBACK;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.UserException;
import org.omg.CosTransactions.Control;
import org.omg.CosTransactions.Coordinator;
import org.omg.CosTransactions.Current;
import org.omg.CosTransactions.HeuristicHazard;
import org.omg.CosTransactions.HeuristicMixed;
import org.omg.CosTransactions.Inactive;
import org.omg.CosTransactions.InvalidControl;
import org.omg.CosTransactions.NoTransaction;
import org.omg.CosTransactions.Status;
import org.omg.CosTransactions.SubtransactionsUnavailable;
import org.omg.CosTransactions.Unavailable;

public class CurrentImple
extends LocalObject
implements Current,
com.arjuna.ats.jts.extensions.Current {
    public static final int TX_BEGUN = 0;
    public static final int TX_COMMITTED = 1;
    public static final int TX_ABORTED = 2;
    public static final int TX_SUSPENDED = 3;
    public static final int TX_RESUMED = 4;
    protected static ContextManager _theManager = null;
    private static ThreadLocal otsTransactionTimeout = new ThreadLocal();

    public CurrentImple() {
        if (jtsLogger.logger.isTraceEnabled()) {
            jtsLogger.logger.trace((Object)"CurrentImple::CurrentImple ()");
        }
        _theManager = new ContextManager();
    }

    @Override
    public void begin() throws SubtransactionsUnavailable, SystemException {
        ControlWrapper currentAction = _theManager.current();
        if (currentAction == null) {
            if (jtsLogger.logger.isTraceEnabled()) {
                jtsLogger.logger.trace((Object)"CurrentImple::begin - creating new top-level transaction.");
            }
            currentAction = OTSImpleManager.localFactory() ? new ControlWrapper(OTSImpleManager.factory().createLocal(this.get_timeout())) : new ControlWrapper(OTSImpleManager.get_factory().create(this.get_timeout()));
        } else {
            if (jtsLogger.logger.isTraceEnabled()) {
                jtsLogger.logger.trace((Object)"CurrentImple::begin - creating new subtransaction.");
            }
            try {
                currentAction = currentAction.create_subtransaction();
            }
            catch (Unavailable ex) {
                throw new INVALID_TRANSACTION(60005, CompletionStatus.COMPLETED_NO);
            }
            catch (Inactive e) {
                throw new INVALID_TRANSACTION(20001, CompletionStatus.COMPLETED_NO);
            }
            catch (NO_MEMORY nme) {
                System.gc();
                throw nme;
            }
            catch (SystemException sysEx) {
                throw new INVALID_TRANSACTION(20001, CompletionStatus.COMPLETED_NO);
            }
            catch (OutOfMemoryError me) {
                System.gc();
                throw new NO_MEMORY(0, CompletionStatus.COMPLETED_NO);
            }
        }
        _theManager.pushAction(currentAction);
        try {
            ThreadAssociationControl.updateAssociation(currentAction, 0);
        }
        catch (Exception e) {
            try {
                this.rollback_only();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        currentAction = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void commit(boolean report_heuristics) throws NoTransaction, HeuristicMixed, HeuristicHazard, SystemException {
        ControlWrapper currentAction;
        if (jtsLogger.logger.isTraceEnabled()) {
            jtsLogger.logger.trace((Object)("CurrentImple::commit ( " + report_heuristics + " )"));
        }
        if ((currentAction = _theManager.current()) == null) throw new NoTransaction();
        try {
            ThreadAssociationControl.updateAssociation(currentAction, 1);
        }
        catch (Exception e) {
            this.rollback_only();
        }
        try {
            currentAction.commit(report_heuristics);
            _theManager.popAction();
            return;
        }
        catch (TRANSACTION_ROLLEDBACK e1) {
            _theManager.popAction();
            throw e1;
        }
        catch (HeuristicMixed e2) {
            _theManager.popAction();
            if (!report_heuristics) return;
            throw e2;
        }
        catch (HeuristicHazard e3) {
            _theManager.popAction();
            if (!report_heuristics) return;
            throw e3;
        }
        catch (SystemException e4) {
            _theManager.popAction();
            throw e4;
        }
        catch (Unavailable e5) {
            _theManager.popAction();
            throw new INVALID_TRANSACTION();
        }
    }

    @Override
    public void rollback() throws NoTransaction, SystemException {
        ControlWrapper currentAction;
        if (jtsLogger.logger.isTraceEnabled()) {
            jtsLogger.logger.trace((Object)"CurrentImple::rollback ()");
        }
        if ((currentAction = _theManager.current()) != null) {
            ThreadAssociationControl.updateAssociation(currentAction, 2);
            try {
                currentAction.rollback();
                _theManager.popAction();
            }
            catch (INVALID_TRANSACTION e1) {
                _theManager.popAction();
                throw e1;
            }
            catch (SystemException e2) {
                _theManager.popAction();
                throw e2;
            }
            catch (Unavailable e) {
                _theManager.popAction();
                throw new INVALID_TRANSACTION();
            }
        } else {
            throw new NoTransaction();
        }
    }

    @Override
    public void rollback_only() throws NoTransaction, SystemException {
        ControlWrapper currentAction;
        if (jtsLogger.logger.isTraceEnabled()) {
            jtsLogger.logger.trace((Object)"CurrentImple::rollback_only ()");
        }
        if ((currentAction = _theManager.current()) != null) {
            try {
                currentAction.rollback_only();
            }
            catch (Inactive exc) {
                throw new INVALID_TRANSACTION(20001, CompletionStatus.COMPLETED_NO);
            }
            catch (SystemException e) {
                throw e;
            }
            catch (Unavailable ex) {
                throw new NoTransaction();
            }
        } else {
            throw new NoTransaction();
        }
    }

    @Override
    public Status get_status() throws SystemException {
        Status stat;
        ControlWrapper currentAction = _theManager.current();
        Status status = stat = currentAction == null ? Status.StatusNoTransaction : currentAction.get_status();
        if (jtsLogger.logger.isTraceEnabled()) {
            jtsLogger.logger.trace((Object)("CurrentImple::get_status - returning " + Utility.stringStatus(stat)));
        }
        return stat;
    }

    @Override
    public String get_transaction_name() throws SystemException {
        String ch;
        ControlWrapper currentAction = _theManager.current();
        String string = ch = currentAction == null ? "null" : currentAction.get_transaction_name();
        if (jtsLogger.logger.isTraceEnabled()) {
            jtsLogger.logger.trace((Object)("CurrentImple::get_transaction_name - returning " + ch));
        }
        return ch;
    }

    @Override
    public synchronized void set_timeout(int seconds) throws SystemException {
        if (jtsLogger.logger.isTraceEnabled()) {
            jtsLogger.logger.trace((Object)("CurrentImple::set_timeout ( " + seconds + " )"));
        }
        if (seconds > 0) {
            otsTransactionTimeout.set(new Integer(seconds));
        } else {
            if (seconds < 0) {
                throw new BAD_PARAM(45001, CompletionStatus.COMPLETED_NO);
            }
            otsTransactionTimeout.set(null);
        }
    }

    public final synchronized int get_timeout() throws SystemException {
        Integer value = (Integer)otsTransactionTimeout.get();
        int v = 0;
        v = value != null ? value : TxControl.getDefaultTimeout();
        if (jtsLogger.logger.isTraceEnabled()) {
            jtsLogger.logger.trace((Object)("CurrentImple::get_timeout - returning " + v));
        }
        return v;
    }

    @Override
    public void setCheckedAction(CheckedAction ca) throws SystemException {
        if (jtsLogger.logger.isTraceEnabled()) {
            jtsLogger.logger.trace((Object)("CurrentImple::setCheckedAction ( " + ca + " )"));
        }
        CheckedActions.set(ca);
    }

    @Override
    public CheckedAction getCheckedAction() throws SystemException {
        if (jtsLogger.logger.isTraceEnabled()) {
            jtsLogger.logger.trace((Object)"CurrentImple::getCheckedAction ()");
        }
        return CheckedActions.get();
    }

    @Override
    public Control get_control() throws SystemException {
        ControlWrapper theControl = _theManager.current();
        if (theControl == null) {
            return null;
        }
        try {
            return theControl.get_control();
        }
        catch (Unavailable e) {
            return null;
        }
    }

    @Override
    public Control suspend() throws SystemException {
        ControlWrapper actPtr;
        if (jtsLogger.logger.isTraceEnabled()) {
            jtsLogger.logger.trace((Object)"CurrentImple::suspend ()");
        }
        if ((actPtr = _theManager.popAction()) == null) {
            ThreadAssociationControl.updateAssociation(null, 3);
            return null;
        }
        ThreadAssociationControl.updateAssociation(actPtr, 3);
        _theManager.purgeActions();
        if (actPtr.isLocal()) {
            return actPtr.getImple().getControl();
        }
        return actPtr.getControl();
    }

    @Override
    public void resume(Control which) throws InvalidControl, SystemException {
        if (jtsLogger.logger.isTraceEnabled()) {
            jtsLogger.logger.trace((Object)("CurrentImple::resume ( " + which + " )"));
        }
        _theManager.purgeActions();
        if (which == null) {
            ThreadAssociationControl.updateAssociation(null, 4);
            return;
        }
        Control cont = which;
        boolean invalidControl = false;
        try {
            Coordinator coord = cont.get_coordinator();
            if (!coord.is_top_level_transaction()) {
                ActionControl actControl = null;
                try {
                    actControl = ActionControlHelper.narrow(cont);
                    if (actControl == null) {
                        throw new BAD_PARAM();
                    }
                }
                catch (Exception e) {
                    actControl = null;
                }
                invalidControl = actControl != null ? _theManager.addActionControlHierarchy(actControl) : _theManager.addRemoteHierarchy(cont);
            }
            coord = null;
        }
        catch (OBJECT_NOT_EXIST coord) {
        }
        catch (UNKNOWN coord) {
        }
        catch (OBJ_ADAPTER coord) {
        }
        catch (SystemException sysEx) {
            throw new InvalidControl();
        }
        catch (UserException usrEx) {
            throw new InvalidControl();
        }
        catch (NullPointerException npx) {
            throw new InvalidControl();
        }
        catch (Exception ex) {
            throw new BAD_OPERATION("CurrentImple.resume: " + ex.toString());
        }
        try {
            if (!invalidControl) {
                ControlWrapper wrap = new ControlWrapper(cont);
                ThreadAssociationControl.updateAssociation(wrap, 4);
                _theManager.pushAction(wrap);
            }
        }
        catch (NullPointerException npx) {
            invalidControl = true;
        }
        cont = null;
        if (invalidControl) {
            throw new InvalidControl();
        }
    }

    public final ContextManager contextManager() {
        return _theManager;
    }

    public void resumeImple(ControlImple which) throws InvalidControl, SystemException {
        if (jtsLogger.logger.isTraceEnabled()) {
            jtsLogger.logger.trace((Object)("CurrentImple::resumeImple ( " + which + " )"));
        }
        _theManager.purgeActions();
        if (which == null) {
            ThreadAssociationControl.updateAssociation(null, 4);
            return;
        }
        boolean invalidControl = _theManager.addControlImpleHierarchy(which);
        try {
            if (!invalidControl) {
                ControlWrapper wrap = new ControlWrapper(which);
                ThreadAssociationControl.updateAssociation(wrap, 4);
                _theManager.pushAction(wrap);
            }
        }
        catch (NullPointerException npx) {
            npx.printStackTrace();
            invalidControl = true;
        }
        if (invalidControl) {
            throw new InvalidControl();
        }
    }

    public void resumeWrapper(ControlWrapper which) throws InvalidControl, SystemException {
        if (jtsLogger.logger.isTraceEnabled()) {
            jtsLogger.logger.trace((Object)("CurrentImple::resumeWrapper ( " + which + " )"));
        }
        if (which != null) {
            ArjunaTransactionImple tx2;
            ArjunaTransactionImple arjunaTransactionImple = tx2 = which.getImple() == null ? null : which.getImple().getImplHandle();
            if (which.isLocal() && tx2 != null) {
                this.resumeImple(which.getImple());
            } else {
                this.resume(which.getControl());
            }
        } else {
            this.resumeImple(null);
        }
    }

    public ControlWrapper suspendWrapper() throws SystemException {
        ControlWrapper actPtr;
        if (jtsLogger.logger.isTraceEnabled()) {
            jtsLogger.logger.trace((Object)"CurrentImple::suspendWrapper ()");
        }
        if ((actPtr = _theManager.popAction()) == null) {
            ThreadAssociationControl.updateAssociation(null, 3);
            return null;
        }
        ThreadAssociationControl.updateAssociation(actPtr, 3);
        _theManager.purgeActions();
        return actPtr;
    }

    public ControlWrapper getControlWrapper() throws SystemException {
        if (jtsLogger.logger.isTraceEnabled()) {
            jtsLogger.logger.trace((Object)"CurrentImple.getControlWrapper ()");
        }
        return _theManager.current();
    }
}

