/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.metadata.internal;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import org.jboss.osgi.metadata.Parameter;
import org.jboss.osgi.metadata.internal.ValueCreator;

public class AbstractParameter
implements Parameter {
    private final Collection<String> values;
    private final ValueCreator<?> vc;

    public AbstractParameter(ValueCreator<?> vc) {
        this.values = new HashSet<String>();
        this.vc = vc;
    }

    public AbstractParameter(ValueCreator<?> vc, String parameter) {
        this.values = new LinkedHashSet<String>();
        this.vc = vc;
        this.addValue(parameter);
    }

    @Override
    public void addValue(String value) {
        this.values.add(value);
    }

    @Override
    public Object getValue() {
        if (this.values.isEmpty()) {
            return null;
        }
        String result = this.values.toString();
        result = result.substring(1, result.length() - 1);
        return this.vc.createValue(result);
    }

    @Override
    public boolean isCollection() {
        return this.values.size() > 1;
    }

    public String toString() {
        return "[" + this.getValue() + "]";
    }
}

