/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.resolver.spi;

import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.jboss.osgi.metadata.VersionRange;
import org.jboss.osgi.resolver.ResolverMessages;
import org.jboss.osgi.resolver.XAttributeSupport;
import org.jboss.osgi.resolver.XCapability;
import org.jboss.osgi.resolver.XDirectiveSupport;
import org.jboss.osgi.resolver.XHostRequirement;
import org.jboss.osgi.resolver.XIdentityCapability;
import org.jboss.osgi.resolver.XPackageRequirement;
import org.jboss.osgi.resolver.XRequirement;
import org.jboss.osgi.resolver.XResource;
import org.jboss.osgi.resolver.XResourceRequirement;
import org.jboss.osgi.resolver.spi.AbstractCapability;
import org.jboss.osgi.resolver.spi.AbstractElement;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;

public class AbstractRequirement
extends AbstractElement
implements XHostRequirement,
XPackageRequirement,
XResourceRequirement {
    private final XResource resource;
    private final String namespace;
    private XAttributeSupport attributes;
    private XDirectiveSupport directives;
    private String canonicalName;
    private boolean optional;
    private Filter filter;

    public AbstractRequirement(XResource resource, String namespace, Map<String, Object> atts, Map<String, String> dirs) {
        if (resource == null) {
            throw ResolverMessages.MESSAGES.illegalArgumentNull("resource");
        }
        if (namespace == null) {
            throw ResolverMessages.MESSAGES.illegalArgumentNull("namespace");
        }
        if (atts == null) {
            throw ResolverMessages.MESSAGES.illegalArgumentNull("attributes");
        }
        if (dirs == null) {
            throw ResolverMessages.MESSAGES.illegalArgumentNull("directives");
        }
        this.resource = resource;
        this.namespace = namespace;
        this.attributes = new AbstractElement.AttributeSupporter(atts);
        this.directives = new AbstractElement.DirectiveSupporter(dirs);
    }

    @Override
    public Resource getResource() {
        return this.resource;
    }

    public boolean isMutable() {
        return this.resource.isMutable();
    }

    public void ensureImmutable() {
        if (this.isMutable()) {
            throw ResolverMessages.MESSAGES.illegalStateInvalidAccessToMutableResource();
        }
    }

    public void ensureMutable() {
        if (!this.isMutable()) {
            throw ResolverMessages.MESSAGES.illegalStateInvalidAccessToImmutableResource();
        }
    }

    static String getNamespaceValue(XRequirement req) {
        String namespaceValue = (String)req.getAttribute(req.getNamespace());
        if (namespaceValue == null) {
            namespaceValue = AbstractRequirement.namespaceValueFromFilter(AbstractRequirement.getFilterFromDirective(req), req.getNamespace());
        }
        if (namespaceValue == null) {
            throw ResolverMessages.MESSAGES.illegalStateCannotObtainNamespaceValue(req.getNamespace());
        }
        return namespaceValue;
    }

    @Override
    public void validate() {
        this.filter = AbstractRequirement.getFilterFromDirective(this);
        this.attributes = new AbstractElement.AttributeSupporter(Collections.unmodifiableMap(this.attributes.getAttributes()));
        this.directives = new AbstractElement.DirectiveSupporter(Collections.unmodifiableMap(this.directives.getDirectives()));
        String resdir = this.getDirective("resolution");
        this.optional = "optional".equals(resdir);
        AbstractRequirement.getNamespaceValue(this);
        this.canonicalName = this.toString();
    }

    public static Filter getFilterFromDirective(Requirement req) {
        String filterdir = req.getDirectives().get("filter");
        if (filterdir != null) {
            try {
                return FrameworkUtil.createFilter((String)filterdir);
            }
            catch (InvalidSyntaxException e) {
                throw ResolverMessages.MESSAGES.illegalArgumentInvalidFilterDirective(filterdir);
            }
        }
        return null;
    }

    public static String namespaceValueFromFilter(Filter filter, String namespace) {
        String filterstr;
        int index;
        String result = null;
        if (filter != null && (index = (filterstr = filter.toString()).indexOf("(" + namespace + "=")) >= 0) {
            result = filterstr.substring(index + namespace.length() + 2);
            result = result.substring(0, result.indexOf(")"));
        }
        return result;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public boolean isOptional() {
        return this.optional;
    }

    @Override
    public Map<String, String> getDirectives() {
        return this.directives.getDirectives();
    }

    @Override
    public String getDirective(String key) {
        return this.directives.getDirective(key);
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.attributes.getAttributes();
    }

    @Override
    public Object getAttribute(String key) {
        return this.attributes.getAttribute(key);
    }

    @Override
    public <T extends XRequirement> T adapt(Class<T> clazz) {
        AbstractRequirement result = null;
        if (XResourceRequirement.class == clazz && "osgi.wiring.bundle".equals(this.getNamespace())) {
            result = this;
        } else if (XHostRequirement.class == clazz && "osgi.wiring.host".equals(this.getNamespace())) {
            result = this;
        } else if (XPackageRequirement.class == clazz && "osgi.wiring.package".equals(this.getNamespace())) {
            result = this;
        }
        return (T)result;
    }

    @Override
    public boolean matches(Capability cap) {
        boolean matches;
        this.ensureImmutable();
        boolean bl = matches = this.namespace.equals(cap.getNamespace()) && this.matchFilter(cap);
        if (matches) {
            if ("osgi.wiring.bundle".equals(this.getNamespace())) {
                matches = this.matchesResourceRequirement(cap);
            } else if ("osgi.wiring.host".equals(this.getNamespace())) {
                matches = this.matchesHostRequirement(cap);
            } else if ("osgi.wiring.package".equals(this.getNamespace())) {
                matches = this.matchesPackageRequirement(cap);
            } else {
                Object reqval = this.getAttribute(this.getNamespace());
                Object capval = cap.getAttributes().get(this.getNamespace());
                matches = reqval == null || reqval.equals(capval);
            }
        }
        return matches;
    }

    private boolean matchesResourceRequirement(Capability cap) {
        String nsvalue = (String)this.getAttribute(this.getNamespace());
        if (nsvalue != null && !nsvalue.equals(cap.getAttributes().get(this.getNamespace()))) {
            return false;
        }
        if (this.getResource() == cap.getResource()) {
            return false;
        }
        if (this.getVersionRange() != null) {
            Version version = AbstractCapability.getVersion(cap, "bundle-version");
            if (!this.getVersionRange().isInRange(version)) {
                return false;
            }
        }
        return true;
    }

    private boolean matchesHostRequirement(Capability cap) {
        String nsvalue = (String)this.getAttribute(this.getNamespace());
        if (nsvalue != null && !nsvalue.equals(cap.getAttributes().get(this.getNamespace()))) {
            return false;
        }
        if (this.getVersionRange() != null) {
            Version version = AbstractCapability.getVersion(cap, "bundle-version");
            if (!this.getVersionRange().isInRange(version)) {
                return false;
            }
        }
        return true;
    }

    private boolean matchesPackageRequirement(Capability cap) {
        Object capval;
        String dirstr;
        String versionstr;
        if (!this.matchPackageName(cap)) {
            return false;
        }
        if (this.getVersionRange() != null) {
            Version version = AbstractCapability.getVersion(cap, "version");
            if (!this.getVersionRange().isInRange(version)) {
                return false;
            }
        }
        HashMap<String, Object> reqatts = new HashMap<String, Object>(this.getAttributes());
        reqatts.remove("osgi.wiring.package");
        reqatts.remove("version");
        reqatts.remove("specification-version");
        HashMap<String, Object> capatts = new HashMap<String, Object>(cap.getAttributes());
        capatts.remove("osgi.wiring.package");
        capatts.remove("version");
        capatts.remove("specification-version");
        String symbolicName = (String)reqatts.remove("bundle-symbolic-name");
        if (symbolicName != null) {
            String targetSymbolicName;
            XResource capres = (XResource)cap.getResource();
            XIdentityCapability idcap = capres.getIdentityCapability();
            String string = targetSymbolicName = idcap != null ? idcap.getSymbolicName() : null;
            if (!symbolicName.equals(targetSymbolicName)) {
                return false;
            }
        }
        if ((versionstr = (String)reqatts.remove("bundle-version")) != null) {
            XResource capres = (XResource)cap.getResource();
            XIdentityCapability idcap = capres.getIdentityCapability();
            Version targetVersion = idcap != null ? idcap.getVersion() : null;
            VersionRange versionRange = VersionRange.parse((String)versionstr);
            if (targetVersion != null && !versionRange.isInRange(targetVersion)) {
                return false;
            }
        }
        if ((dirstr = ((XCapability)cap).getDirective("mandatory")) != null) {
            for (String att : dirstr.split(",")) {
                Object reqval;
                capval = capatts.remove(att);
                if (capval == null || capval.equals(reqval = reqatts.remove(att))) continue;
                return false;
            }
        }
        for (Map.Entry entry : reqatts.entrySet()) {
            String att = (String)entry.getKey();
            Object reqval = entry.getValue();
            if (reqval.equals(capval = capatts.remove(att))) continue;
            return false;
        }
        return true;
    }

    private boolean matchPackageName(Capability cap) {
        String packageName = this.getPackageName();
        if (packageName.equals("*")) {
            return true;
        }
        String capvalue = (String)cap.getAttributes().get(this.getNamespace());
        if (packageName.endsWith(".*")) {
            packageName = packageName.substring(0, packageName.length() - 2);
            return capvalue.startsWith(packageName);
        }
        return packageName.equals(capvalue);
    }

    static VersionRange getVersionRange(XRequirement req, String attr) {
        Object value = req.getAttribute(attr);
        return value instanceof String ? VersionRange.parse((String)((String)value)) : (VersionRange)value;
    }

    private boolean matchFilter(Capability cap) {
        return this.filter != null ? this.filter.match(new Hashtable<String, Object>(cap.getAttributes())) : true;
    }

    @Override
    public String getVisibility() {
        return this.getDirective("visibility");
    }

    @Override
    public String getSymbolicName() {
        String result = null;
        if ("osgi.wiring.host".equals(this.getNamespace())) {
            result = AbstractRequirement.getNamespaceValue(this);
        }
        return result;
    }

    @Override
    public String getPackageName() {
        String result = null;
        if ("osgi.wiring.package".equals(this.getNamespace())) {
            result = AbstractRequirement.getNamespaceValue(this);
        }
        return result;
    }

    @Override
    public VersionRange getVersionRange() {
        VersionRange result = null;
        if ("osgi.wiring.host".equals(this.getNamespace()) || "osgi.wiring.bundle".equals(this.getNamespace())) {
            result = AbstractRequirement.getVersionRange(this, "bundle-version");
        } else if ("osgi.wiring.package".equals(this.getNamespace())) {
            result = AbstractRequirement.getVersionRange(this, "version");
        }
        return result;
    }

    @Override
    public boolean isDynamic() {
        return "dynamic".equals(this.getDirective("resolution"));
    }

    public String toString() {
        String result = this.canonicalName;
        if (result == null) {
            String type = this.getClass().getSimpleName();
            if ("osgi.wiring.bundle".equals(this.getNamespace())) {
                type = XResourceRequirement.class.getSimpleName();
            } else if ("osgi.wiring.host".equals(this.getNamespace())) {
                type = XHostRequirement.class.getSimpleName();
            } else if ("osgi.wiring.package".equals(this.getNamespace())) {
                type = XPackageRequirement.class.getSimpleName();
            }
            String attstr = "atts=" + this.attributes;
            String dirstr = !this.getDirectives().isEmpty() ? ",dirs=" + this.directives : "";
            XIdentityCapability icap = this.resource.getIdentityCapability();
            String resname = ",[" + (icap != null ? icap.getSymbolicName() + ":" + icap.getVersion() : "anonymous") + "]";
            result = type + "[" + attstr + dirstr + resname + "]";
        }
        return result;
    }
}

