/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.resolver.spi;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.metadata.PackageAttribute;
import org.jboss.osgi.metadata.Parameter;
import org.jboss.osgi.metadata.ParameterizedAttribute;
import org.jboss.osgi.resolver.ResolverMessages;
import org.jboss.osgi.resolver.ResourceBuilderException;
import org.jboss.osgi.resolver.XCapability;
import org.jboss.osgi.resolver.XRequirement;
import org.jboss.osgi.resolver.XResource;
import org.jboss.osgi.resolver.XResourceBuilder;
import org.jboss.osgi.resolver.XResourceBuilderFactory;
import org.jboss.osgi.resolver.spi.AbstractResource;
import org.jboss.osgi.resolver.spi.ResourceValidationException;
import org.osgi.framework.Filter;
import org.osgi.framework.Version;

public class AbstractResourceBuilder
implements XResourceBuilder {
    private final XResourceBuilderFactory factory;
    private final XResource resource;

    public AbstractResourceBuilder(XResourceBuilderFactory factory) {
        if (factory == null) {
            throw ResolverMessages.MESSAGES.illegalArgumentNull("factory");
        }
        this.factory = factory;
        this.resource = factory.createResource();
    }

    @Override
    public XCapability addCapability(String namespace, Map<String, Object> atts, Map<String, String> dirs) {
        this.assertResourceCreated();
        XCapability cap = this.factory.createCapability(this.resource, namespace, this.mutableAttributes(atts), this.mutableDirectives(dirs));
        this.addCapability(cap);
        return cap;
    }

    @Override
    public XCapability addCapability(String namespace, String nsvalue) {
        return this.addCapability(namespace, Collections.singletonMap(namespace, nsvalue), null);
    }

    @Override
    public XRequirement addRequirement(String namespace, Map<String, Object> atts, Map<String, String> dirs) {
        this.assertResourceCreated();
        XRequirement req = this.factory.createRequirement(this.resource, namespace, this.mutableAttributes(atts), this.mutableDirectives(dirs));
        this.addRequirement(req);
        return req;
    }

    @Override
    public XRequirement addRequirement(String namespace, Filter filter) {
        this.assertResourceCreated();
        HashMap<String, String> dirs = new HashMap<String, String>();
        if (filter != null) {
            dirs.put("filter", filter.toString());
        }
        return this.addRequirement(namespace, null, dirs);
    }

    @Override
    public XRequirement addRequirement(String namespace, String nsvalue) {
        this.assertResourceCreated();
        HashMap<String, Object> atts = new HashMap<String, Object>();
        if (nsvalue != null) {
            atts.put(namespace, nsvalue);
        }
        return this.addRequirement(namespace, atts, null);
    }

    @Override
    public XResourceBuilder loadFrom(OSGiMetaData metadata) throws ResourceBuilderException {
        this.assertResourceCreated();
        try {
            List requiredCapabilities;
            List providedCapabilities;
            XRequirement req;
            List dynamicImports;
            List imports;
            List exports;
            List requireBundles;
            XCapability cap;
            ParameterizedAttribute fragmentHost;
            String symbolicName = metadata.getBundleSymbolicName();
            Version bundleVersion = metadata.getBundleVersion();
            ParameterizedAttribute idparams = metadata.getBundleParameters();
            if (symbolicName == null) {
                symbolicName = "anonymous-bundle-symbolic-name";
            }
            String identityType = (fragmentHost = metadata.getFragmentHost()) != null ? "osgi.fragment" : "osgi.bundle";
            XCapability icap = this.addCapability("osgi.identity", symbolicName);
            icap.getAttributes().put("version", bundleVersion);
            icap.getAttributes().put("type", identityType);
            icap.getAttributes().putAll(this.getAttributes(idparams));
            icap.getDirectives().putAll(this.getDirectives(idparams));
            if ("osgi.bundle".equals(identityType)) {
                cap = this.addCapability("osgi.wiring.bundle", symbolicName);
                cap.getAttributes().put("bundle-version", bundleVersion);
                cap.getAttributes().putAll(this.getAttributes(idparams));
                cap.getDirectives().putAll(this.getDirectives(idparams));
            }
            if (fragmentHost == null) {
                cap = this.addCapability("osgi.wiring.host", symbolicName);
                cap.getAttributes().put("bundle-version", bundleVersion);
                cap.getAttributes().putAll(this.getAttributes(idparams));
                cap.getDirectives().putAll(this.getDirectives(idparams));
            }
            if (fragmentHost != null) {
                String hostName = fragmentHost.getAttribute();
                XRequirement req2 = this.addRequirement("osgi.wiring.host", hostName);
                req2.getAttributes().putAll(this.getAttributes(fragmentHost));
                req2.getDirectives().putAll(this.getDirectives(fragmentHost));
            }
            if ((requireBundles = metadata.getRequireBundles()) != null && !requireBundles.isEmpty()) {
                for (ParameterizedAttribute attr : requireBundles) {
                    String bundleName = attr.getAttribute();
                    XRequirement req3 = this.addRequirement("osgi.wiring.bundle", bundleName);
                    req3.getAttributes().putAll(this.getAttributes(attr));
                    req3.getDirectives().putAll(this.getDirectives(attr));
                }
            }
            if ((exports = metadata.getExportPackages()) != null && !exports.isEmpty()) {
                for (PackageAttribute attr : exports) {
                    String packageName = attr.getAttribute();
                    XCapability cap2 = this.addCapability("osgi.wiring.package", packageName);
                    cap2.getAttributes().putAll(this.getAttributes((ParameterizedAttribute)attr));
                    cap2.getDirectives().putAll(this.getDirectives((ParameterizedAttribute)attr));
                }
            }
            if ((imports = metadata.getImportPackages()) != null && !imports.isEmpty()) {
                for (PackageAttribute attr : imports) {
                    String packageName = attr.getAttribute();
                    XRequirement req4 = this.addRequirement("osgi.wiring.package", packageName);
                    req4.getAttributes().putAll(this.getAttributes((ParameterizedAttribute)attr));
                    req4.getDirectives().putAll(this.getDirectives((ParameterizedAttribute)attr));
                }
            }
            if ((dynamicImports = metadata.getDynamicImports()) != null && !dynamicImports.isEmpty()) {
                for (PackageAttribute attr : dynamicImports) {
                    String packageName = attr.getAttribute();
                    HashMap<String, Object> atts = new HashMap<String, Object>();
                    HashMap<String, String> dirs = new HashMap<String, String>();
                    atts.put("osgi.wiring.package", packageName);
                    dirs.put("resolution", "dynamic");
                    req = this.addRequirement("osgi.wiring.package", atts, dirs);
                    req.getAttributes().putAll(this.getAttributes((ParameterizedAttribute)attr));
                    req.getDirectives().putAll(this.getDirectives((ParameterizedAttribute)attr));
                }
            }
            if ((providedCapabilities = metadata.getProvidedCapabilities()) != null && !providedCapabilities.isEmpty()) {
                for (ParameterizedAttribute attr : providedCapabilities) {
                    String capname = attr.getAttribute();
                    XCapability cap3 = this.addCapability(capname, capname);
                    cap3.getAttributes().putAll(this.getAttributes(attr));
                    cap3.getDirectives().putAll(this.getDirectives(attr));
                }
            }
            if ((requiredCapabilities = metadata.getRequiredCapabilities()) != null && !requiredCapabilities.isEmpty()) {
                for (ParameterizedAttribute attr : requiredCapabilities) {
                    String reqname = attr.getAttribute();
                    req = this.addRequirement(reqname, reqname);
                    req.getAttributes().putAll(this.getAttributes(attr));
                    req.getDirectives().putAll(this.getDirectives(attr));
                }
            }
            this.resource.validate();
        }
        catch (ResourceValidationException ex) {
            throw ResolverMessages.MESSAGES.resourceBuilderCannotInitializeResource(ex, ex.getOffendingInput());
        }
        catch (RuntimeException ex) {
            throw ResolverMessages.MESSAGES.resourceBuilderCannotInitializeResource(ex, metadata.toString());
        }
        return this;
    }

    @Override
    public XResourceBuilder loadFrom(Module module) throws ResourceBuilderException {
        this.assertResourceCreated();
        try {
            Version version;
            ModuleIdentifier identifier = module.getIdentifier();
            String symbolicName = identifier.getName();
            try {
                version = Version.parseVersion((String)identifier.getSlot());
            }
            catch (IllegalArgumentException ex) {
                version = Version.emptyVersion;
            }
            XCapability icap = this.addCapability("osgi.identity", symbolicName);
            icap.getAttributes().put("version", version);
            XCapability bcap = this.addCapability("osgi.wiring.bundle", symbolicName);
            bcap.getAttributes().put("version", version);
            for (String path : module.getExportedPaths()) {
                if (path.startsWith("/")) {
                    path = path.substring(1);
                }
                if (path.endsWith("/")) {
                    path = path.substring(0, path.length() - 1);
                }
                if (path.isEmpty() || path.startsWith("META-INF")) continue;
                String packageName = path.replace('/', '.');
                this.addCapability("osgi.wiring.package", packageName);
            }
            this.resource.validate();
        }
        catch (RuntimeException ex) {
            throw ResolverMessages.MESSAGES.resourceBuilderCannotInitializeResource(ex, this.resource.toString());
        }
        return this;
    }

    @Override
    public XResource getResource() {
        this.resource.validate();
        this.resource.makeImmutable();
        return this.resource;
    }

    private void addCapability(XCapability cap) {
        if (this.resource instanceof AbstractResource) {
            ((AbstractResource)this.resource).addCapability(cap);
        }
    }

    private void addRequirement(XRequirement req) {
        if (this.resource instanceof AbstractResource) {
            ((AbstractResource)this.resource).addRequirement(req);
        }
    }

    private Map<String, Object> getAttributes(ParameterizedAttribute patts) {
        HashMap<String, Object> atts = new HashMap<String, Object>();
        if (patts != null) {
            for (String key : patts.getAttributes().keySet()) {
                Parameter param = patts.getAttribute(key);
                atts.put(key.trim(), param.getValue().toString().trim());
            }
        }
        return atts;
    }

    private Map<String, String> getDirectives(ParameterizedAttribute patts) {
        HashMap<String, String> dirs = new HashMap<String, String>();
        if (patts != null) {
            for (String key : patts.getDirectives().keySet()) {
                String value = (String)patts.getDirectiveValue(key, String.class);
                dirs.put(key.trim(), value.trim());
            }
        }
        return dirs;
    }

    private Map<String, Object> mutableAttributes(Map<String, Object> atts) {
        return new HashMap<String, Object>(atts != null ? atts : new HashMap());
    }

    private Map<String, String> mutableDirectives(Map<String, String> dirs) {
        return new HashMap<String, String>(dirs != null ? dirs : new HashMap());
    }

    private void assertResourceCreated() {
        if (this.resource == null) {
            throw ResolverMessages.MESSAGES.illegalStateResourceNotCreated();
        }
    }
}

