/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.spi;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jboss.osgi.metadata.OSGiManifestBuilder;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.metadata.OSGiMetaDataBuilder;
import org.jboss.osgi.spi.SPIMessages;
import org.jboss.osgi.vfs.AbstractVFS;
import org.jboss.osgi.vfs.VFSUtils;
import org.jboss.osgi.vfs.VirtualFile;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;

public class BundleInfo
implements Serializable {
    private static final long serialVersionUID = -2363297020450715134L;
    private final URL rootURL;
    private final String location;
    private final String symbolicName;
    private final Version bundleVersion;
    private final OSGiMetaData metadata;
    private transient VirtualFile rootFile;
    private transient Manifest manifest;

    public static BundleInfo createBundleInfo(String location) throws BundleException {
        if (location == null) {
            throw SPIMessages.MESSAGES.illegalArgumentNull("location");
        }
        URL url = BundleInfo.getRealLocation(location);
        if (url == null) {
            throw SPIMessages.MESSAGES.illegalArgumentCannotObtainRealLocation(location);
        }
        return new BundleInfo(BundleInfo.toVirtualFile(url), url.toExternalForm(), null);
    }

    public static BundleInfo createBundleInfo(URL url) throws BundleException {
        if (url == null) {
            throw SPIMessages.MESSAGES.illegalArgumentNull("url");
        }
        return new BundleInfo(BundleInfo.toVirtualFile(url), url.toExternalForm(), null);
    }

    public static BundleInfo createBundleInfo(VirtualFile root) throws BundleException {
        return new BundleInfo(root, null, null);
    }

    public static BundleInfo createBundleInfo(VirtualFile root, String location) throws BundleException {
        return new BundleInfo(root, location, null);
    }

    public static BundleInfo createBundleInfo(VirtualFile root, String location, OSGiMetaData metadata) throws BundleException {
        return new BundleInfo(root, location, metadata);
    }

    private BundleInfo(VirtualFile rootFile, String location, OSGiMetaData metadata) throws BundleException {
        if (rootFile == null) {
            throw SPIMessages.MESSAGES.illegalArgumentNull("rootFile");
        }
        this.rootFile = rootFile;
        this.rootURL = BundleInfo.toURL(rootFile);
        if (location == null) {
            location = this.rootURL.toExternalForm();
        }
        this.location = location;
        if (metadata == null) {
            try {
                this.manifest = VFSUtils.getManifest((VirtualFile)rootFile);
                if (this.manifest == null) {
                    throw SPIMessages.MESSAGES.bundleCannotGetManifest(null, this.rootURL);
                }
            }
            catch (IOException ex) {
                throw SPIMessages.MESSAGES.bundleCannotGetManifest(ex, this.rootURL);
            }
            metadata = OSGiMetaDataBuilder.load((Manifest)this.manifest);
        }
        OSGiMetaDataBuilder.validateMetadata((OSGiMetaData)metadata);
        this.metadata = metadata;
        this.symbolicName = metadata.getBundleSymbolicName();
        this.bundleVersion = metadata.getBundleVersion();
    }

    public static boolean isValidBundle(VirtualFile virtualFile) {
        try {
            Manifest manifest = VFSUtils.getManifest((VirtualFile)virtualFile);
            return OSGiManifestBuilder.isValidBundleManifest((Manifest)manifest);
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean isValidBundleManifest(Manifest manifest) {
        return OSGiManifestBuilder.isValidBundleManifest((Manifest)manifest);
    }

    public static void validateBundleManifest(Manifest manifest) throws BundleException {
        OSGiManifestBuilder.validateBundleManifest((Manifest)manifest);
    }

    public static int getBundleManifestVersion(Manifest manifest) {
        if (manifest == null) {
            throw SPIMessages.MESSAGES.illegalArgumentNull("manifest");
        }
        String bundleName = BundleInfo.getManifestHeaderInternal(manifest, "Bundle-Name");
        String bundleSymbolicName = BundleInfo.getManifestHeaderInternal(manifest, "Bundle-SymbolicName");
        String bundleVersion = BundleInfo.getManifestHeaderInternal(manifest, "Bundle-Version");
        if (bundleName == null && bundleSymbolicName == null && bundleVersion == null) {
            return -1;
        }
        String manifestVersion = BundleInfo.getManifestHeaderInternal(manifest, "Bundle-ManifestVersion");
        return manifestVersion != null ? Integer.parseInt(manifestVersion) : 1;
    }

    public String getManifestHeader(String key) {
        String value = BundleInfo.getManifestHeaderInternal(this.getManifest(), key);
        return value;
    }

    public String getLocation() {
        return this.location;
    }

    public VirtualFile getRoot() {
        if (this.rootFile == null) {
            this.rootFile = BundleInfo.toVirtualFile(this.rootURL);
        }
        return this.rootFile;
    }

    public URL getRootURL() {
        return BundleInfo.toURL(this.getRoot());
    }

    public String getSymbolicName() {
        return this.symbolicName;
    }

    public Version getVersion() {
        return this.bundleVersion;
    }

    public OSGiMetaData getOSGiMetadata() {
        return this.metadata;
    }

    public void close() {
        if (this.rootFile != null) {
            VFSUtils.safeClose((Closeable)this.rootFile);
        }
    }

    public Manifest getManifest() {
        if (this.manifest == null) {
            try {
                this.manifest = VFSUtils.getManifest((VirtualFile)this.getRoot());
            }
            catch (Exception ex) {
                throw SPIMessages.MESSAGES.illegalStateCannotGetManifest(ex, this.rootURL);
            }
        }
        return this.manifest;
    }

    private static VirtualFile toVirtualFile(URL url) {
        try {
            return AbstractVFS.toVirtualFile((URL)url);
        }
        catch (IOException ex) {
            throw SPIMessages.MESSAGES.illegalArgumentInvalidRootURL(ex, url);
        }
    }

    private static URL getRealLocation(String location) {
        String prefix;
        URL url = null;
        try {
            url = new URL(location);
        }
        catch (MalformedURLException ex) {
            // empty catch block
        }
        if (url == null) {
            try {
                File file = new File(location);
                if (file.exists()) {
                    url = file.toURI().toURL();
                }
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
        if (url == null && !location.startsWith(prefix = System.getProperty("test.archive.directory", "target/test-libs")) && new File(prefix).exists()) {
            return BundleInfo.getRealLocation(prefix + File.separator + location);
        }
        return url;
    }

    private static URL toURL(VirtualFile file) {
        try {
            return file.toURL();
        }
        catch (Exception ex) {
            throw SPIMessages.MESSAGES.illegalArgumentInvalidRootFile(ex, file);
        }
    }

    private String toEqualString() {
        return "[" + this.symbolicName + ":" + this.bundleVersion + ",url=" + this.rootURL + "]";
    }

    private static String getManifestHeaderInternal(Manifest manifest, String key) {
        Attributes attribs = manifest.getMainAttributes();
        String value = attribs.getValue(key);
        return value != null ? value.trim() : null;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BundleInfo)) {
            return false;
        }
        BundleInfo other = (BundleInfo)obj;
        return this.toEqualString().equals(other.toEqualString());
    }

    public int hashCode() {
        return this.toEqualString().hashCode();
    }

    public String toString() {
        return this.toEqualString();
    }
}

