/*
 * Decompiled with CFR 0.152.
 */
package javax.portlet.faces;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.WindowState;
import javax.portlet.faces.Bridge;
import javax.portlet.faces.BridgeEventHandler;
import javax.portlet.faces.BridgeException;
import javax.portlet.faces.BridgePublicRenderParameterHandler;

public class GenericFacesPortlet
extends GenericPortlet {
    public static final String BRIDGE_CLASS = "javax.portlet.faces.BridgeClassName";
    public static final String DEFAULT_VIEWID = "javax.portlet.faces.defaultViewId";
    public static final String DEFAULT_CONTENT_TYPE = "javax.portlet.faces.defaultContentType";
    public static final String DEFAULT_CHARACTERSET_ENCODING = "javax.portlet.faces.defaultCharacterSetEncoding";
    public static final String BRIDGE_AUTO_DISPATCH_EVENTS = "javax.portlet.faces.autoDispatchEvents";
    public static final String BRIDGE_SERVICE_CLASSPATH = "META-INF/services/javax.portlet.faces.Bridge";
    private static final int DEFAULT_VIEW_ID_LENGTH = "javax.portlet.faces.defaultViewId".length() + 1;
    private static final int EXTENDED_ATTR_PREFIX_LENGTH = "javax.portlet.faces.extension.".length();
    private volatile Class<? extends Bridge> facesBridgeClass = null;
    private volatile Bridge facesBridge = null;
    private volatile String bridgeClassName = null;
    private volatile Map<String, String> defaultViewIdMap;
    private static final Logger log = Logger.getLogger("javax.portlet.faces");
    private boolean initialized = false;

    public void init(PortletConfig config) throws PortletException {
        if (this.initialized) {
            throw new PortletException("GenericFacesPortlet for portlet " + config.getPortletName() + " already initialized");
        }
        if (log.isLoggable(Level.INFO)) {
            log.info("Init GenericFacesPortlet for portlet " + config.getPortletName());
        }
        super.init(config);
        PortletContext portletContext = this.getPortletContext();
        String bridgeClassName = this.getBridgeClassName();
        try {
            this.facesBridgeClass = this.loadClassForName(bridgeClassName);
        }
        catch (ClassNotFoundException e) {
            throw new PortletException("Faces Portlet Bridge implementation class not found", (Throwable)e);
        }
        this.setBridgeParameter("preserveActionParams", this.isPreserveActionParameters());
        this.setBridgeParameter("excludedRequestAttributes", this.getExcludedRequestAttributes());
        this.setBridgeParameter("defaultRenderKitId", this.getDefaultRenderKitId());
        this.setBridgeParameter("defaultViewIdMap", this.getDefaultViewIdMap());
        this.setBridgeParameter("bridgeEventHandler", this.getBridgeEventHandler());
        this.setBridgeParameter("bridgePublicRenderParameterHandler", this.getBridgePublicRenderParameterHandler());
        this.setBridgeParameter(BRIDGE_AUTO_DISPATCH_EVENTS, this.isAutoDispatchEvents());
        String portletName = this.getPortletName();
        Enumeration configNames = config.getInitParameterNames();
        while (configNames.hasMoreElements()) {
            int i;
            String name = (String)configNames.nextElement();
            if (!name.startsWith("javax.portlet.faces.extension.") || (i = name.lastIndexOf(46)) <= EXTENDED_ATTR_PREFIX_LENGTH + 2) continue;
            String attribute = name.substring(i);
            String preffix = name.substring(EXTENDED_ATTR_PREFIX_LENGTH, i + 1);
            String extensionAttributeName = "javax.portlet.faces.extension." + preffix + portletName + attribute;
            portletContext.setAttribute(extensionAttributeName, (Object)config.getInitParameter(name).trim());
        }
        this.initialized = true;
        if (log.isLoggable(Level.FINE)) {
            log.info("GenericFacesPortlet for portlet " + config.getPortletName() + " initialized");
        }
    }

    public List<String> getExcludedRequestAttributes() {
        ArrayList<String> attrsList = null;
        String excludedAttrs = this.getPortletConfig().getInitParameter("javax.portlet.faces.excludedRequestAttributes");
        if (null != excludedAttrs) {
            String[] atrs = excludedAttrs.split(",");
            attrsList = new ArrayList<String>(atrs.length);
            for (String string : atrs) {
                attrsList.add(string.trim());
            }
        }
        return attrsList;
    }

    public Boolean isPreserveActionParameters() {
        String preserveActionParams = this.getPortletConfig().getInitParameter("javax.portlet.faces.preserveActionParams");
        if (null == preserveActionParams) {
            return false;
        }
        return Boolean.valueOf(preserveActionParams);
    }

    public String getDefaultRenderKitId() {
        return this.getPortletConfig().getInitParameter("javax.portlet.faces.defaultRenderKitId");
    }

    public Boolean isAutoDispatchEvents() {
        String autoDispatchEvents = this.getPortletConfig().getInitParameter(BRIDGE_AUTO_DISPATCH_EVENTS);
        if (null != autoDispatchEvents) {
            return Boolean.valueOf(autoDispatchEvents);
        }
        return true;
    }

    public BridgeEventHandler getBridgeEventHandler() {
        String eventHandlerClassName = this.getPortletConfig().getInitParameter("javax.portlet.faces.bridgeEventHandler");
        if (null != eventHandlerClassName) {
            try {
                return (BridgeEventHandler)this.createInstanceByClassName(eventHandlerClassName.trim());
            }
            catch (PortletException e) {
                log.log(Level.WARNING, "Couldn't create BridgeEventHandler instance", e);
            }
        }
        return null;
    }

    public BridgePublicRenderParameterHandler getBridgePublicRenderParameterHandler() {
        String renderParameterHandlerClassName = this.getPortletConfig().getInitParameter("javax.portlet.faces.bridgePublicRenderParameterHandler");
        if (null != renderParameterHandlerClassName) {
            try {
                return (BridgePublicRenderParameterHandler)this.createInstanceByClassName(renderParameterHandlerClassName);
            }
            catch (PortletException e) {
                log.log(Level.WARNING, "Couldn't create BridgePublicRenderParameterHandler instance", e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getBridgeClassName() throws PortletException {
        if (null == this.bridgeClassName) {
            GenericFacesPortlet genericFacesPortlet = this;
            synchronized (genericFacesPortlet) {
                if (null == this.bridgeClassName) {
                    this.bridgeClassName = this.calculateBridgeClassName(this.getPortletContext());
                }
            }
        }
        return this.bridgeClassName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getDefaultViewIdMap() {
        if (null == this.defaultViewIdMap) {
            GenericFacesPortlet genericFacesPortlet = this;
            synchronized (genericFacesPortlet) {
                if (null == this.defaultViewIdMap) {
                    this.defaultViewIdMap = this.calculateDefaultViewIdMap();
                }
            }
        }
        return this.defaultViewIdMap;
    }

    public Bridge getFacesBridge(PortletRequest request, PortletResponse response) throws PortletException {
        Bridge facesBridge = this.getFacesBridge();
        this.setupBridgeRequest(request, response);
        return facesBridge;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bridge getFacesBridge() throws PortletException {
        if (null == this.facesBridge) {
            GenericFacesPortlet genericFacesPortlet = this;
            synchronized (genericFacesPortlet) {
                if (null == this.facesBridge) {
                    try {
                        Bridge bridge = this.facesBridgeClass.newInstance();
                        bridge.init(this.getPortletConfig());
                        this.facesBridge = bridge;
                    }
                    catch (InstantiationException e) {
                        throw new PortletException("Error on create instance of a JSF Portlet Bridge", (Throwable)e);
                    }
                    catch (IllegalAccessException e) {
                        throw new PortletException("IllegalAccess on create instance of a JSF Portlet Bridge", (Throwable)e);
                    }
                    catch (BridgeException e) {
                        throw new PortletException("Bridge initialization error", (Throwable)((Object)e));
                    }
                }
            }
        }
        return this.facesBridge;
    }

    public void destroy() {
        if (log.isLoggable(Level.INFO)) {
            log.info("Destroy GenericFacesPortlet for portlet " + this.getPortletName());
        }
        if (null != this.facesBridge) {
            this.facesBridge.destroy();
            this.facesBridge = null;
        }
        this.bridgeClassName = null;
        this.defaultViewIdMap = null;
        this.facesBridgeClass = null;
        super.destroy();
        this.initialized = false;
    }

    protected void doDispatch(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        PortletMode mode = request.getPortletMode();
        if (PortletMode.VIEW.equals((Object)mode) || PortletMode.EDIT.equals((Object)mode) || PortletMode.HELP.equals((Object)mode)) {
            super.doDispatch(request, response);
        } else {
            this.doFacesDispatch(request, response);
        }
    }

    protected void doEdit(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Process edit request for portlet " + this.getPortletName());
        }
        this.doFacesDispatch(request, response);
    }

    protected void doHelp(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Process help request for portlet " + this.getPortletName());
        }
        this.doFacesDispatch(request, response);
    }

    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Process view request for portlet " + this.getPortletName());
        }
        this.doFacesDispatch(request, response);
    }

    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Process action request for portlet " + this.getPortletName());
        }
        String defaultViewId = this.getDefaultViewIdMap().get(request.getPortletMode().toString());
        String nonFacesTargetPath = this.getNonFacesTargetPath((PortletRequest)request, (PortletResponse)response);
        if (null == defaultViewId || null != nonFacesTargetPath) {
            throw new PortletException("Non-faces Action requests to the GenericFacesPortlet are not supported");
        }
        try {
            this.getFacesBridge((PortletRequest)request, (PortletResponse)response).doFacesRequest(request, response);
        }
        catch (BridgeException e) {
            throw new PortletException("Error process faces request", (Throwable)((Object)e));
        }
    }

    public void serveResource(ResourceRequest request, ResourceResponse response) throws PortletException, IOException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Process resource request for portlet " + this.getPortletName());
        }
        try {
            this.getFacesBridge((PortletRequest)request, (PortletResponse)response).doFacesRequest(request, response);
        }
        catch (BridgeException e) {
            throw new PortletException("Error process faces request", (Throwable)((Object)e));
        }
    }

    public void processEvent(EventRequest request, EventResponse response) throws PortletException, IOException {
        if (this.isAutoDispatchEvents().booleanValue()) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("Process event request for portlet " + this.getPortletName());
            }
            try {
                this.getFacesBridge((PortletRequest)request, (PortletResponse)response).doFacesRequest(request, response);
            }
            catch (BridgeException e) {
                throw new PortletException("Error process faces request", (Throwable)((Object)e));
            }
        } else {
            super.processEvent(request, response);
        }
    }

    void doFacesDispatch(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        String nonFacesTargetPath = this.getNonFacesTargetPath((PortletRequest)request, (PortletResponse)response);
        if (null != nonFacesTargetPath) {
            try {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Non-faces render request to target " + nonFacesTargetPath);
                }
                PortletRequestDispatcher dispatcher = this.getPortletContext().getRequestDispatcher(nonFacesTargetPath);
                dispatcher.forward((PortletRequest)request, (PortletResponse)response);
            }
            catch (Exception e) {
                throw new PortletException("Unable to perform non-faces dispatch to: " + nonFacesTargetPath, (Throwable)e);
            }
        }
        String defaultViewId = this.getDefaultViewIdMap().get(request.getPortletMode().toString());
        if (null != defaultViewId && !request.getWindowState().equals((Object)WindowState.MINIMIZED)) {
            try {
                this.getFacesBridge((PortletRequest)request, (PortletResponse)response).doFacesRequest(request, response);
            }
            catch (BridgeException e) {
                throw new PortletException("Error process faces request", (Throwable)((Object)e));
            }
        }
    }

    private void setupBridgeRequest(PortletRequest request, PortletResponse response) throws PortletException {
        String viewId = request.getParameter("_jsfBridgeViewId");
        if (null != viewId) {
            request.setAttribute("javax.portlet.faces.viewId", (Object)viewId);
        } else {
            viewId = request.getParameter("_jsfBridgeViewPath");
            if (null != viewId) {
                request.setAttribute("javax.portlet.faces.viewPath", (Object)viewId);
            }
        }
    }

    private String getNonFacesTargetPath(PortletRequest request, PortletResponse response) {
        return request.getParameter("_jsfBridgeNonFacesView");
    }

    private void setBridgeParameter(String name, Object value) {
        if (null != value) {
            StringBuilder attributeName = new StringBuilder("javax.portlet.faces.");
            attributeName.append(this.getPortletName()).append('.').append(name);
            this.getPortletContext().setAttribute(attributeName.toString(), value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String calculateBridgeClassName(PortletContext portletContext) throws PortletException {
        ClassLoader loader;
        URL resource;
        String bridgeClassName = portletContext.getInitParameter(BRIDGE_CLASS);
        if (bridgeClassName == null && null != (resource = (loader = this.getClassLoader()).getResource(BRIDGE_SERVICE_CLASSPATH))) {
            InputStream stream = null;
            try {
                URLConnection connection = resource.openConnection();
                connection.setUseCaches(false);
                stream = connection.getInputStream();
                BufferedReader reader = null;
                try {
                    reader = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    reader = new BufferedReader(new InputStreamReader(stream, Charset.defaultCharset()));
                }
                while (null == bridgeClassName && null != (bridgeClassName = reader.readLine())) {
                    int indexOfComment = bridgeClassName.indexOf(35);
                    if (indexOfComment >= 0) {
                        bridgeClassName = bridgeClassName.substring(0, indexOfComment);
                    }
                    if ((bridgeClassName = bridgeClassName.trim()).length() != 0) continue;
                    bridgeClassName = null;
                }
            }
            catch (IOException e) {
                log.log(Level.SEVERE, "Error reading bridge service definition file", e);
            }
            catch (SecurityException e) {
                log.log(Level.SEVERE, "Error reading bridge service definition file", e);
            }
            finally {
                if (null != stream) {
                    try {
                        stream.close();
                    }
                    catch (IOException e) {
                        log.log(Level.SEVERE, "Error to close input stream for a resource META-INF/services/javax.portlet.faces.Bridge", e);
                    }
                }
            }
        }
        if (null == bridgeClassName) {
            throw new PortletException("Can't detect bridge implementation class name");
        }
        if (log.isLoggable(Level.INFO)) {
            log.info("Bridge class name is " + bridgeClassName);
        }
        return bridgeClassName;
    }

    private ClassLoader getClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (null == classLoader) {
            classLoader = GenericFacesPortlet.class.getClassLoader();
        }
        return classLoader;
    }

    private <U> Class<? extends U> loadClassForName(String className) throws ClassNotFoundException {
        return this.getClassLoader().loadClass(className);
    }

    private <U> U createInstanceByClassName(String className) throws PortletException {
        try {
            return this.loadClassForName(className).newInstance();
        }
        catch (InstantiationException e) {
            throw new PortletException("Error instantiate class for name " + className);
        }
        catch (IllegalAccessException e) {
            throw new PortletException("Illegal access to class for name " + className);
        }
        catch (ClassNotFoundException e) {
            throw new PortletException("Class " + className + " was not found");
        }
    }

    private Map<String, String> calculateDefaultViewIdMap() {
        HashMap<String, String> viewIdMap = new HashMap<String, String>();
        PortletConfig portletConfig = this.getPortletConfig();
        Enumeration configNames = portletConfig.getInitParameterNames();
        while (configNames.hasMoreElements()) {
            String name = (String)configNames.nextElement();
            if (!name.startsWith(DEFAULT_VIEWID)) continue;
            viewIdMap.put(name.substring(DEFAULT_VIEW_ID_LENGTH), portletConfig.getInitParameter(name).trim());
        }
        return viewIdMap;
    }

    @Deprecated
    public String getResponseCharacterSetEncoding(PortletRequest request) {
        return null;
    }

    @Deprecated
    public String getResponseContentType(PortletRequest request) {
        return request.getResponseContentType();
    }
}

