/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portletbridge;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.portlet.PortletMode;
import javax.portlet.faces.BridgeException;

public class StateId
implements Serializable {
    private PortletMode mode;
    private String uuid;

    public StateId(PortletMode mode, String uuid) {
        this.mode = mode;
        this.uuid = uuid;
    }

    public StateId(String stateId) {
        int modeEnd = stateId.indexOf(58);
        if (modeEnd < 0) {
            throw new BridgeException("Invalid StateId format");
        }
        this.mode = new PortletMode(stateId.substring(0, modeEnd));
        this.uuid = stateId.substring(modeEnd + 1);
    }

    public PortletMode getMode() {
        return this.mode;
    }

    public void setMode(PortletMode mode) {
        this.mode = mode;
    }

    public String getUuid() {
        return this.uuid;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.mode.toString());
        out.writeObject(this.uuid);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.mode = new PortletMode((String)in.readObject());
        this.uuid = (String)in.readObject();
    }

    public String toString() {
        return this.mode.toString() + ':' + this.uuid;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.mode == null ? 0 : this.mode.hashCode());
        result = 31 * result + (this.uuid == null ? 0 : this.uuid.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StateId other = (StateId)obj;
        if (this.mode == null ? other.mode != null : !this.mode.equals((Object)other.mode)) {
            return false;
        }
        return !(this.uuid == null ? other.uuid != null : !this.uuid.equals(other.uuid));
    }
}

