/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portletbridge.context;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ELContextEvent;
import javax.el.ELContextListener;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.ApplicationFactory;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseStream;
import javax.faces.context.ResponseWriter;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.portlet.PortletResponse;
import javax.portlet.faces.annotation.PortletNamingContainer;
import org.jboss.portletbridge.context.AbstractExternalContext;
import org.jboss.portletbridge.el.ELContextImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacesContextImpl
extends FacesContext {
    private boolean released = true;
    private boolean renderResponse;
    private boolean responseComplete;
    private Application application = null;
    private UIViewRoot viewRoot = null;
    private Map<String, List<FacesMessage>> messages;
    private AbstractExternalContext externalContext;
    private Lifecycle lifecycle;
    private ResponseWriter responseWriter;
    private ResponseStream responseStream;
    private ELContext elContext;

    public FacesContextImpl(AbstractExternalContext externalContext, Lifecycle lifecycle) {
        FacesContextImpl.setCurrentInstance((FacesContext)this);
        this.externalContext = externalContext;
        this.lifecycle = lifecycle;
        this.released = false;
    }

    public Lifecycle getLifecycle() {
        this.checkReleased();
        return this.lifecycle;
    }

    public ELContext getELContext() {
        ELContextListener[] listeners;
        this.checkReleased();
        if (this.elContext == null) {
            Application application = this.getApplication();
            this.elContext = new ELContextImpl(application.getELResolver());
            this.elContext.putContext(FacesContext.class, (Object)this);
            UIViewRoot root = this.getViewRoot();
            if (null != root) {
                this.elContext.setLocale(root.getLocale());
            }
        }
        if ((listeners = this.application.getELContextListeners()).length > 0) {
            ELContextEvent event = new ELContextEvent(this.elContext);
            for (ELContextListener listener : listeners) {
                listener.contextCreated(event);
            }
        }
        return this.elContext;
    }

    public ExternalContext getExternalContext() {
        this.checkReleased();
        return this.externalContext;
    }

    public ResponseStream getResponseStream() {
        this.checkReleased();
        return this.responseStream;
    }

    public void setResponseStream(ResponseStream responseStream) {
        this.checkReleased();
        this.responseStream = responseStream;
    }

    public ResponseWriter getResponseWriter() {
        this.checkReleased();
        return this.responseWriter;
    }

    public void setResponseWriter(ResponseWriter responseWriter) {
        this.checkReleased();
        this.responseWriter = responseWriter;
    }

    public void release() {
        this.released = true;
        FacesContext.setCurrentInstance(null);
        this.lifecycle = null;
        this.externalContext = null;
        this.responseWriter = null;
        this.application = null;
        this.viewRoot = null;
        this.messages = null;
        this.responseWriter = null;
    }

    public Application getApplication() {
        this.checkReleased();
        if (this.application == null) {
            ApplicationFactory aFactory = (ApplicationFactory)FactoryFinder.getFactory((String)"javax.faces.application.ApplicationFactory");
            this.application = aFactory.getApplication();
        }
        return this.application;
    }

    public Iterator<String> getClientIdsWithMessages() {
        this.checkReleased();
        if (this.messages == null) {
            return Collections.emptyList().iterator();
        }
        return this.messages.keySet().iterator();
    }

    public FacesMessage.Severity getMaximumSeverity() {
        this.checkReleased();
        FacesMessage.Severity max = null;
        Iterator<FacesMessage> messages = this.getMessages();
        while (messages.hasNext()) {
            FacesMessage msg = messages.next();
            FacesMessage.Severity severity = msg.getSeverity();
            if (null != max && max.getOrdinal() >= severity.getOrdinal()) continue;
            max = severity;
        }
        return max;
    }

    public Iterator<FacesMessage> getMessages() {
        this.checkReleased();
        if (this.messages == null) {
            return Collections.emptyList().iterator();
        }
        ArrayList<FacesMessage> messages = new ArrayList<FacesMessage>();
        for (List<FacesMessage> list : this.messages.values()) {
            messages.addAll(list);
        }
        if (messages.size() > 0) {
            return messages.iterator();
        }
        return Collections.emptyList().iterator();
    }

    public Iterator<FacesMessage> getMessages(String clientID) {
        List<FacesMessage> list;
        this.checkReleased();
        if (this.messages != null && (list = this.messages.get(clientID)) != null) {
            return list.iterator();
        }
        return Collections.emptyList().iterator();
    }

    public RenderKit getRenderKit() {
        this.checkReleased();
        UIViewRoot viewRoot = this.getViewRoot();
        if (viewRoot == null) {
            return null;
        }
        String renderKitId = viewRoot.getRenderKitId();
        if (renderKitId == null) {
            return null;
        }
        RenderKitFactory rkFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
        return rkFactory.getRenderKit((FacesContext)this, renderKitId);
    }

    public boolean getRenderResponse() {
        this.checkReleased();
        return this.renderResponse;
    }

    public boolean getResponseComplete() {
        this.checkReleased();
        return this.responseComplete;
    }

    public UIViewRoot getViewRoot() {
        this.checkReleased();
        return this.viewRoot;
    }

    public void setViewRoot(UIViewRoot viewRoot) {
        Object response;
        this.checkReleased();
        this.viewRoot = viewRoot;
        if (viewRoot instanceof PortletNamingContainer && (response = this.getExternalContext().getResponse()) instanceof PortletResponse) {
            PortletResponse portletResponse = (PortletResponse)response;
            portletResponse.setProperty("X-JAVAX-PORTLET-IS-NAMESPACED", "true");
        }
    }

    public void addMessage(String clientID, FacesMessage message) {
        List<FacesMessage> list;
        this.checkReleased();
        if (message == null) {
            throw new NullPointerException("Message can't be null");
        }
        if (this.messages == null) {
            this.messages = new LinkedHashMap<String, List<FacesMessage>>();
        }
        if ((list = this.messages.get(clientID)) == null) {
            list = new ArrayList<FacesMessage>();
            this.messages.put(clientID, list);
        }
        list.add(message);
    }

    public void renderResponse() {
        this.checkReleased();
        this.renderResponse = true;
    }

    public void responseComplete() {
        this.checkReleased();
        this.responseComplete = true;
    }

    private void checkReleased() {
        if (this.released) {
            throw new IllegalStateException("Context is released.");
        }
    }
}

