/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portletbridge.context;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import javax.portlet.MimeResponse;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.servlet.http.HttpServletRequest;
import org.jboss.portletbridge.context.MimeExternalContextImpl;
import org.jboss.portletbridge.context.PortalActionURL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceRequestExternalContextImpl
extends MimeExternalContextImpl {
    public void setRequestCharacterEncoding(String encoding) throws UnsupportedEncodingException {
        try {
            this.getRequest().setCharacterEncoding(encoding);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public ResourceRequestExternalContextImpl(PortletContext context, ResourceRequest request, ResourceResponse response) {
        super(context, (PortletRequest)request, (MimeResponse)response);
    }

    public void redirect(String url) throws IOException {
        if (null == url || url.length() < 0) {
            throw new NullPointerException("Path to redirect is null");
        }
        PortalActionURL actionURL = new PortalActionURL(url);
        if (!actionURL.isInContext(this.getRequestContextPath()) && null == actionURL.getParameter("_jsfBridgeViewId") || "true".equalsIgnoreCase(actionURL.getParameter("javax.portlet.faces.DirectLink"))) {
            this.dispatch(actionURL.getPath());
        } else {
            this.internalRedirect(actionURL);
        }
    }

    public ResourceRequest getRequest() {
        return (ResourceRequest)super.getRequest();
    }

    public ResourceResponse getResponse() {
        return (ResourceResponse)super.getResponse();
    }

    private HttpServletRequest getMultipartRequest() {
        return (HttpServletRequest)this.getRequest().getAttribute("org.ajax4jsf.request.MultipartRequest");
    }

    @Override
    protected String getRequestParameter(String name) {
        HttpServletRequest multipartRequest = this.getMultipartRequest();
        if (multipartRequest != null) {
            return multipartRequest.getParameter(name);
        }
        return super.getRequestParameter(name);
    }

    @Override
    protected String[] getRequestParameterValues(String name) {
        HttpServletRequest multipartRequest = this.getMultipartRequest();
        if (multipartRequest != null) {
            return multipartRequest.getParameterValues(name);
        }
        return super.getRequestParameterValues(name);
    }

    @Override
    public Map<String, String[]> getRequestParameterValuesMap() {
        HttpServletRequest multipartRequest = this.getMultipartRequest();
        if (multipartRequest != null) {
            return this.createParameterMap(multipartRequest);
        }
        return super.getRequestParameterValuesMap();
    }

    private Map<String, String[]> createParameterMap(HttpServletRequest multipartRequest) {
        HashMap<String, String[]> result = new HashMap<String, String[]>();
        Map multipartMap = multipartRequest.getParameterMap();
        for (String name : multipartMap.keySet()) {
            Object value = multipartMap.get(name);
            if (value instanceof String) {
                result.put(name, new String[]{(String)value});
                continue;
            }
            if (!(value instanceof String[])) continue;
            result.put(name, (String[])value);
        }
        return result;
    }
}

