/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portletbridge.seam;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.portlet.faces.Bridge;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.portletbridge.BridgeRequestScope;
import org.jboss.portletbridge.context.PortletBridgeContext;
import org.jboss.portletbridge.seam.FacesMessages;
import org.jboss.seam.Seam;
import org.jboss.seam.contexts.Context;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.contexts.FacesLifecycle;
import org.jboss.seam.core.ConversationPropagation;
import org.jboss.seam.core.Events;
import org.jboss.seam.core.Init;
import org.jboss.seam.core.Manager;
import org.jboss.seam.exception.Exceptions;
import org.jboss.seam.faces.FacesManager;
import org.jboss.seam.faces.FacesPage;
import org.jboss.seam.faces.Switcher;
import org.jboss.seam.faces.Validation;
import org.jboss.seam.jsf.SeamPhaseListener;
import org.jboss.seam.navigation.Pages;
import org.jboss.seam.pageflow.Pageflow;
import org.jboss.seam.persistence.PersistenceContexts;
import org.jboss.seam.transaction.Transaction;
import org.jboss.seam.transaction.UserTransaction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeamPhaseListenerWrapper
implements PhaseListener {
    private final SeamPhaseListener _defaultListener;
    private static final Log log = LogFactory.getLog(SeamPhaseListenerWrapper.class);
    private static final long serialVersionUID = -8465467659533393697L;

    public SeamPhaseListenerWrapper(PhaseListener defaultListener) {
        this._defaultListener = (SeamPhaseListener)defaultListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterPhase(PhaseEvent event) {
        FacesContext facesContext = event.getFacesContext();
        ExternalContext externalContext = facesContext.getExternalContext();
        Bridge.PortletPhase portletPhase = (Bridge.PortletPhase)externalContext.getRequestMap().get("javax.portlet.faces.phase");
        if (null != portletPhase) {
            try {
                this.raiseEventsAfterPhase(event);
                this.afterPortletPhase(event, facesContext, portletPhase);
            }
            finally {
                FacesLifecycle.clearPhaseId();
            }
        } else {
            this._defaultListener.afterPhase(event);
        }
    }

    protected void afterPortletPhase(PhaseEvent event, FacesContext facesContext, Bridge.PortletPhase portletPhase) {
        PhaseId phaseId = event.getPhaseId();
        if (phaseId == PhaseId.RESTORE_VIEW) {
            this.afterRestoreView(facesContext);
        } else if (phaseId == PhaseId.INVOKE_APPLICATION) {
            this.afterInvokeApplication();
        } else if (phaseId == PhaseId.PROCESS_VALIDATIONS) {
            this.afterProcessValidations(facesContext);
        }
        org.jboss.seam.faces.FacesMessages.afterPhase();
        this.handleTransactionsAfterPhase(event);
        if (phaseId == PhaseId.RENDER_RESPONSE) {
            if (this.isRichFacesResourceRequest(facesContext)) {
                this.finishRequest(facesContext);
            } else {
                this.afterRenderResponse(facesContext);
            }
        }
    }

    protected void finishRequest(FacesContext facesContext) {
        PortletBridgeContext bridgeContext = PortletBridgeContext.getCurrentInstance(facesContext);
        if (null != bridgeContext) {
            BridgeRequestScope windowState = bridgeContext.getRequestScope();
            if (Contexts.isEventContextActive()) {
                Manager manager = Manager.instance();
                if (manager.isLongRunningConversation()) {
                    windowState.setConversationIdParameter(manager.getConversationIdParameter());
                    windowState.setConversationId(manager.getCurrentConversationId());
                } else {
                    windowState.setConversationIdParameter(null);
                    windowState.setConversationId(null);
                }
            }
        }
        ExternalContext externalContext = facesContext.getExternalContext();
        if (Contexts.isEventContextActive()) {
            Manager.instance().endRequest(externalContext.getSessionMap());
        }
        FacesLifecycle.endRequest((ExternalContext)facesContext.getExternalContext());
    }

    protected void saveFacesMessages(FacesContext facesContext) {
        PortletBridgeContext bridgeContext;
        if (Contexts.isConversationContextActive() && null != (bridgeContext = PortletBridgeContext.getCurrentInstance(facesContext))) {
            BridgeRequestScope windowState = bridgeContext.getRequestScope();
            FacesMessages.afterPhase();
            FacesMessages messages = FacesMessages.instance();
            ArrayList<FacesMessage> messageList = new ArrayList<FacesMessage>(messages.getStatusMessages());
            Map<String, List<FacesMessage>> messagesMap = windowState.getMessages();
            messagesMap.put("", messageList);
        }
    }

    protected void afterRenderResponse(FacesContext facesContext) {
        FacesManager.instance().prepareBackswitch(facesContext);
        PersistenceContexts persistenceContexts = PersistenceContexts.instance();
        if (persistenceContexts != null) {
            persistenceContexts.afterRender();
        }
    }

    protected void afterRestoreView(FacesContext facesContext) {
        FacesLifecycle.resumePage();
        Map parameters = facesContext.getExternalContext().getRequestParameterMap();
        ConversationPropagation.instance().restoreConversationId(parameters);
        boolean conversationFound = Manager.instance().restoreConversation();
        FacesLifecycle.resumeConversation((ExternalContext)facesContext.getExternalContext());
        if (!this.isRichFacesResourceRequest(facesContext)) {
            this.afterRestorePage(facesContext, parameters, conversationFound);
        }
    }

    protected boolean isRichFacesResourceRequest(FacesContext facesContext) {
        return null != facesContext.getExternalContext().getRequestMap().get("org.jboss.portletbridge.richfaces.Resource");
    }

    protected void afterRestorePage(FacesContext facesContext, Map<String, String> parameters, boolean conversationFound) {
        if (!Pages.isDebugPage()) {
            if (!conversationFound && !Pages.instance().isLoginRedirectRequired(facesContext)) {
                Pages.instance().redirectToNoConversationView();
            }
            Manager.instance().handleConversationPropagation(parameters);
            if (Init.instance().isJbpmInstalled() && !this.isExceptionHandlerRedirect()) {
                Pageflow.instance().validatePageflow(facesContext);
            }
            Pages.instance().postRestore(facesContext);
        }
    }

    protected boolean isExceptionHandlerRedirect() {
        return Contexts.getConversationContext().isSet("org.jboss.seam.handledException");
    }

    protected void afterInvokeApplication() {
        if (Init.instance().isTransactionManagementEnabled()) {
            this.raiseTransactionFailedEvent();
        }
    }

    protected void afterProcessValidations(FacesContext facesContext) {
        Validation.instance().afterProcessValidations(facesContext);
    }

    protected void raiseEventsAfterPhase(PhaseEvent event) {
        if (Contexts.isApplicationContextActive()) {
            Events.instance().raiseEvent("org.jboss.seam.afterPhase", new Object[]{event});
        }
    }

    public void beforePhase(PhaseEvent event) {
        FacesContext facesContext = event.getFacesContext();
        ExternalContext externalContext = facesContext.getExternalContext();
        Bridge.PortletPhase portletPhase = (Bridge.PortletPhase)externalContext.getRequestMap().get("javax.portlet.faces.phase");
        if (null != portletPhase) {
            log.trace((Object)("before phase: " + event.getPhaseId()));
            FacesLifecycle.setPhaseId((PhaseId)event.getPhaseId());
            try {
                this.beforePortletPhase(event, facesContext, portletPhase);
                this.raiseEventsBeforePhase(event);
            }
            catch (Exception e) {
                log.debug((Object)"uncaught exception, try to recovery", (Throwable)e);
                try {
                    Exceptions.instance().handle(e);
                }
                catch (Exception ehe) {
                    log.error((Object)"swallowing exception", (Throwable)e);
                }
            }
        } else {
            this._defaultListener.beforePhase(event);
        }
    }

    protected void beforePortletPhase(PhaseEvent event, FacesContext facesContext, Bridge.PortletPhase portletPhase) {
        if (event.getPhaseId() == PhaseId.RESTORE_VIEW && this.isRichFacesResourceRequest(facesContext)) {
            this.beginRequest(facesContext);
        }
        this.handleTransactionsBeforePhase(event);
        if (event.getPhaseId() == PhaseId.RENDER_RESPONSE) {
            this.beforeRenderResponse(facesContext);
        }
    }

    protected void beginRequest(FacesContext facesContext) {
        FacesLifecycle.beginRequest((ExternalContext)facesContext.getExternalContext());
    }

    protected void beforeRenderResponse(FacesContext facesContext) {
        if (Contexts.isPageContextActive()) {
            Context pageContext = Contexts.getPageContext();
            pageContext.flush();
            pageContext.remove(Seam.getComponentName(Switcher.class));
            pageContext.remove("org.jboss.seam.core.conversationList");
            pageContext.remove("org.jboss.seam.core.conversationStack");
        }
        this.performPageActions(facesContext);
        if (facesContext.getResponseComplete()) {
            if (Init.instance().isMyFacesLifecycleBug()) {
                FacesLifecycle.endRequest((ExternalContext)facesContext.getExternalContext());
            }
        } else {
            org.jboss.seam.faces.FacesMessages.instance().beforeRenderResponse();
            FacesManager.instance().prepareBackswitch(facesContext);
        }
        FacesPage.instance().storeConversation();
        FacesPage.instance().storePageflow();
        PersistenceContexts persistenceContexts = PersistenceContexts.instance();
        if (persistenceContexts != null) {
            persistenceContexts.beforeRender();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean performPageActions(FacesContext facesContext) {
        if (Pages.isDebugPage()) {
            return false;
        }
        FacesLifecycle.setPhaseId((PhaseId)PhaseId.INVOKE_APPLICATION);
        boolean actionsWereCalled = false;
        try {
            boolean bl = actionsWereCalled = Pages.instance().preRender(facesContext);
            return bl;
        }
        finally {
            FacesLifecycle.setPhaseId((PhaseId)PhaseId.RENDER_RESPONSE);
            if (actionsWereCalled) {
                org.jboss.seam.faces.FacesMessages.afterPhase();
                this.handleTransactionsAfterPageActions(facesContext);
            }
        }
    }

    protected void raiseEventsBeforePhase(PhaseEvent event) {
        if (Contexts.isApplicationContextActive()) {
            Events.instance().raiseEvent("org.jboss.seam.beforePhase", new Object[]{event});
        }
    }

    protected void raiseTransactionFailedEvent() {
        try {
            UserTransaction tx = Transaction.instance();
            if (tx.isRolledBackOrMarkedRollback() && Events.exists()) {
                Events.instance().raiseEvent("org.jboss.seam.transaction.transactionFailed", new Object[]{tx.getStatus()});
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void handleTransactionsAfterPhase(PhaseEvent event) {
        if (Init.instance().isTransactionManagementEnabled()) {
            boolean commitTran;
            PhaseId phaseId = event.getPhaseId();
            boolean bl = commitTran = phaseId == PhaseId.INVOKE_APPLICATION || event.getFacesContext().getRenderResponse() || event.getFacesContext().getResponseComplete() || phaseId == PhaseId.RENDER_RESPONSE;
            if (commitTran) {
                this.commitOrRollback(phaseId);
            }
        }
    }

    protected void handleTransactionsAfterPageActions(FacesContext facesContext) {
        if (Init.instance().isTransactionManagementEnabled()) {
            this.commitOrRollback("after invoking page actions");
            if (!facesContext.getResponseComplete()) {
                this.begin("before continuing render");
            }
        }
    }

    protected void handleTransactionsBeforePhase(PhaseEvent event) {
        if (Init.instance().isTransactionManagementEnabled()) {
            boolean beginTran;
            PhaseId phaseId = event.getPhaseId();
            boolean bl = phaseId == PhaseId.RENDER_RESPONSE || phaseId == (Transaction.instance().isConversationContextRequired() ? PhaseId.APPLY_REQUEST_VALUES : PhaseId.RESTORE_VIEW) ? true : (beginTran = false);
            if (beginTran) {
                this.begin(phaseId);
            }
        }
    }

    protected void begin(PhaseId phaseId) {
        this.begin("prior to phase: " + phaseId);
    }

    protected void begin(String phaseString) {
        try {
            if (!Transaction.instance().isActiveOrMarkedRollback()) {
                log.debug((Object)("beginning transaction " + phaseString));
                Transaction.instance().begin();
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not start transaction", e);
        }
    }

    protected void commitOrRollback(PhaseId phaseId) {
        this.commitOrRollback("after phase: " + phaseId);
    }

    protected void commitOrRollback(String phaseString) {
        try {
            if (Transaction.instance().isActive()) {
                try {
                    log.debug((Object)("committing transaction " + phaseString));
                    Transaction.instance().commit();
                }
                catch (IllegalStateException e) {
                    log.warn((Object)"TX commit failed with illegal state exception. This may be because the tx timed out and was rolled back in the background.", (Throwable)e);
                }
            } else if (Transaction.instance().isRolledBackOrMarkedRollback()) {
                log.debug((Object)("rolling back transaction " + phaseString));
                Transaction.instance().rollback();
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not commit transaction", e);
        }
    }

    public PhaseId getPhaseId() {
        return this._defaultListener.getPhaseId();
    }
}

