/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portletbridge.seam;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.logging.Level;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.render.RenderKitFactory;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceResponse;
import org.jboss.portletbridge.BridgeConfig;
import org.jboss.portletbridge.BridgeStrategy;
import org.jboss.portletbridge.BridgeStrategyWrapper;
import org.jboss.portletbridge.seam.PortletScope;
import org.jboss.portletbridge.seam.SeamPhaseListenerWrapper;
import org.jboss.seam.Component;
import org.jboss.seam.Seam;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.contexts.FacesLifecycle;
import org.jboss.seam.core.Init;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.jsf.SeamPhaseListener;
import org.jboss.seam.navigation.Pages;

public class SeamStrategy
extends BridgeStrategyWrapper {
    private final BridgeStrategy parent;
    private SeamPhaseListenerWrapper seamListenerWrapper;

    public SeamStrategy(BridgeConfig config, BridgeStrategy parent) {
        super(config);
        Seam.class.getName();
        this.parent = parent;
    }

    public int getPortletSessionScopeForName(String name) {
        if (Contexts.isApplicationContextActive()) {
            Component component = Component.forName((String)name);
            if (null == component) {
                return this.parent.getPortletSessionScopeForName(name);
            }
            PortletScope portletScope = component.getBeanClass().getAnnotation(PortletScope.class);
            return null != portletScope ? portletScope.value().getScopeType() : this.parent.getPortletSessionScopeForName(name);
        }
        return this.parent.getPortletSessionScopeForName(name);
    }

    protected BridgeStrategy getWrapped() {
        return this.parent;
    }

    public void init(FacesContext context, RenderKitFactory renderKitFactory) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (null != classLoader) {
            try {
                Class<?> seamCommandClass = classLoader.loadClass("org.jboss.seam.ui.component.UISeamCommandBase");
                Field portletRequestField = seamCommandClass.getDeclaredField("PORTLET_REQUEST");
                if (Modifier.isStatic(portletRequestField.getModifiers())) {
                    portletRequestField.setAccessible(true);
                    portletRequestField.set(null, null);
                }
            }
            catch (ClassNotFoundException e) {
            }
            catch (SecurityException e) {
                log.severe("Security manager does not allow access to the org.jboss.seam.ui.component.UISeamCommandBase class. It is necessary to fix PBR-125 issue");
            }
            catch (NoSuchFieldException e) {
            }
            catch (IllegalArgumentException e) {
                log.log(Level.SEVERE, "Error in attempt to set null value for org.jboss.seam.ui.component.UISeamCommandBase#PORTLET_REQUEST field. It is necessary to fix PBR-125 issue.", e);
            }
            catch (IllegalAccessException e) {
                log.log(Level.SEVERE, "Security manager does not allow access to the org.jboss.seam.ui.component.UISeamCommandBase class. It is necessary to fix PBR-125 issue", e);
            }
        }
        Lifecycle lifecycle = this.getConfig().getFacesLifecycle();
        for (PhaseListener listener : lifecycle.getPhaseListeners()) {
            if (!SeamPhaseListener.class.equals(listener.getClass())) continue;
            lifecycle.removePhaseListener(listener);
            this.seamListenerWrapper = new SeamPhaseListenerWrapper(listener);
            lifecycle.addPhaseListener((PhaseListener)this.seamListenerWrapper);
        }
        if (null == this.seamListenerWrapper) {
            this.seamListenerWrapper = new SeamPhaseListenerWrapper(null);
        }
        this.parent.init(context, renderKitFactory);
    }

    public void beforeActionRequest(FacesContext facesContext) {
        this.seamListenerWrapper.beginRequest(facesContext);
        super.beforeActionRequest(facesContext);
    }

    public void afterActionRequest(FacesContext facesContext) {
        super.afterActionRequest(facesContext);
        this.seamListenerWrapper.saveFacesMessages(facesContext);
        this.seamListenerWrapper.finishRequest(facesContext);
    }

    public void afterActionRequestExecute(FacesContext facesContext) {
        this.performPageActions(facesContext);
        super.afterActionRequestExecute(facesContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performPageActions(FacesContext facesContext) {
        if (!facesContext.getResponseComplete() && !Pages.isDebugPage()) {
            if (Init.instance().isTransactionManagementEnabled()) {
                this.seamListenerWrapper.begin("Page actions");
            }
            FacesLifecycle.setPhaseId((PhaseId)PhaseId.INVOKE_APPLICATION);
            boolean actionsWereCalled = false;
            try {
                actionsWereCalled = Pages.instance().preRender(facesContext);
            }
            finally {
                if (actionsWereCalled) {
                    FacesMessages.afterPhase();
                }
                if (Init.instance().isTransactionManagementEnabled()) {
                    this.seamListenerWrapper.commitOrRollback("After Page actions");
                }
                FacesLifecycle.clearPhaseId();
            }
        }
    }

    public void beforeEventRequest(FacesContext facesContext) {
        this.seamListenerWrapper.beginRequest(facesContext);
        super.beforeEventRequest(facesContext);
    }

    public void afterEventRequest(FacesContext facesContext) {
        super.afterEventRequest(facesContext);
        this.seamListenerWrapper.finishRequest(facesContext);
    }

    public void beforeResourceRequest(FacesContext facesContext) {
        this.seamListenerWrapper.beginRequest(facesContext);
        super.beforeResourceRequest(facesContext);
    }

    public void afterResourceRequestExecute(FacesContext facesContext) {
        this.performPageActions(facesContext);
        this.seamListenerWrapper.saveFacesMessages(facesContext);
        super.afterResourceRequestExecute(facesContext);
    }

    public void afterResourceRequest(FacesContext facesContext, ResourceResponse wrappedResponse) {
        super.afterResourceRequest(facesContext, wrappedResponse);
        this.seamListenerWrapper.finishRequest(facesContext);
    }

    public void beforeRenderRequest(FacesContext facesContext) {
        this.seamListenerWrapper.beginRequest(facesContext);
        if (null != facesContext.getViewRoot()) {
            FacesLifecycle.setPhaseId((PhaseId)PhaseId.RENDER_RESPONSE);
            this.seamListenerWrapper.afterRestoreView(facesContext);
        }
        super.beforeRenderRequest(facesContext);
    }

    public void afterRenderRequest(FacesContext facesContext, RenderResponse wrappedResponse) {
        super.afterRenderRequest(facesContext, wrappedResponse);
        this.seamListenerWrapper.finishRequest(facesContext);
    }
}

