/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portletbridge.application.view;

import java.util.regex.Pattern;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.view.ViewDeclarationLanguage;
import javax.faces.view.ViewDeclarationLanguageFactory;
import javax.portlet.faces.Bridge;
import javax.portlet.faces.BridgeUtil;
import org.jboss.portletbridge.application.view.PortletJspVdlImpl;

public class PortletVdlFactoryImpl
extends ViewDeclarationLanguageFactory {
    private static final String DISABLE_JSF_FACELET_INIT_PARAM = "javax.faces.DISABLE_FACELET_JSF_VIEWHANDLER";
    private ViewDeclarationLanguageFactory wrappedFactory;
    private ViewDeclarationLanguage nonFaceletVDL;
    private String viewExtension;
    private Pattern viewMappingPattern;

    public PortletVdlFactoryImpl(ViewDeclarationLanguageFactory wrappedFactory) {
        this.wrappedFactory = wrappedFactory;
        ExternalContext extContext = FacesContext.getCurrentInstance().getExternalContext();
        if (null != extContext) {
            this.viewExtension = this.loadFaceletExtension(extContext);
            this.viewMappingPattern = this.loadFaceletMappingPattern(extContext);
        }
    }

    public ViewDeclarationLanguageFactory getWrapped() {
        return this.wrappedFactory;
    }

    public ViewDeclarationLanguage getViewDeclarationLanguage(String viewId) {
        ViewDeclarationLanguage vdl = this.getWrapped().getViewDeclarationLanguage(viewId);
        ExternalContext extContext = FacesContext.getCurrentInstance().getExternalContext();
        if (BridgeUtil.isPortletRequest() && !this.isFacelet(extContext, viewId)) {
            if (null == this.nonFaceletVDL) {
                String renderPolicy = extContext.getInitParameter("javax.portlet.faces.RENDER_POLICY");
                if (null == renderPolicy) {
                    renderPolicy = Bridge.BridgeRenderPolicy.DEFAULT.toString();
                }
                switch (Bridge.BridgeRenderPolicy.valueOf((String)renderPolicy)) {
                    case ALWAYS_DELEGATE: {
                        this.nonFaceletVDL = vdl;
                        break;
                    }
                    default: {
                        this.nonFaceletVDL = new PortletJspVdlImpl(vdl);
                    }
                }
            }
            return this.nonFaceletVDL;
        }
        return vdl;
    }

    protected boolean isFacelet(ExternalContext extContext, String viewId) {
        String faceletsDisabled = extContext.getInitParameter(DISABLE_JSF_FACELET_INIT_PARAM);
        if (null != faceletsDisabled && Boolean.parseBoolean(faceletsDisabled.toLowerCase())) {
            return false;
        }
        if (viewId.endsWith(this.viewExtension)) {
            return true;
        }
        return this.viewMappingPattern != null && this.viewMappingPattern.matcher(viewId).matches();
    }

    protected String loadFaceletExtension(ExternalContext extContext) {
        String faceletSuffix = extContext.getInitParameter("javax.faces.FACELETS_SUFFIX");
        if (null != faceletSuffix) {
            faceletSuffix = faceletSuffix.trim();
        }
        if (null == faceletSuffix || faceletSuffix.length() == 0) {
            faceletSuffix = ".xhtml";
        }
        return faceletSuffix;
    }

    protected Pattern loadFaceletMappingPattern(ExternalContext extContext) {
        String viewMappings = extContext.getInitParameter("javax.faces.FACELETS_VIEW_MAPPINGS");
        if (null == viewMappings) {
            return null;
        }
        if ((viewMappings = viewMappings.trim()).length() == 0) {
            return null;
        }
        return Pattern.compile(this.convertToRegex(viewMappings));
    }

    protected String convertToRegex(String viewMappings) {
        viewMappings = viewMappings.replaceAll("\\s", "");
        viewMappings = viewMappings.replaceAll("\\.", "\\\\.");
        viewMappings = viewMappings.replaceAll("\\*", ".*");
        viewMappings = viewMappings.replaceAll(";", "|");
        return viewMappings;
    }
}

