/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portletbridge.context;

import java.net.MalformedURLException;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.portletbridge.context.PortalUrlQueryString;

public class PortalActionURL {
    private static final Pattern urlPattern = Pattern.compile("^(\\w*:)?(//[\\w\\._-]+[^/:?])?((?:\\:)(\\d+))?([^?]*)?((?:\\?)(.*))?$");
    private String protocol;
    private String host;
    private int port = -1;
    private String authority;
    private transient String path;
    private transient String userInfo;
    private PortalUrlQueryString queryString;
    private int _length;

    public PortalActionURL(String url) throws MalformedURLException {
        this(url, false);
    }

    public PortalActionURL(String url, boolean escape) throws MalformedURLException {
        Matcher urlMatcher = urlPattern.matcher(url);
        if (!urlMatcher.matches()) {
            throw new MalformedURLException(url);
        }
        this._length = url.length();
        this.protocol = urlMatcher.group(1);
        this.host = urlMatcher.group(2);
        String portStr = urlMatcher.group(4);
        if (null != portStr && portStr.length() > 0) {
            this.port = Integer.parseInt(portStr);
        }
        this.path = urlMatcher.group(5);
        this.queryString = new PortalUrlQueryString(urlMatcher.group(7), escape);
    }

    public PortalActionURL(PortalActionURL src, boolean escape) {
        if (null == src) {
            throw new NullPointerException("Source URL is null");
        }
        this._length = src._length;
        this.protocol = src.protocol;
        this.host = src.host;
        this.port = src.port;
        this.path = src.path;
        this.queryString = new PortalUrlQueryString(src.getQueryString(), escape);
        this.authority = src.authority;
        this.userInfo = src.userInfo;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getAuthority() {
        return this.authority;
    }

    public String getPath() {
        return this.path;
    }

    public String getUserInfo() {
        return this.userInfo;
    }

    public String getQueryString() {
        if (null != this.queryString) {
            return this.queryString.toString();
        }
        return null;
    }

    public boolean hasParameter(String name) {
        return this.queryString.hasParameter(name);
    }

    public String getParameter(String name) {
        return this.queryString.getParameter(name);
    }

    public void setParameter(String name, String value) {
        this.queryString.setParameter(name, value);
    }

    public void addParameter(String name, String value) {
        this.queryString.addParameter(name, value);
    }

    public String removeParameter(String name) {
        return this.queryString.removeParameter(name);
    }

    public int parametersSize() {
        return this.queryString.parametersSize();
    }

    public boolean isInContext(String context) {
        return this.host == null && this.protocol == null && this.port == -1 && (this.path.startsWith(context + "/") || !this.path.startsWith("/"));
    }

    public String toString() {
        StringBuilder url = new StringBuilder(this._length);
        if (null != this.protocol) {
            url.append(this.protocol);
        }
        if (null != this.host) {
            url.append(this.host);
        }
        if (this.port > 0) {
            url.append(':').append(this.port);
        }
        url.append(this.path);
        String queryString = this.getQueryString();
        if (null != queryString) {
            url.append('?').append(queryString);
        }
        return url.toString();
    }

    public Map<String, String[]> getParameters() {
        return this.queryString.getParameters();
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setAuthority(String authority) {
        this.authority = authority;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setUserInfo(String userInfo) {
        this.userInfo = userInfo;
    }

    public void setParameters(Map<String, String[]> parameters) {
        this.queryString.setParameters(parameters);
    }

    public void setQueryString(String queryString, boolean escape) {
        this.queryString = new PortalUrlQueryString(queryString, escape);
    }
}

