/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portletbridge.context;

import javax.faces.FacesException;
import javax.faces.context.ExternalContext;
import javax.faces.context.ExternalContextFactory;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.faces.Bridge;
import org.jboss.portletbridge.bridge.logger.BridgeLogger;
import org.jboss.portletbridge.bridge.logger.JULLoggerImpl;
import org.jboss.portletbridge.context.ActionRequestExternalContextImpl;
import org.jboss.portletbridge.context.EventRequestExternalContextImpl;
import org.jboss.portletbridge.context.PortletExternalContextImpl;
import org.jboss.portletbridge.context.RenderPortletExternalContextImpl;
import org.jboss.portletbridge.context.ResourceRequestExternalContextImpl;

public class PortletExternalContextFactoryImpl
extends ExternalContextFactory {
    private ExternalContextFactory mWrapped;
    private static final BridgeLogger logger = new JULLoggerImpl(PortletExternalContextImpl.class.getName());

    public PortletExternalContextFactoryImpl(ExternalContextFactory factory) {
        this.mWrapped = factory;
        logger.log(BridgeLogger.Level.DEBUG, "Portlet Bridge - specific PortletExternalContextFactory has been initialised");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ExternalContext getExternalContext(Object context, Object request, Object response) throws FacesException {
        ExternalContext externalContext;
        Object portletPhase;
        if (null == context) throw new NullPointerException("One or more parameters for a external context instantiation is null");
        if (null == request) throw new NullPointerException("One or more parameters for a external context instantiation is null");
        if (null == response) {
            throw new NullPointerException("One or more parameters for a external context instantiation is null");
        }
        if (!(context instanceof PortletContext)) return this.getWrapped().getExternalContext(context, request, response);
        Object object = portletPhase = request instanceof PortletRequest ? ((PortletRequest)request).getAttribute("javax.portlet.faces.phase") : null;
        if (Bridge.PortletPhase.ACTION_PHASE.equals(portletPhase) && request instanceof ActionRequest && response instanceof ActionResponse) {
            externalContext = new ActionRequestExternalContextImpl((PortletContext)context, (ActionRequest)request, (ActionResponse)response);
            logger.log(BridgeLogger.Level.DEBUG, "Portal request - create portal version of the ExternalContext for action request");
            return externalContext;
        } else if (Bridge.PortletPhase.RENDER_PHASE.equals(portletPhase) && request instanceof RenderRequest && response instanceof RenderResponse) {
            externalContext = new RenderPortletExternalContextImpl((PortletContext)context, (RenderRequest)request, (RenderResponse)response);
            logger.log(BridgeLogger.Level.DEBUG, "Portal request - create portal version of the ExternalContext for render response");
            return externalContext;
        } else if (Bridge.PortletPhase.RESOURCE_PHASE.equals(portletPhase) && request instanceof ResourceRequest && response instanceof ResourceResponse) {
            externalContext = new ResourceRequestExternalContextImpl((PortletContext)context, (ResourceRequest)request, (ResourceResponse)response);
            logger.log(BridgeLogger.Level.DEBUG, "Portal request - create portal version of the ExternalContext for resource response");
            return externalContext;
        } else {
            if (!Bridge.PortletPhase.EVENT_PHASE.equals(portletPhase)) throw new FacesException("Invalid objects passed to getExternalContext() for portlet phase " + portletPhase.toString());
            if (!(request instanceof EventRequest)) throw new FacesException("Invalid objects passed to getExternalContext() for portlet phase " + portletPhase.toString());
            if (!(response instanceof EventResponse)) throw new FacesException("Invalid objects passed to getExternalContext() for portlet phase " + portletPhase.toString());
            externalContext = new EventRequestExternalContextImpl((PortletContext)context, (EventRequest)request, (EventResponse)response);
            logger.log(BridgeLogger.Level.DEBUG, "Portal request - create portal version of the ExternalContext for event request");
        }
        return externalContext;
    }

    public ExternalContextFactory getWrapped() {
        return this.mWrapped;
    }
}

