/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portletbridge.lifecycle;

import java.util.Set;
import javax.faces.context.FacesContext;
import javax.faces.context.Flash;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import javax.portlet.faces.Bridge;
import javax.portlet.faces.BridgeUtil;
import org.jboss.portletbridge.renderkit.portlet.HeadResources;

public class HeadResourcesPhaseListener
implements PhaseListener {
    private static final long serialVersionUID = 5336202107411409441L;
    private static final String HEAD_RESOURCE_IDS = "headResourceIds";

    public void afterPhase(PhaseEvent event) {
    }

    public void beforePhase(PhaseEvent event) {
        FacesContext context = event.getFacesContext();
        if (context != FacesContext.getCurrentInstance() || !BridgeUtil.isPortletRequest()) {
            return;
        }
        Bridge.PortletPhase portletPhase = BridgeUtil.getPortletRequestPhase();
        if (Bridge.PortletPhase.RENDER_PHASE.equals((Object)portletPhase) || Bridge.PortletPhase.RESOURCE_PHASE.equals((Object)portletPhase)) {
            if (PhaseId.INVOKE_APPLICATION.equals(event.getPhaseId())) {
                this.beforeInvoke(context);
            } else if (PhaseId.RENDER_RESPONSE.equals(event.getPhaseId())) {
                this.beforeRender(context);
            }
        }
    }

    protected void beforeInvoke(FacesContext context) {
        HeadResources bean;
        Flash flash = context.getExternalContext().getFlash();
        Set resourceIds = (Set)flash.get((Object)HEAD_RESOURCE_IDS);
        if (null != resourceIds && null != (bean = HeadResources.instance())) {
            flash.put((Object)HEAD_RESOURCE_IDS, bean.getIds());
        }
    }

    protected void beforeRender(FacesContext context) {
        HeadResources bean;
        Flash flash = context.getExternalContext().getFlash();
        Set resourceIds = (Set)flash.get((Object)HEAD_RESOURCE_IDS);
        if (null != resourceIds && null != (bean = HeadResources.instance())) {
            Set<String> beanIds = bean.getIds();
            for (String id : resourceIds) {
                if (beanIds.contains(id)) continue;
                beanIds.add(id);
            }
        }
    }

    public PhaseId getPhaseId() {
        return PhaseId.ANY_PHASE;
    }
}

