/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portletbridge.renderkit.portlet;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Stack;
import javax.faces.component.UIComponent;
import javax.faces.context.ResponseWriter;
import javax.faces.context.ResponseWriterWrapper;
import javax.portlet.PortletResponse;
import org.jboss.portletbridge.bridge.context.BridgeContext;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class PortletHeadResponseWriter
extends ResponseWriterWrapper {
    ResponseWriter wrapped;
    PortletResponse response;
    private Stack<Element> elements;
    private boolean preventSelfClosing = false;

    public PortletHeadResponseWriter(ResponseWriter parent, PortletResponse portletResponse) {
        this.wrapped = parent;
        this.response = portletResponse;
        this.elements = new Stack();
        this.preventSelfClosing = BridgeContext.getCurrentInstance().getBridgeConfig().doPreventSelfClosingScriptTag();
    }

    public ResponseWriter getWrapped() {
        return this.wrapped;
    }

    public void startElement(String name, UIComponent component) throws IOException {
        this.elements.push(this.response.createElement(name));
    }

    public void endElement(String name) throws IOException {
        if (this.elements.size() > 1) {
            Element child = this.elements.pop();
            this.elements.peek().appendChild(child);
        } else {
            Element elem = this.elements.pop();
            if (("script".equalsIgnoreCase(name) || "style".equalsIgnoreCase(name)) && !elem.hasAttribute("src")) {
                CDATASection cdata;
                Text text1;
                Text text2 = null;
                String content = elem.getTextContent();
                Document owner = elem.getOwnerDocument();
                if ("script".equalsIgnoreCase(name)) {
                    text1 = owner.createTextNode("\n//");
                    cdata = owner.createCDATASection("\n" + content + "\n//");
                } else {
                    text1 = owner.createTextNode("\n/*");
                    cdata = owner.createCDATASection("*/\n" + content + "\n/*");
                    text2 = owner.createTextNode("*/");
                }
                elem.setTextContent("");
                elem.appendChild(text1);
                elem.appendChild(cdata);
                if (null != text2) {
                    elem.appendChild(text2);
                }
            } else if (this.preventSelfClosing && "script".equalsIgnoreCase(name) && (null == elem.getTextContent() || elem.getTextContent().length() == 0)) {
                elem.appendChild(elem.getOwnerDocument().createComment(" "));
            }
            this.response.addProperty("javax.portlet.markup.head.element", elem);
        }
    }

    private void append(String content) {
        Element elem = this.elements.peek();
        elem.setTextContent(elem.getTextContent() + content);
    }

    public void writeAttribute(String name, Object value, String property) throws IOException {
        if (null != value) {
            this.elements.peek().setAttribute(name, value.toString());
        } else {
            this.elements.peek().setAttribute(name, null);
        }
    }

    public void writeComment(Object comment) throws IOException {
        if (null != comment) {
            this.append(comment.toString());
        }
    }

    public void writeText(char[] text, int off, int len) throws IOException {
        this.write(text, off, len);
    }

    public void writeText(Object text, UIComponent component, String property) throws IOException {
        if (null != text) {
            this.append(text.toString());
        }
    }

    public void writeText(Object text, String property) throws IOException {
        if (null != text) {
            this.append(text.toString());
        }
    }

    public void writeURIAttribute(String name, Object value, String property) throws IOException {
        this.writeAttribute(name, value, property);
    }

    public Writer append(char c) throws IOException {
        StringWriter writer = new StringWriter();
        writer.write(c);
        this.append(writer.getBuffer().toString());
        return this;
    }

    public Writer append(CharSequence csq, int start, int end) throws IOException {
        StringWriter writer = new StringWriter();
        writer.append(csq, start, end);
        this.append(writer.getBuffer().toString());
        return this;
    }

    public Writer append(CharSequence csq) throws IOException {
        StringWriter writer = new StringWriter();
        writer.append(csq);
        this.append(writer.getBuffer().toString());
        return this;
    }

    public void write(int c) throws IOException {
        StringWriter writer = new StringWriter();
        writer.write(c);
        this.append(writer.getBuffer().toString());
    }

    public void write(char[] cbuf) throws IOException {
        StringWriter writer = new StringWriter();
        writer.write(cbuf);
        this.append(writer.getBuffer().toString());
    }

    public void write(String str) throws IOException {
        if (null != str) {
            this.append(str);
        }
    }

    public void write(String str, int off, int len) throws IOException {
        StringWriter writer = new StringWriter();
        writer.write(str, off, len);
        this.append(writer.getBuffer().toString());
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        StringWriter writer = new StringWriter();
        writer.write(cbuf, off, len);
        this.append(writer.getBuffer().toString());
    }
}

