/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portletbridge.renderkit.portlet;

import java.io.IOException;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.ComponentSystemEventListener;
import javax.faces.event.ListenerFor;
import javax.faces.event.PostAddToViewEvent;
import javax.faces.render.Renderer;
import org.jboss.portletbridge.bridge.logger.BridgeLogger;
import org.jboss.portletbridge.bridge.logger.JULLoggerImpl;
import org.jboss.portletbridge.renderkit.portlet.PortletPartialResponseWriter;
import org.jboss.portletbridge.renderkit.portlet.PortletRendererWrapper;

@ListenerFor(systemEventClass=PostAddToViewEvent.class)
public class PortletScriptRenderer
extends PortletRendererWrapper
implements ComponentSystemEventListener,
StateHolder {
    private static final BridgeLogger logger = new JULLoggerImpl(PortletScriptRenderer.class.getName());
    private boolean transientFlag;
    private Renderer wrappedRenderer;

    public PortletScriptRenderer() {
    }

    public PortletScriptRenderer(Renderer renderer) {
        this.wrappedRenderer = renderer;
    }

    @Override
    public Renderer getWrapped() {
        return this.wrappedRenderer;
    }

    @Override
    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        boolean isPartial = context.getPartialViewContext().isPartialRequest();
        if (isPartial) {
            ResponseWriter original = context.getResponseWriter();
            context.setResponseWriter((ResponseWriter)new PortletPartialResponseWriter(original));
            super.encodeEnd(context, component);
            context.setResponseWriter(original);
        } else {
            super.encodeEnd(context, component);
        }
    }

    public void processEvent(ComponentSystemEvent event) throws AbortProcessingException {
        if (this.wrappedRenderer instanceof ComponentSystemEventListener) {
            ComponentSystemEventListener wrappedListener = (ComponentSystemEventListener)this.wrappedRenderer;
            wrappedListener.processEvent(event);
        }
    }

    public void restoreState(FacesContext facesContext, Object state) {
        if (this.wrappedRenderer == null) {
            try {
                String wrappedRendererClassName = (String)state;
                Class<?> wrappedRendererClass = Class.forName(wrappedRendererClassName);
                this.wrappedRenderer = (Renderer)wrappedRendererClass.newInstance();
            }
            catch (Exception e) {
                logger.log(BridgeLogger.Level.ERROR, "Unable to instantiate wrapped Renderer", (Throwable)e);
            }
        }
    }

    public Object saveState(FacesContext facesContext) {
        return this.wrappedRenderer.getClass().getName();
    }

    public boolean isTransient() {
        return this.transientFlag;
    }

    public void setTransient(boolean newTransientValue) {
        this.transientFlag = newTransientValue;
    }
}

