/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portletbridge;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FactoryFinder;
import javax.faces.application.ApplicationFactory;
import javax.faces.context.FacesContext;
import javax.faces.event.SystemEvent;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.faces.Bridge;
import javax.portlet.faces.BridgeEventHandler;
import javax.portlet.faces.BridgeException;
import javax.portlet.faces.BridgePublicRenderParameterHandler;
import javax.portlet.faces.BridgeUninitializedException;
import javax.portlet.faces.BridgeWriteBehindResponse;
import org.jboss.portletbridge.bridge.config.BridgeConfig;
import org.jboss.portletbridge.bridge.context.BridgeContext;
import org.jboss.portletbridge.bridge.controller.BridgeController;
import org.jboss.portletbridge.bridge.event.BridgeDestroyRequestSystemEvent;
import org.jboss.portletbridge.bridge.event.BridgeInitializeRequestSystemEvent;
import org.jboss.portletbridge.bridge.factory.BridgeConfigFactory;
import org.jboss.portletbridge.bridge.factory.BridgeContextFactory;
import org.jboss.portletbridge.bridge.factory.BridgeControllerFactory;
import org.jboss.portletbridge.bridge.factory.BridgeFactoryFinder;
import org.jboss.portletbridge.bridge.logger.BridgeLogger;
import org.jboss.portletbridge.config.FacesConfigProcessor;
import org.jboss.portletbridge.config.WebXmlProcessor;
import org.jboss.portletbridge.context.InitFacesContext;

public class PortletBridgeImpl
implements Bridge {
    private static final Logger logger = Logger.getLogger(PortletBridgeImpl.class.getName(), "org.jboss.portletbridge.LogMessages");
    private BridgeConfig bridgeConfig;
    private BridgeController bridgeController;
    private boolean initialized = false;

    public void init(PortletConfig portletConfig) throws BridgeException {
        if (null == portletConfig) {
            throw new IllegalArgumentException("PortletConfig null when initializing Portlet Bridge");
        }
        if (this.initialized) {
            throw new BridgeException("Portlet Bridge already initialized");
        }
        String portletName = portletConfig.getPortletName();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Commenced Portlet Bridge initialization for " + portletName);
        }
        this.bridgeConfig = this.getBridgeConfig(portletConfig);
        this.bridgeController = ((BridgeControllerFactory)BridgeFactoryFinder.getFactoryInstance(BridgeControllerFactory.class)).getBridgeController(this.bridgeConfig);
        this.initialized = true;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Completed Portlet Bridge initialization for " + portletName);
        }
    }

    private BridgeConfig getBridgeConfig(PortletConfig portletConfig) {
        String componentNamespaceShortened;
        String bridgeScopeRetained;
        String sessionIdParameter;
        String facesMessagesEnabledParam;
        String ajaxEnabledParam;
        String disableViewParam;
        Map<String, String> publicParams;
        String suffixString;
        BridgeConfig bridgeConfig = ((BridgeConfigFactory)BridgeFactoryFinder.getFactoryInstance(BridgeConfigFactory.class)).getBridgeConfig();
        bridgeConfig.setPortletConfig(portletConfig);
        PortletContext portletContext = portletConfig.getPortletContext();
        String bridgeParametersPrefix = "javax.portlet.faces." + portletConfig.getPortletName() + ".";
        Boolean enableLogging = (Boolean)portletContext.getAttribute(bridgeParametersPrefix + "org.jboss.portletbridge.loggingEnabled");
        bridgeConfig.getLogger().setEnabled(null != enableLogging ? enableLogging : Boolean.FALSE);
        bridgeConfig.setEventHandler((BridgeEventHandler)portletContext.getAttribute(bridgeParametersPrefix + "bridgeEventHandler"));
        bridgeConfig.setPublicRenderParameterHandler((BridgePublicRenderParameterHandler)portletContext.getAttribute(bridgeParametersPrefix + "bridgePublicRenderParameterHandler"));
        bridgeConfig.setPreserveActionParameters((Boolean)portletContext.getAttribute(bridgeParametersPrefix + "preserveActionParams"));
        bridgeConfig.setExcludedRequestAttributes((List)portletContext.getAttribute(bridgeParametersPrefix + "excludedRequestAttributes"));
        String lifecycleId = portletContext.getInitParameter("javax.faces.LIFECYCLE_ID");
        if (null != lifecycleId && lifecycleId.trim().length() != 0) {
            bridgeConfig.setLifecyleId(lifecycleId);
        }
        if (null == (suffixString = portletContext.getInitParameter("javax.faces.DEFAULT_SUFFIX"))) {
            suffixString = ".xhtml .view.xml .jsp";
        }
        bridgeConfig.setFacesSuffixes(Arrays.asList(suffixString.split(" ")));
        WebXmlProcessor webXmlProc = new WebXmlProcessor(portletConfig.getPortletContext());
        if (null == webXmlProc.getFacesServlet()) {
            throw new BridgeException("No Faces Servlet defined in web.xml");
        }
        if (null == webXmlProc.getFacesServlet().getMappings()) {
            throw new BridgeException("No Faces Servlet Mapping defined in web.xml");
        }
        bridgeConfig.setFacesServletMappings(webXmlProc.getFacesServlet().getMappings());
        bridgeConfig.setFacesErrorViewMappings(webXmlProc.getErrorViews());
        List<String> excludedAttrs = FacesConfigProcessor.getExcludedAttributes();
        if (null != excludedAttrs) {
            bridgeConfig.getExcludedRequestAttributes().addAll(excludedAttrs);
        }
        if (null != (publicParams = FacesConfigProcessor.getPublicParameterMappings())) {
            bridgeConfig.getPublicRenderParameterMappings().putAll(publicParams);
        }
        bridgeConfig.setWriteBehindRenderResponseWrapper(this.createWrapper(FacesConfigProcessor.getWriteBehindRenderResponseWrapperClassName()));
        bridgeConfig.setWriteBehindResourceResponseWrapper(this.createWrapper(FacesConfigProcessor.getWriteBehindResourceResponseWrapperClassName()));
        bridgeConfig.setDefaultViewMappings((Map)portletContext.getAttribute(bridgeParametersPrefix + "defaultViewIdMap"));
        if (null == bridgeConfig.getDefaultViewMappings() || 0 == bridgeConfig.getDefaultViewMappings().size()) {
            throw new BridgeException("No JSF view id's defined in portlet.xml for " + portletConfig.getPortletName());
        }
        String preventSelfClosing = portletContext.getInitParameter("org.jboss.portletbridge.PREVENT_SELF_CLOSING_SCRIPT_TAG");
        if (preventSelfClosing != null) {
            bridgeConfig.setPreventSelfClosingScriptTag(Boolean.parseBoolean(preventSelfClosing));
        }
        if ((disableViewParam = portletContext.getInitParameter("org.jboss.portletbridge.VIEW_PARAMETERS_DISABLED")) != null) {
            bridgeConfig.setViewParamHandlingDisabled(Boolean.parseBoolean(disableViewParam));
        }
        if ((ajaxEnabledParam = portletContext.getInitParameter("org.jboss.portletbridge.BRIDGE_SCOPE_ENABLED_ON_AJAX_REQUEST")) != null) {
            bridgeConfig.setBridgeScopeEnabledOnAjaxRequest(Boolean.parseBoolean(ajaxEnabledParam));
        }
        if ((facesMessagesEnabledParam = portletContext.getInitParameter("org.jboss.portletbridge.FACES_MESSAGES_STORED_ON_AJAX_REQUEST")) != null) {
            bridgeConfig.setFacesMessagesStoredOnAjaxRequest(Boolean.parseBoolean(facesMessagesEnabledParam));
        }
        if ((sessionIdParameter = portletContext.getInitParameter("org.jboss.portletbridge.SESSION_ID_PARAMETER_NAME")) != null && sessionIdParameter.trim().length() > 0) {
            bridgeConfig.setSessionIdParameterName(sessionIdParameter);
        }
        if ((bridgeScopeRetained = this.getInitParameter(portletConfig, "org.jboss.portletbridge.BRIDGE_SCOPE_PRESERVED_POST_RENDER")) != null) {
            bridgeConfig.setBridgeScopePreservedPostRender(Boolean.parseBoolean(bridgeScopeRetained));
        }
        if ((componentNamespaceShortened = this.getInitParameter(portletConfig, "org.jboss.portletbridge.COMPONENT_NAMESPACE_SHORTENED")) != null) {
            bridgeConfig.setComponentNamespaceShortened(Boolean.parseBoolean(componentNamespaceShortened));
        }
        try {
            this.getClass().getClassLoader().loadClass("javax.faces.context.FlashFactory");
            bridgeConfig.setJsf22Runtime(true);
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        return bridgeConfig;
    }

    private String getInitParameter(PortletConfig portletConfig, String name) {
        String parameter = portletConfig.getInitParameter(name);
        if (parameter == null) {
            parameter = portletConfig.getPortletContext().getInitParameter(name);
        }
        return parameter;
    }

    private Class<? extends BridgeWriteBehindResponse> createWrapper(String wrapperClassName) {
        if (null != wrapperClassName) {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            try {
                return loader.loadClass(wrapperClassName);
            }
            catch (Exception e) {
                this.bridgeConfig.getLogger().log(BridgeLogger.Level.WARNING, "Unable to instantiate BridgeWriteBehindResponse class: " + wrapperClassName + " due to " + e.getMessage());
                return null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFacesRequest(ActionRequest request, ActionResponse response) throws BridgeException {
        this.assertParameters((PortletRequest)request, (PortletResponse)response);
        try {
            this.initRequest((PortletRequest)request, (PortletResponse)response, Bridge.PortletPhase.ACTION_PHASE);
            BridgeContext bridgeContext = this.getBridgeContext((PortletRequest)request, (PortletResponse)response, Bridge.PortletPhase.ACTION_PHASE);
            this.bridgeController.processPortletAction(bridgeContext);
        }
        finally {
            this.finalizeRequest((PortletRequest)request, BridgeContext.getCurrentInstance());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFacesRequest(EventRequest request, EventResponse response) throws BridgeException {
        this.assertParameters((PortletRequest)request, (PortletResponse)response);
        try {
            this.initRequest((PortletRequest)request, (PortletResponse)response, Bridge.PortletPhase.EVENT_PHASE);
            BridgeContext bridgeContext = this.getBridgeContext((PortletRequest)request, (PortletResponse)response, Bridge.PortletPhase.EVENT_PHASE);
            this.bridgeController.handlePortletEvent(bridgeContext);
        }
        finally {
            this.finalizeRequest((PortletRequest)request, BridgeContext.getCurrentInstance());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFacesRequest(RenderRequest request, RenderResponse response) throws BridgeException {
        this.assertParameters((PortletRequest)request, (PortletResponse)response);
        try {
            this.initRequest((PortletRequest)request, (PortletResponse)response, Bridge.PortletPhase.RENDER_PHASE);
            BridgeContext bridgeContext = this.getBridgeContext((PortletRequest)request, (PortletResponse)response, Bridge.PortletPhase.RENDER_PHASE);
            this.bridgeController.renderPortletBody(bridgeContext);
        }
        finally {
            this.finalizeRequest((PortletRequest)request, BridgeContext.getCurrentInstance());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFacesRequest(ResourceRequest request, ResourceResponse response) throws BridgeException {
        this.assertParameters((PortletRequest)request, (PortletResponse)response);
        try {
            this.initRequest((PortletRequest)request, (PortletResponse)response, Bridge.PortletPhase.RESOURCE_PHASE);
            BridgeContext bridgeContext = this.getBridgeContext((PortletRequest)request, (PortletResponse)response, Bridge.PortletPhase.RESOURCE_PHASE);
            this.bridgeController.renderResource(bridgeContext);
        }
        finally {
            this.finalizeRequest((PortletRequest)request, BridgeContext.getCurrentInstance());
        }
    }

    public void destroy() {
        if (this.initialized) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Destroy Portlet Bridge for " + this.bridgeConfig.getPortletConfig().getPortletName());
            }
            this.bridgeConfig = null;
            this.bridgeController = null;
            this.initialized = false;
        }
    }

    protected void assertParameters(PortletRequest request, PortletResponse response) {
        if (null == request) {
            throw new IllegalArgumentException("PortletRequest parameter is null");
        }
        if (null == response) {
            throw new IllegalArgumentException("PortletResponse parameter is null");
        }
        if (!this.initialized) {
            throw new BridgeUninitializedException("JSF Portlet Bridge is not initialized");
        }
    }

    protected void initRequest(PortletRequest request, PortletResponse response, Bridge.PortletPhase phase) {
        request.setAttribute("javax.portlet.faces.phase", (Object)phase);
    }

    protected BridgeContext getBridgeContext(PortletRequest request, PortletResponse response, Bridge.PortletPhase phase) {
        BridgeContext bridgeContext = ((BridgeContextFactory)BridgeFactoryFinder.getFactoryInstance(BridgeContextFactory.class)).getBridgeContext(this.bridgeConfig);
        bridgeContext.setPortletRequest(request);
        bridgeContext.setPortletRequestPhase(phase);
        bridgeContext.setPortletResponse(response);
        bridgeContext.setPreFacesRequestAttrNames(Collections.list(request.getAttributeNames()));
        this.fireFacesSystemEvent(bridgeContext, BridgeInitializeRequestSystemEvent.class);
        return bridgeContext;
    }

    private void finalizeRequest(PortletRequest request, BridgeContext bridgeContext) {
        request.removeAttribute("javax.portlet.faces.phase");
        if (null != bridgeContext) {
            this.releaseBridgeContext(bridgeContext);
        }
    }

    private void releaseBridgeContext(BridgeContext bridgeContext) {
        this.fireFacesSystemEvent(bridgeContext, BridgeDestroyRequestSystemEvent.class);
        bridgeContext.release();
    }

    private void fireFacesSystemEvent(BridgeContext bridgeContext, Class<? extends SystemEvent> eventClass) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        boolean createdInitContext = false;
        if (null == facesContext) {
            ApplicationFactory factory = (ApplicationFactory)FactoryFinder.getFactory((String)"javax.faces.application.ApplicationFactory");
            facesContext = new InitFacesContext(factory.getApplication(), this.bridgeConfig.getPortletConfig().getPortletContext());
            createdInitContext = true;
        }
        facesContext.getApplication().publishEvent(facesContext, eventClass, (Object)bridgeContext);
        if (createdInitContext) {
            facesContext.release();
        }
    }
}

