/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portletbridge.application.view;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Locale;
import javax.portlet.CacheControl;
import javax.portlet.MimeResponse;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.ResourceURL;
import javax.portlet.faces.BridgeWriteBehindResponse;
import javax.portlet.filter.PortletResponseWrapper;
import org.jboss.portletbridge.io.FastBufferOutputStream;
import org.jboss.portletbridge.io.FastPrintWriter;

public abstract class BufferedMimeResponseWrapper
extends PortletResponseWrapper
implements MimeResponse,
BridgeWriteBehindResponse {
    protected FastBufferOutputStream fastBufferStream = null;
    protected FastPrintWriter fastPrintWriter = null;
    private boolean hasWriteBehindMarkup = false;

    public BufferedMimeResponseWrapper(MimeResponse response) {
        super((PortletResponse)response);
    }

    public MimeResponse getResponse() {
        return (MimeResponse)super.getResponse();
    }

    public FastBufferOutputStream getPortletOutputStream() throws IOException {
        if (null != this.fastPrintWriter) {
            throw new IllegalStateException();
        }
        if (null == this.fastBufferStream) {
            this.fastBufferStream = new FastBufferOutputStream();
        }
        return this.fastBufferStream;
    }

    public FastPrintWriter getWriter() throws IOException {
        if (null != this.fastBufferStream) {
            throw new IllegalStateException();
        }
        if (null == this.fastPrintWriter) {
            this.fastPrintWriter = new FastPrintWriter();
        }
        return this.fastPrintWriter;
    }

    public void resetBuffers() {
        if (this.fastBufferStream != null) {
            this.fastBufferStream.reset();
        }
        if (this.fastPrintWriter != null) {
            this.fastPrintWriter.reset();
        }
    }

    public void reset() {
        this.getResponse().reset();
        this.resetBuffers();
    }

    public void resetBuffer() {
        if (!this.isCommitted()) {
            this.getResponse().resetBuffer();
        }
        this.resetBuffers();
    }

    public void flushBuffer() throws IOException {
        this.getResponse().flushBuffer();
    }

    public void writeBufferedData() throws IOException {
        if (this.fastBufferStream != null) {
            OutputStream outputStream = this.getResponse().getPortletOutputStream();
            this.fastBufferStream.writeTo(outputStream);
            outputStream.flush();
        } else if (this.fastPrintWriter != null) {
            PrintWriter writer = this.getResponse().getWriter();
            this.fastPrintWriter.writeTo(writer);
            writer.flush();
        }
    }

    public String toString() {
        if (this.fastBufferStream != null) {
            return "Stream content: " + this.fastBufferStream.toString();
        }
        if (this.fastPrintWriter != null) {
            return "Writer content: " + this.fastPrintWriter.toString();
        }
        return super.toString() + ", no data written";
    }

    public boolean isUseWriter() {
        return this.fastBufferStream == null;
    }

    public PortletURL createActionURL() {
        return this.getResponse().createActionURL();
    }

    public PortletURL createRenderURL() {
        return this.getResponse().createRenderURL();
    }

    public ResourceURL createResourceURL() {
        return this.getResponse().createResourceURL();
    }

    public int getBufferSize() {
        return this.getResponse().getBufferSize();
    }

    public CacheControl getCacheControl() {
        return this.getResponse().getCacheControl();
    }

    public String getCharacterEncoding() {
        return this.getResponse().getCharacterEncoding();
    }

    public String getContentType() {
        return this.getResponse().getCharacterEncoding();
    }

    public Locale getLocale() {
        return this.getResponse().getLocale();
    }

    public boolean isCommitted() {
        return this.getResponse().isCommitted();
    }

    public void setBufferSize(int size) {
        this.getResponse().setBufferSize(size);
    }

    public void setContentType(String type) {
        this.getResponse().setContentType(type);
    }

    public void setHeader(String name, String value) {
        this.setProperty(name, value);
    }

    public boolean isChars() {
        return null != this.fastPrintWriter;
    }

    public char[] getChars() {
        if (this.isChars()) {
            this.fastPrintWriter.flush();
            return this.fastPrintWriter.toCharArray();
        }
        return null;
    }

    public boolean isBytes() {
        return null != this.fastBufferStream;
    }

    public byte[] getBytes() {
        if (this.isBytes()) {
            return this.fastBufferStream.toByteArray();
        }
        return null;
    }

    public void flushContentToWrappedResponse() throws IOException {
        this.hasWriteBehindMarkup = true;
        this.flushMarkupToWrappedResponse();
    }

    public void flushToWrappedResponse() throws IOException {
        this.hasWriteBehindMarkup = true;
        this.flushMarkupToWrappedResponse();
    }

    public boolean hasFacesWriteBehindMarkup() {
        return this.hasWriteBehindMarkup;
    }
}

