/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portletbridge.config;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.portletbridge.bridge.factory.BridgeConfigFactory;
import org.jboss.portletbridge.bridge.factory.BridgeContextFactory;
import org.jboss.portletbridge.bridge.factory.BridgeControllerFactory;
import org.jboss.portletbridge.bridge.factory.BridgeFactory;
import org.jboss.portletbridge.bridge.factory.BridgeFactoryFinder;
import org.jboss.portletbridge.bridge.factory.BridgeLoggerFactory;
import org.jboss.portletbridge.bridge.factory.BridgeRequestScopeFactory;
import org.jboss.portletbridge.bridge.factory.BridgeRequestScopeManagerFactory;
import org.jboss.portletbridge.config.ParsingException;
import org.jboss.portletbridge.config.StateHandler;
import org.jboss.portletbridge.config.StringContentHandler;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class FacesConfigHandler
extends DefaultHandler {
    private static final String JEE_NS = "http://java.sun.com/xml/ns/javaee";
    private static final String APPLICATION_ELEMENT = "application";
    private static final String APP_EXTENSION_ELEMENT = "application-extension";
    private static final String FACTORY_ELEMENT = "factory";
    private static final String FACTORY_EXTENSION_ELEMENT = "factory-extension";
    private static final String EXCLUDED_ATTRIBUTES_ELEMENT = "excluded-attributes";
    private static final String EXCLUDED_ATTRIBUTE_ELEMENT = "excluded-attribute";
    private static final String PUBLIC_PARAMETER_MAPPINGS = "public-parameter-mappings";
    private static final String PUBLIC_PARAMETER_MAPPING = "public-parameter-mapping";
    private static final String WRITE_BEHIND_RESPONSE_WRAPPERS = "write-behind-response-wrappers";
    private static final String RENDER_RESPONSE_WRAPPER_CLASS = "render-response-wrapper-class";
    private static final String RESOURCE_RESPONSE_WRAPPER_CLASS = "resource-response-wrapper-class";
    private static final String BRIDGE_CONFIG_FACTORY = "bridge-config-factory";
    private static final String BRIDGE_CONTEXT_FACTORY = "bridge-context-factory";
    private static final String BRIDGE_CONTROLLER_FACTORY = "bridge-controller-factory";
    private static final String BRIDGE_LOGGER_FACTORY = "bridge-logger-factory";
    private static final String BRIDGE_REQUEST_SCOPE_MANAGER_FACTORY = "bridge-request-scope-manager-factory";
    private static final String BRIDGE_REQUEST_SCOPE_FACTORY = "bridge-request-scope-factory";
    private static final String PARAMETER_ELEMENT = "parameter";
    private static final String MODEL_EL_ELEMENT = "model-el";
    private final List<String> excludedAttributes;
    private final Map<String, String> parameterMapping;
    private String renderResponseWrapperClass;
    private String resourceResponseWrapperClass;
    private XMLReader reader;

    public FacesConfigHandler(XMLReader reader) {
        this.reader = reader;
        this.excludedAttributes = new ArrayList<String>();
        this.parameterMapping = new HashMap<String, String>();
    }

    public List<String> getExcludedAttributes() {
        return this.excludedAttributes;
    }

    public Map<String, String> getParameterMapping() {
        return this.parameterMapping;
    }

    public String getRenderResponseWrapperClass() {
        return this.renderResponseWrapperClass;
    }

    public String getResourceResponseWrapperClass() {
        return this.resourceResponseWrapperClass;
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        if (APPLICATION_ELEMENT.equals(localName) && JEE_NS.equals(uri)) {
            this.reader.setContentHandler(new ApplicationHandler());
        } else if (FACTORY_ELEMENT.equals(localName) && JEE_NS.equals(uri)) {
            this.reader.setContentHandler(new FactoryHandler());
        }
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        return new InputSource(new StringReader(""));
    }

    private class BridgeFactoryHandler
    extends StringContentHandler {
        private Class<? extends BridgeFactory<?>> bridgeType;

        public BridgeFactoryHandler(ContentHandler parent, Class<? extends BridgeFactory<?>> type) {
            super(FacesConfigHandler.this.reader, parent, new StringBuilder());
            this.bridgeType = type;
        }

        @Override
        protected void endLastElement() {
            BridgeFactoryFinder.addFactoryDefinition(this.bridgeType, (String)this.getResult().toString().trim());
        }
    }

    private class WriteBehindResponseWrappersHandler
    extends StateHandler {
        private StringBuilder renderResponseWrapperClass;
        private StringBuilder resourceResponseWrapperClass;

        public WriteBehindResponseWrappersHandler(ContentHandler parent) {
            super(FacesConfigHandler.this.reader, parent);
            this.renderResponseWrapperClass = new StringBuilder();
            this.resourceResponseWrapperClass = new StringBuilder();
        }

        @Override
        protected ContentHandler getNextHandler(String uri, String localName, Attributes attributes) throws SAXException {
            StringContentHandler nextHandler = null;
            if (FacesConfigHandler.RENDER_RESPONSE_WRAPPER_CLASS.equals(localName)) {
                nextHandler = new StringContentHandler(this.getReader(), this, this.renderResponseWrapperClass);
            } else if (FacesConfigHandler.RESOURCE_RESPONSE_WRAPPER_CLASS.equals(localName)) {
                nextHandler = new StringContentHandler(this.getReader(), this, this.resourceResponseWrapperClass);
            } else {
                throw new ParsingException("Unexpected element: " + localName + " within " + FacesConfigHandler.WRITE_BEHIND_RESPONSE_WRAPPERS + " element");
            }
            return nextHandler;
        }

        @Override
        protected void endLastElement() throws SAXException {
            if (this.renderResponseWrapperClass.length() > 0) {
                FacesConfigHandler.this.renderResponseWrapperClass = this.renderResponseWrapperClass.toString();
            }
            if (this.resourceResponseWrapperClass.length() > 0) {
                FacesConfigHandler.this.resourceResponseWrapperClass = this.resourceResponseWrapperClass.toString();
            }
        }
    }

    private class ParameterMappingHandler
    extends StateHandler {
        private StringBuilder parameterName;
        private StringBuilder modelEl;

        public ParameterMappingHandler(ContentHandler parent) {
            super(FacesConfigHandler.this.reader, parent);
            this.parameterName = new StringBuilder();
            this.modelEl = new StringBuilder();
        }

        @Override
        protected ContentHandler getNextHandler(String uri, String localName, Attributes attributes) throws SAXException {
            StringContentHandler nextHandler = null;
            if (FacesConfigHandler.PARAMETER_ELEMENT.equals(localName)) {
                nextHandler = new StringContentHandler(this.getReader(), this, this.parameterName);
            } else if (FacesConfigHandler.MODEL_EL_ELEMENT.equals(localName)) {
                nextHandler = new StringContentHandler(this.getReader(), this, this.modelEl);
            } else {
                throw new ParsingException("Unexpected element: " + localName + " within " + FacesConfigHandler.PUBLIC_PARAMETER_MAPPING + " element");
            }
            return nextHandler;
        }

        @Override
        protected void endLastElement() throws SAXException {
            if (this.parameterName.length() <= 0 || this.modelEl.length() <= 0) {
                throw new ParsingException("public-parameter-mapping did not contain both parameter and model-el");
            }
            FacesConfigHandler.this.parameterMapping.put(this.parameterName.toString(), this.modelEl.toString());
        }
    }

    private class ParameterMappingsHandler
    extends StateHandler {
        public ParameterMappingsHandler(ContentHandler parent) {
            super(FacesConfigHandler.this.reader, parent);
        }

        @Override
        protected ContentHandler getNextHandler(String uri, String localName, Attributes attributes) throws ParsingException {
            if (FacesConfigHandler.PUBLIC_PARAMETER_MAPPING.equals(localName)) {
                return new ParameterMappingHandler((ContentHandler)this);
            }
            throw new ParsingException("Unexpected element: " + localName + " within " + FacesConfigHandler.PUBLIC_PARAMETER_MAPPINGS + " element");
        }
    }

    private class ExcludedAttributeHandler
    extends StringContentHandler {
        public ExcludedAttributeHandler(ContentHandler parent) {
            super(FacesConfigHandler.this.reader, parent, new StringBuilder());
        }

        @Override
        protected void endLastElement() {
            FacesConfigHandler.this.excludedAttributes.add(this.getResult().toString());
        }
    }

    private class ExcludedAttributesHandler
    extends StateHandler {
        public ExcludedAttributesHandler(ContentHandler parent) {
            super(FacesConfigHandler.this.reader, parent);
        }

        @Override
        protected ContentHandler getNextHandler(String uri, String localName, Attributes attributes) {
            if (FacesConfigHandler.EXCLUDED_ATTRIBUTE_ELEMENT.equals(localName)) {
                return new ExcludedAttributeHandler((ContentHandler)this);
            }
            return null;
        }
    }

    private class FactoryExtensionHandler
    extends StateHandler {
        public FactoryExtensionHandler(ContentHandler parent) {
            super(FacesConfigHandler.this.reader, parent);
        }

        @Override
        protected ContentHandler getNextHandler(String uri, String localName, Attributes attributes) throws ParsingException {
            if (FacesConfigHandler.BRIDGE_CONFIG_FACTORY.equals(localName)) {
                return new BridgeFactoryHandler((ContentHandler)this, BridgeConfigFactory.class);
            }
            if (FacesConfigHandler.BRIDGE_CONTEXT_FACTORY.equals(localName)) {
                return new BridgeFactoryHandler((ContentHandler)this, BridgeContextFactory.class);
            }
            if (FacesConfigHandler.BRIDGE_CONTROLLER_FACTORY.equals(localName)) {
                return new BridgeFactoryHandler((ContentHandler)this, BridgeControllerFactory.class);
            }
            if (FacesConfigHandler.BRIDGE_LOGGER_FACTORY.equals(localName)) {
                return new BridgeFactoryHandler((ContentHandler)this, BridgeLoggerFactory.class);
            }
            if (FacesConfigHandler.BRIDGE_REQUEST_SCOPE_FACTORY.equals(localName)) {
                return new BridgeFactoryHandler((ContentHandler)this, BridgeRequestScopeFactory.class);
            }
            if (FacesConfigHandler.BRIDGE_REQUEST_SCOPE_MANAGER_FACTORY.equals(localName)) {
                return new BridgeFactoryHandler((ContentHandler)this, BridgeRequestScopeManagerFactory.class);
            }
            throw new ParsingException("Unexpected element: " + localName + " within " + FacesConfigHandler.FACTORY_EXTENSION_ELEMENT + " element");
        }
    }

    private class FactoryHandler
    extends StateHandler {
        public FactoryHandler() {
            super(FacesConfigHandler.this.reader, FacesConfigHandler.this);
        }

        @Override
        protected ContentHandler getNextHandler(String uri, String localName, Attributes attributes) {
            if (FacesConfigHandler.FACTORY_EXTENSION_ELEMENT.equals(localName) && FacesConfigHandler.JEE_NS.equals(uri)) {
                return new FactoryExtensionHandler((ContentHandler)this);
            }
            return null;
        }
    }

    private class ApplicationExtensionHandler
    extends StateHandler {
        public ApplicationExtensionHandler(ContentHandler parent) {
            super(FacesConfigHandler.this.reader, parent);
        }

        @Override
        protected ContentHandler getNextHandler(String uri, String localName, Attributes attributes) {
            if (FacesConfigHandler.EXCLUDED_ATTRIBUTES_ELEMENT.equals(localName)) {
                return new ExcludedAttributesHandler((ContentHandler)this);
            }
            if (FacesConfigHandler.PUBLIC_PARAMETER_MAPPINGS.equals(localName)) {
                return new ParameterMappingsHandler((ContentHandler)this);
            }
            if (FacesConfigHandler.WRITE_BEHIND_RESPONSE_WRAPPERS.equals(localName)) {
                return new WriteBehindResponseWrappersHandler((ContentHandler)this);
            }
            return null;
        }
    }

    private class ApplicationHandler
    extends StateHandler {
        public ApplicationHandler() {
            super(FacesConfigHandler.this.reader, FacesConfigHandler.this);
        }

        @Override
        protected ContentHandler getNextHandler(String uri, String localName, Attributes attributes) {
            if (FacesConfigHandler.APP_EXTENSION_ELEMENT.equals(localName) && FacesConfigHandler.JEE_NS.equals(uri)) {
                return new ApplicationExtensionHandler((ContentHandler)this);
            }
            return null;
        }
    }
}

