/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portletbridge.config;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.faces.FacesException;
import javax.portlet.PortletContext;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jboss.portletbridge.config.ServletBean;
import org.jboss.portletbridge.config.StateHandler;
import org.jboss.portletbridge.config.StringContentHandler;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.EntityResolver2;
import org.xml.sax.helpers.DefaultHandler;

public final class WebXmlProcessor {
    private static final String WEB_XML_PATH = "/WEB-INF/web.xml";
    private static SAXParserFactory saxFactory = SAXParserFactory.newInstance();
    static AtomicBoolean scan = new AtomicBoolean(true);
    private static boolean scanned = false;
    private static List<ServletBean> servlets;
    private static Map<String, ArrayList<String>> urlMappings;
    private static Map<String, String> errorPages;
    static ServletBean facesServlet;
    static Map<Class<? extends Throwable>, String> errorViews;
    public static final EntityResolver2 NULL_RESOLVER;

    public WebXmlProcessor(PortletContext portletContext) {
        if (null != portletContext) {
            if (scan.compareAndSet(true, false)) {
                InputStream inputStream = portletContext.getResourceAsStream(WEB_XML_PATH);
                if (null != inputStream) {
                    this.parse(inputStream);
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        portletContext.log("Portlet Bridge error parsing web.xml", (Throwable)e);
                    }
                }
                scanned = true;
            } else {
                while (!scanned) {
                    try {
                        Thread.sleep(300L);
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                }
            }
        }
    }

    public Map<String, String> getErrorPages() {
        return errorPages;
    }

    public ServletBean getFacesServlet() {
        return facesServlet;
    }

    public Map<Class<? extends Throwable>, String> getErrorViews() {
        return errorViews;
    }

    public void parse(InputStream webXml) {
        try {
            SAXParser parser = saxFactory.newSAXParser();
            XMLReader reader = parser.getXMLReader();
            WebXmlHandler webXmlHandler = new WebXmlHandler(reader);
            reader.setContentHandler(webXmlHandler);
            reader.setEntityResolver(NULL_RESOLVER);
            reader.setErrorHandler(webXmlHandler);
            reader.setDTDHandler(webXmlHandler);
            reader.parse(new InputSource(webXml));
            this.createErrorViews();
        }
        catch (Exception e) {
            throw new FacesException("XML parsing error", (Throwable)e);
        }
    }

    protected void createErrorViews() {
        errorViews = new LinkedHashMap<Class<? extends Throwable>, String>();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (null == classLoader) {
            classLoader = this.getClass().getClassLoader();
        }
        for (Map.Entry<String, String> entry : errorPages.entrySet()) {
            try {
                Class<Throwable> clazz = classLoader.loadClass(entry.getKey()).asSubclass(Throwable.class);
                String viewId = this.getViewIdFromLocation(entry.getValue());
                if (null == viewId) continue;
                errorViews.put(clazz, viewId);
            }
            catch (ClassNotFoundException e) {}
        }
    }

    protected String getViewIdFromLocation(String location) {
        String viewId = null;
        for (String mapping : facesServlet.getMappings()) {
            String prefix;
            if (mapping.startsWith("*")) {
                String suffix = mapping.substring(1);
                if (!location.endsWith(suffix)) continue;
                viewId = location.substring(0, location.length() - suffix.length());
                break;
            }
            if (!mapping.endsWith("*") || !location.startsWith(prefix = mapping.substring(0, mapping.length() - 1))) continue;
            int index = prefix.length();
            if (prefix.endsWith("/")) {
                --index;
            }
            viewId = location.substring(index);
        }
        return viewId;
    }

    static void setErrorPages(Map<String, String> pages) {
        errorPages = pages;
    }

    static void setUrlMappings(Map<String, ArrayList<String>> mappings) {
        urlMappings = mappings;
    }

    static void setServlets(List<ServletBean> srvlts) {
        servlets = srvlts;
    }

    static {
        saxFactory.setValidating(false);
        saxFactory.setNamespaceAware(true);
        servlets = new ArrayList<ServletBean>();
        urlMappings = new HashMap<String, ArrayList<String>>();
        errorPages = new LinkedHashMap<String, String>();
        errorViews = new LinkedHashMap<Class<? extends Throwable>, String>();
        NULL_RESOLVER = new EntityResolver2(){

            @Override
            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                return new InputSource(new StringReader(""));
            }

            @Override
            public InputSource getExternalSubset(String name, String baseURI) throws SAXException, IOException {
                return new InputSource(new StringReader(""));
            }

            @Override
            public InputSource resolveEntity(String name, String publicId, String baseURI, String systemId) throws SAXException, IOException {
                return new InputSource(new StringReader(""));
            }
        };
    }

    class WebXmlHandler
    extends DefaultHandler {
        private static final String SERVLET_ELEMENT = "servlet";
        private static final String SERVLET_NAME_ELEMENT = "servlet-name";
        private static final String SERVLET_MAPPING_ELEMENT = "servlet-mapping";
        private static final String SERVLET_CLASS_ELEMENT = "servlet-class";
        private static final String ERROR_PAGE_ELEMENT = "error-page";
        private static final String LOCATION_ELEMENT = "location";
        private static final String EXCEPTION_CLASS_ELEMENT = "exception-type";
        private static final String URL_PATTERN_ELEMENT = "url-pattern";
        private static final String FACES_SERVLET_CLASS = "javax.faces.webapp.FacesServlet";
        private XMLReader xmlReader;

        public WebXmlHandler(XMLReader xmlReader) {
            this.xmlReader = xmlReader;
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            if (SERVLET_ELEMENT.equals(localName)) {
                this.xmlReader.setContentHandler(new ServletHandler());
            } else if (SERVLET_MAPPING_ELEMENT.equals(localName)) {
                this.xmlReader.setContentHandler(new MappingHandler());
            } else if (ERROR_PAGE_ELEMENT.equals(localName)) {
                this.xmlReader.setContentHandler(new ErrorPageHandler());
            }
        }

        @Override
        public void endDocument() throws SAXException {
            for (ServletBean servlet : servlets) {
                if (!FACES_SERVLET_CLASS.equals(servlet.getClassName())) continue;
                facesServlet = servlet;
                List servletMappings = (List)urlMappings.get(servlet.getName());
                if (null == servletMappings) continue;
                facesServlet.getMappings().addAll(servletMappings);
            }
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
            return new InputSource(new StringReader(""));
        }

        final class ErrorPageHandler
        extends StateHandler {
            private StringBuilder exceptionType;
            private StringBuilder location;

            public ErrorPageHandler() {
                super(WebXmlHandler.this.xmlReader, WebXmlHandler.this);
                this.exceptionType = new StringBuilder();
                this.location = new StringBuilder();
            }

            @Override
            protected ContentHandler getNextHandler(String uri, String localName, Attributes attributes) {
                StringContentHandler nextHandler = null;
                if (WebXmlHandler.EXCEPTION_CLASS_ELEMENT.equals(localName)) {
                    nextHandler = new StringContentHandler(this.getReader(), this, this.exceptionType);
                } else if (WebXmlHandler.LOCATION_ELEMENT.equals(localName)) {
                    nextHandler = new StringContentHandler(this.getReader(), this, this.location);
                }
                return nextHandler;
            }

            @Override
            protected void endLastElement() {
                errorPages.put(this.exceptionType.toString().trim(), this.location.toString().trim());
            }
        }

        final class MappingHandler
        extends StateHandler {
            private StringBuilder servletName;
            private StringBuilder urlPattern;

            public MappingHandler() {
                super(WebXmlHandler.this.xmlReader, WebXmlHandler.this);
                this.servletName = new StringBuilder();
                this.urlPattern = new StringBuilder();
            }

            @Override
            protected ContentHandler getNextHandler(String uri, String localName, Attributes attributes) {
                StringContentHandler nextHandler = null;
                if (WebXmlHandler.SERVLET_NAME_ELEMENT.equals(localName)) {
                    nextHandler = new StringContentHandler(this.getReader(), this, this.servletName);
                } else if (WebXmlHandler.URL_PATTERN_ELEMENT.equals(localName)) {
                    nextHandler = new StringContentHandler(this.getReader(), this, this.urlPattern);
                }
                return nextHandler;
            }

            @Override
            protected void endLastElement() {
                if (urlMappings.containsKey(this.servletName.toString().trim())) {
                    ((ArrayList)urlMappings.get(this.servletName.toString().trim())).add(this.urlPattern.toString().trim());
                } else {
                    urlMappings.put(this.servletName.toString().trim(), new ArrayList());
                    ((ArrayList)urlMappings.get(this.servletName.toString().trim())).add(this.urlPattern.toString().trim());
                }
            }
        }

        final class ServletHandler
        extends StateHandler {
            private StringBuilder servletName;
            private StringBuilder servletClass;

            public ServletHandler() {
                super(WebXmlHandler.this.xmlReader, WebXmlHandler.this);
                this.servletName = new StringBuilder();
                this.servletClass = new StringBuilder();
            }

            @Override
            protected ContentHandler getNextHandler(String uri, String localName, Attributes attributes) {
                StringContentHandler nextHandler = null;
                if (WebXmlHandler.SERVLET_NAME_ELEMENT.equals(localName)) {
                    nextHandler = new StringContentHandler(this.getReader(), this, this.servletName);
                } else if (WebXmlHandler.SERVLET_CLASS_ELEMENT.equals(localName)) {
                    nextHandler = new StringContentHandler(this.getReader(), this, this.servletClass);
                }
                return nextHandler;
            }

            @Override
            protected void endLastElement() {
                servlets.add(new ServletBean(this.servletName.toString().trim(), this.servletClass.toString().trim()));
            }
        }
    }
}

