/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portletbridge.el;

import java.beans.FeatureDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.el.PropertyNotFoundException;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.faces.Bridge;
import javax.portlet.faces.BridgeUtil;
import javax.portlet.faces.preference.Preference;
import org.jboss.portletbridge.context.map.PortletApplicationScopeSessionMap;
import org.jboss.portletbridge.el.ELContextImpl;
import org.jboss.portletbridge.preference.PreferenceImpl;

public class PortletELResolver
extends ELResolver {
    public static final String PORTLET_CONFIG = "portletConfig";
    public static final String ACTION_REQUEST = "actionRequest";
    public static final String ACTION_RESPONSE = "actionResponse";
    public static final String EVENT_REQUEST = "eventRequest";
    public static final String EVENT_RESPONSE = "eventResponse";
    public static final String RENDER_REQUEST = "renderRequest";
    public static final String RENDER_RESPONSE = "renderResponse";
    public static final String RESOURCE_REQUEST = "resourceRequest";
    public static final String RESOURCE_RESPONSE = "resourceResponse";
    public static final String PORTLET_SESSION = "portletSession";
    public static final String PORTLET_SESSION_SCOPE = "portletSessionScope";
    public static final String HTTP_SESSION_SCOPE = "httpSessionScope";
    public static final String PORTLET_PREFERENCES = "portletPreferences";
    public static final String PORTLET_PREFERENCES_VALUES = "portletPreferencesValues";
    public static final String MUTABLE_PORTLET_PREFERENCES_VALUES = "mutablePortletPreferencesValues";
    public static final String SESSION_APPLICATION_SCOPE = "sessionApplicationScope";
    public static final String SESSION_PORTLET_SCOPE = "sessionPortletScope";
    public static final String PORTLET_PREFERENCE_VALUE = "portletPreferenceValue";
    public static final String PORTLET_PREFERENCE_VALUES = "portletPreferenceValues";
    public static final String AJAX_CONTEXT = "ajaxContext";
    private Map<String, Object> appScopeSessionMap = null;

    public Object getValue(ELContext context, Object base, Object property) throws ELException {
        if (!BridgeUtil.isPortletRequest() || null != base) {
            return null;
        }
        if (null == property) {
            throw new PropertyNotFoundException("Null property");
        }
        if (null == context) {
            throw new IllegalArgumentException("PortletELResolver.getValue was passed a null ELContext");
        }
        ELContextImpl portletELContext = (ELContextImpl)((Object)context.getContext(ELContextImpl.class));
        if (null == portletELContext) {
            return null;
        }
        if (portletELContext.isFacesResolved()) {
            return this.getValueWithFacesResolution(context, portletELContext, base, property);
        }
        return this.getValueWithJSPResolution(context, portletELContext, base, property);
    }

    private Object getValueWithJSPResolution(ELContext context, ELContextImpl portletELContext, Object base, Object property) {
        if (property instanceof String) {
            FacesContext facesContext = (FacesContext)context.getContext(FacesContext.class);
            ExternalContext externalContext = facesContext.getExternalContext();
            try {
                if (HTTP_SESSION_SCOPE.equals(property)) {
                    context.setPropertyResolved(true);
                    return this.getHttpSessionMap(externalContext, portletELContext);
                }
                if (MUTABLE_PORTLET_PREFERENCES_VALUES.equals(property)) {
                    context.setPropertyResolved(true);
                    return this.getMutablePortletPreferencesValues(externalContext, portletELContext);
                }
                return null;
            }
            catch (IllegalArgumentException e) {
                if (externalContext.getSessionMap().containsKey(property)) {
                    context.setPropertyResolved(true);
                    return externalContext.getSessionMap().get(property);
                }
                return null;
            }
        }
        return null;
    }

    private Object getValueWithFacesResolution(ELContext context, ELContextImpl portletELContext, Object base, Object property) {
        FacesContext facesContext = (FacesContext)context.getContext(FacesContext.class);
        ExternalContext externalContext = facesContext.getExternalContext();
        if (PORTLET_CONFIG.equals(property)) {
            PortletConfig config = portletELContext.getPortletConfig();
            if (null != config) {
                context.setPropertyResolved(true);
                return config;
            }
            throw new ELException("EL Resolve failed: can't resolve portletConfig because its not set on this Faces EL Resolver.");
        }
        if (ACTION_REQUEST.equals(property) && BridgeUtil.getPortletRequestPhase() == Bridge.PortletPhase.ACTION_PHASE) {
            context.setPropertyResolved(true);
            return externalContext.getRequest();
        }
        if (ACTION_RESPONSE.equals(property) && BridgeUtil.getPortletRequestPhase() == Bridge.PortletPhase.ACTION_PHASE) {
            context.setPropertyResolved(true);
            return externalContext.getResponse();
        }
        if (RENDER_REQUEST.equals(property) && BridgeUtil.getPortletRequestPhase() == Bridge.PortletPhase.RENDER_PHASE) {
            context.setPropertyResolved(true);
            return externalContext.getRequest();
        }
        if (RENDER_RESPONSE.equals(property) && BridgeUtil.getPortletRequestPhase() == Bridge.PortletPhase.RENDER_PHASE) {
            context.setPropertyResolved(true);
            return externalContext.getResponse();
        }
        if (EVENT_REQUEST.equals(property) && BridgeUtil.getPortletRequestPhase() == Bridge.PortletPhase.EVENT_PHASE) {
            context.setPropertyResolved(true);
            return externalContext.getRequest();
        }
        if (EVENT_RESPONSE.equals(property) && BridgeUtil.getPortletRequestPhase() == Bridge.PortletPhase.EVENT_PHASE) {
            context.setPropertyResolved(true);
            return externalContext.getResponse();
        }
        if (RESOURCE_REQUEST.equals(property) && BridgeUtil.getPortletRequestPhase() == Bridge.PortletPhase.RESOURCE_PHASE) {
            context.setPropertyResolved(true);
            return externalContext.getRequest();
        }
        if (RESOURCE_RESPONSE.equals(property) && BridgeUtil.getPortletRequestPhase() == Bridge.PortletPhase.RESOURCE_PHASE) {
            context.setPropertyResolved(true);
            return externalContext.getResponse();
        }
        if (SESSION_APPLICATION_SCOPE.equals(property) || HTTP_SESSION_SCOPE.equals(property)) {
            context.setPropertyResolved(true);
            if (null == this.appScopeSessionMap) {
                Object request = externalContext.getRequest();
                if (BridgeUtil.isPortletRequest()) {
                    this.appScopeSessionMap = new PortletApplicationScopeSessionMap((PortletRequest)request);
                }
            }
            return this.appScopeSessionMap;
        }
        if (SESSION_PORTLET_SCOPE.equals(property) || PORTLET_SESSION_SCOPE.equals(property)) {
            context.setPropertyResolved(true);
            return externalContext.getSessionMap();
        }
        if (PORTLET_SESSION.equals(property)) {
            context.setPropertyResolved(true);
            return externalContext.getSession(false);
        }
        if (PORTLET_PREFERENCE_VALUE.equals(property)) {
            context.setPropertyResolved(true);
            return this.getPreferencesValueMap(facesContext);
        }
        if (PORTLET_PREFERENCES.equals(property)) {
            context.setPropertyResolved(true);
            return ((PortletRequest)externalContext.getRequest()).getPreferences();
        }
        if (MUTABLE_PORTLET_PREFERENCES_VALUES.equals(property)) {
            context.setPropertyResolved(true);
            return this.getPreferenceMap(((PortletRequest)externalContext.getRequest()).getPreferences());
        }
        if (PORTLET_PREFERENCES_VALUES.equals(property)) {
            context.setPropertyResolved(true);
            return ((PortletRequest)externalContext.getRequest()).getPreferences().getMap();
        }
        return null;
    }

    public void setValue(ELContext context, Object base, Object property, Object val) throws ELException {
        if (null != base) {
            return;
        }
        if (null == property) {
            throw new PropertyNotFoundException("Null property");
        }
    }

    public boolean isReadOnly(ELContext context, Object base, Object property) throws ELException {
        if (null != base) {
            return false;
        }
        if (null == property) {
            throw new PropertyNotFoundException("Null property");
        }
        return false;
    }

    public Class<?> getType(ELContext context, Object base, Object property) throws ELException {
        if (null != base) {
            return null;
        }
        if (null == property) {
            throw new PropertyNotFoundException("Null property");
        }
        return null;
    }

    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        if (null != base) {
            return null;
        }
        ArrayList<FeatureDescriptor> list = new ArrayList<FeatureDescriptor>(20);
        list.add(this.getFeatureDescriptor(ACTION_REQUEST, ACTION_REQUEST, ACTION_REQUEST, false, false, true, ActionRequest.class, Boolean.TRUE));
        list.add(this.getFeatureDescriptor(ACTION_RESPONSE, ACTION_RESPONSE, ACTION_RESPONSE, false, false, true, ActionResponse.class, Boolean.TRUE));
        list.add(this.getFeatureDescriptor(EVENT_REQUEST, EVENT_REQUEST, EVENT_REQUEST, false, false, true, EventRequest.class, Boolean.TRUE));
        list.add(this.getFeatureDescriptor(EVENT_RESPONSE, EVENT_RESPONSE, EVENT_RESPONSE, false, false, true, EventResponse.class, Boolean.TRUE));
        list.add(this.getFeatureDescriptor(HTTP_SESSION_SCOPE, HTTP_SESSION_SCOPE, HTTP_SESSION_SCOPE, false, false, true, Map.class, Boolean.TRUE));
        list.add(this.getFeatureDescriptor("mutablePortletPreferences", "mutablePortletPreferences", "mutablePortletPreferences", false, false, true, Map.class, Boolean.TRUE));
        list.add(this.getFeatureDescriptor(PORTLET_CONFIG, PORTLET_CONFIG, PORTLET_CONFIG, false, false, true, PortletConfig.class, Boolean.TRUE));
        list.add(this.getFeatureDescriptor(PORTLET_PREFERENCES, PORTLET_PREFERENCES, PORTLET_PREFERENCES, false, false, true, PortletPreferences.class, Boolean.TRUE));
        list.add(this.getFeatureDescriptor(PORTLET_PREFERENCES_VALUES, PORTLET_PREFERENCES_VALUES, PORTLET_PREFERENCES_VALUES, false, false, true, Map.class, Boolean.TRUE));
        list.add(this.getFeatureDescriptor(PORTLET_SESSION, PORTLET_SESSION, PORTLET_SESSION, false, false, true, PortletSession.class, Boolean.TRUE));
        list.add(this.getFeatureDescriptor(PORTLET_SESSION_SCOPE, PORTLET_SESSION_SCOPE, PORTLET_SESSION_SCOPE, false, false, true, Map.class, Boolean.TRUE));
        list.add(this.getFeatureDescriptor(RENDER_REQUEST, RENDER_REQUEST, RENDER_REQUEST, false, false, true, RenderRequest.class, Boolean.TRUE));
        list.add(this.getFeatureDescriptor(RENDER_RESPONSE, RENDER_RESPONSE, RENDER_RESPONSE, false, false, true, RenderResponse.class, Boolean.TRUE));
        list.add(this.getFeatureDescriptor(RESOURCE_REQUEST, RESOURCE_REQUEST, RESOURCE_REQUEST, false, false, true, ResourceRequest.class, Boolean.TRUE));
        list.add(this.getFeatureDescriptor(RESOURCE_RESPONSE, RESOURCE_RESPONSE, RESOURCE_RESPONSE, false, false, true, ResourceResponse.class, Boolean.TRUE));
        list.add(this.getFeatureDescriptor(SESSION_APPLICATION_SCOPE, SESSION_APPLICATION_SCOPE, SESSION_APPLICATION_SCOPE, false, false, true, Map.class, Boolean.TRUE));
        list.add(this.getFeatureDescriptor(SESSION_PORTLET_SCOPE, SESSION_PORTLET_SCOPE, SESSION_PORTLET_SCOPE, false, false, true, Map.class, Boolean.TRUE));
        list.add(this.getFeatureDescriptor(PORTLET_PREFERENCE_VALUE, PORTLET_PREFERENCE_VALUE, PORTLET_PREFERENCE_VALUE, false, false, true, Map.class, Boolean.TRUE));
        list.add(this.getFeatureDescriptor(PORTLET_PREFERENCE_VALUES, PORTLET_PREFERENCE_VALUES, PORTLET_PREFERENCE_VALUES, false, false, true, Map.class, Boolean.TRUE));
        list.add(this.getFeatureDescriptor(AJAX_CONTEXT, AJAX_CONTEXT, AJAX_CONTEXT, false, false, true, Map.class, Boolean.TRUE));
        return list.iterator();
    }

    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        if (null != base) {
            return null;
        }
        return String.class;
    }

    private FeatureDescriptor getFeatureDescriptor(String name, String displayName, String desc, boolean expert, boolean hidden, boolean preferred, Object type, Boolean designTime) {
        FeatureDescriptor fd = new FeatureDescriptor();
        fd.setName(name);
        fd.setDisplayName(displayName);
        fd.setShortDescription(desc);
        fd.setExpert(expert);
        fd.setHidden(hidden);
        fd.setPreferred(preferred);
        fd.setValue("type", type);
        fd.setValue("resolvableAtDesignTime", designTime);
        return fd;
    }

    private Map<String, String> getPreferencesValueMap(FacesContext context) {
        HashMap<String, String> m = new HashMap<String, String>();
        Map preferencesValuesMap = ((PortletRequest)context.getExternalContext().getRequest()).getPreferences().getMap();
        for (Map.Entry entry : preferencesValuesMap.entrySet()) {
            String[] preferenceValues = (String[])entry.getValue();
            if (null == preferenceValues || preferenceValues.length <= 0) continue;
            m.put((String)entry.getKey(), preferenceValues[0]);
        }
        return Collections.unmodifiableMap(m);
    }

    private Map<String, Preference> getPreferenceMap(PortletPreferences prefs) {
        Map<String, Preference> m;
        Enumeration e = prefs.getNames();
        if (e.hasMoreElements()) {
            m = new HashMap();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                m.put(name, new PreferenceImpl(prefs, name));
            }
        } else {
            m = Collections.emptyMap();
        }
        return m;
    }

    private Map<String, Object> getHttpSessionMap(ExternalContext externalContext, ELContextImpl portletELContext) {
        PortletApplicationScopeSessionMap sessionMap = portletELContext.getHttpSessionMap();
        if (null == sessionMap) {
            sessionMap = new PortletApplicationScopeSessionMap((PortletRequest)externalContext.getRequest());
            portletELContext.setHttpSessionMap(sessionMap);
        }
        return sessionMap;
    }

    private Map getMutablePortletPreferencesValues(ExternalContext externalContext, ELContextImpl portletELContext) {
        Map<String, Preference> preferencesValuesMap = portletELContext.getMutablePortletPreferencesMap();
        if (null == preferencesValuesMap) {
            preferencesValuesMap = this.getPreferenceMap(((PortletRequest)externalContext.getRequest()).getPreferences());
            portletELContext.setMutablePortletPreferencesMap(preferencesValuesMap);
        }
        return preferencesValuesMap;
    }
}

