/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portletbridge.renderkit.portlet;

import java.io.Writer;
import javax.faces.context.FacesContext;
import javax.faces.context.PartialViewContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitWrapper;
import javax.faces.render.Renderer;
import org.jboss.portletbridge.bridge.context.BridgeContext;
import org.jboss.portletbridge.renderkit.portlet.Jsf22PortletPartialResponseWriter;
import org.jboss.portletbridge.renderkit.portlet.PortletScriptRenderer;
import org.jboss.portletbridge.renderkit.portlet.jsf2_0.Jsf20PortletPartialResponseWriter;

public class PortletRenderKitImpl
extends RenderKitWrapper {
    private RenderKit wrappedRenderKit;
    private Boolean isJsf22Runtime;

    public PortletRenderKitImpl(RenderKit parent) {
        this.wrappedRenderKit = parent;
    }

    public RenderKit getWrapped() {
        return this.wrappedRenderKit;
    }

    public ResponseWriter createResponseWriter(Writer writer, String contentTypeList, String characterEncoding) {
        if (this.isJsf22Runtime == null) {
            this.isJsf22Runtime = BridgeContext.getCurrentInstance().getBridgeConfig().isJsf22Runtime();
        }
        PartialViewContext partialViewContext = FacesContext.getCurrentInstance().getPartialViewContext();
        boolean isPartialRequest = partialViewContext.isPartialRequest();
        ResponseWriter wrappedWriter = this.getWrapped().createResponseWriter(writer, contentTypeList, characterEncoding);
        if (isPartialRequest) {
            if (!this.isJsf22Runtime.booleanValue()) {
                return new Jsf20PortletPartialResponseWriter(wrappedWriter);
            }
            return new Jsf22PortletPartialResponseWriter(wrappedWriter);
        }
        return wrappedWriter;
    }

    public Renderer getRenderer(String family, String rendererType) {
        Renderer renderer = super.getRenderer(family, rendererType);
        if ("javax.faces.Output".equals(family) && ("javax.faces.resource.Script".equals(rendererType) || "javax.faces.resource.Stylesheet".equals(rendererType))) {
            renderer = new PortletScriptRenderer(renderer);
        }
        return renderer;
    }
}

