/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.highlight.renderer;

import com.uwyn.jhighlight.highlighter.ExplicitStateHighlighter;
import com.uwyn.jhighlight.highlighter.JavaHighlighter;
import com.uwyn.jhighlight.renderer.XhtmlRenderer;
import com.uwyn.jhighlight.tools.StringUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;

public class JavaXhtmlRenderer
extends XhtmlRenderer {
    private int lineNo = 0;
    public static final HashMap DEFAULT_CSS = new HashMap(){
        {
            this.put("h1", "font-family: sans-serif; font-size: 16pt; font-weight: bold; color: rgb(0,0,0); background: rgb(210,210,210); border: solid 1px black; padding: 5px; text-align: center;");
            this.put("code", "color: rgb(0,0,0); font-family: monospace; font-size: 12px; white-space: nowrap;");
            this.put(".java_plain", "color: rgb(0,0,0);");
            this.put(".java_keyword", "color: rgb(0,0,0); font-weight: bold;");
            this.put(".java_type", "color: rgb(0,44,221);");
            this.put(".java_operator", "color: rgb(0,124,31);");
            this.put(".java_separator", "color: rgb(0,33,255);");
            this.put(".java_literal", "color: rgb(188,0,0);");
            this.put(".java_comment", "color: rgb(147,147,147); background-color: rgb(247,247,247);");
            this.put(".java_javadoc_comment", "color: rgb(147,147,147); background-color: rgb(247,247,247); font-style: italic;");
            this.put(".java_javadoc_tag", "color: rgb(147,147,147); background-color: rgb(247,247,247); font-style: italic; font-weight: bold;");
        }
    };

    public void highlight(String name, InputStream in, OutputStream out, String encoding, boolean fragment) throws IOException {
        OutputStreamWriter osw;
        InputStreamReader isr;
        ExplicitStateHighlighter highlighter = this.getHighlighter();
        if (null == encoding) {
            isr = new InputStreamReader(in);
            osw = new OutputStreamWriter(out);
        } else {
            isr = new InputStreamReader(in, encoding);
            osw = new OutputStreamWriter(out, encoding);
        }
        BufferedReader r = new BufferedReader(isr);
        BufferedWriter w = new BufferedWriter(osw);
        if (!fragment) {
            w.write(this.getXhtmlHeader(name));
        }
        byte previous_style = 0;
        boolean newline = false;
        StringBuilder buf = new StringBuilder();
        int c = 0;
        while ((c = r.read()) != -1) {
            buf.append((char)c);
        }
        String allLines = buf.toString();
        String[] lines = allLines.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            int length;
            String line = lines[i];
            ++this.lineNo;
            line = StringUtils.convertTabsToSpaces((String)line, (int)4);
            StringReader lineReader = new StringReader(line);
            highlighter.setReader((Reader)lineReader);
            for (int index = 0; index < line.length(); index += length) {
                String css_class;
                byte style = highlighter.getNextToken();
                length = highlighter.getTokenLength();
                String token = line.substring(index, index + length);
                if ((style != previous_style || newline) && (css_class = this.getCssClass(style)) != null) {
                    if (previous_style != 0 && !newline) {
                        w.write("</span>");
                    }
                    if (this.lineNo == 1) {
                        w.write("<!-- <br/> --><span class=\"" + css_class + "\">");
                    } else if (!newline) {
                        w.write("<span class=\"" + css_class + "\">");
                    } else if (newline && this.lineNo != 1) {
                        w.write("<!--  --><br/><span class=\"" + css_class + "\">");
                    }
                    previous_style = style;
                }
                newline = false;
                w.write(StringUtils.replace((String)StringUtils.encodeHtml((String)StringUtils.replace((String)token, (String)"\n", (String)"")), (String)" ", (String)"&nbsp;"));
            }
            if (i != lines.length - 1 || i == lines.length - 1 && allLines.endsWith("\n")) {
                w.write("</span>\n");
            } else {
                w.write("</span>");
            }
            newline = true;
        }
        if (!fragment) {
            w.write(this.getXhtmlFooter());
        }
        w.flush();
        w.close();
    }

    protected Map getDefaultCssStyles() {
        return DEFAULT_CSS;
    }

    protected String getCssClass(int style) {
        switch (style) {
            case 1: {
                return "java_plain";
            }
            case 2: {
                return "java_keyword";
            }
            case 3: {
                return "java_type";
            }
            case 4: {
                return "java_operator";
            }
            case 5: {
                return "java_separator";
            }
            case 6: {
                return "java_literal";
            }
            case 7: {
                return "java_comment";
            }
            case 8: {
                return "java_javadoc_comment";
            }
            case 9: {
                return "java_javadoc_tag";
            }
        }
        return null;
    }

    protected ExplicitStateHighlighter getHighlighter() {
        JavaHighlighter highlighter = new JavaHighlighter();
        JavaHighlighter.ASSERT_IS_KEYWORD = true;
        return highlighter;
    }
}

