/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.loading;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.remoting.Client;
import org.jboss.remoting.loading.ClassBytes;
import org.jboss.remoting.loading.ClassUtil;
import org.jboss.remoting.util.SecurityUtility;

public class ClassByteClassLoader
extends ClassLoader {
    private static final Logger log = Logger.getLogger((Class)ClassByteClassLoader.class);
    private final Map loadedClasses = Collections.synchronizedMap(new HashMap());
    private final Map loadedResources = Collections.synchronizedMap(new HashMap());
    private final ReferenceQueue queue = new ReferenceQueue();
    private Client loaderClient = null;

    public ClassByteClassLoader() {
    }

    public ClassByteClassLoader(ClassLoader parent) {
        super(parent);
    }

    public void setClientInvoker(Client loaderClient) {
        this.loaderClient = loaderClient;
    }

    public void destroy() {
        if (this.loaderClient != null && this.loaderClient.isConnected()) {
            this.loaderClient.disconnect();
        }
    }

    private void clean(MyRef myref) {
        this.loadedClasses.remove(myref.key);
        File f = (File)this.loadedResources.remove(myref.key);
        if (f != null) {
            f.delete();
        }
        myref.clear();
        myref = null;
    }

    private void performMaintenance() {
        int count = 0;
        Reference ref = null;
        while ((ref = this.queue.poll()) != null) {
            ++count;
            MyRef myref = (MyRef)ref;
            this.clean(myref);
        }
        if (count > 0 && log.isTraceEnabled()) {
            log.trace((Object)("ClassByteClassLoader reclaimed " + count + " objects"));
        }
    }

    public String toString() {
        return "ClassByteClassLoader [" + this.loadedClasses + "]";
    }

    protected void finalize() throws Throwable {
        this.performMaintenance();
        Iterator iter = this.loadedResources.values().iterator();
        while (iter.hasNext()) {
            ((File)iter.next()).delete();
        }
        this.loadedResources.clear();
        this.loadedClasses.clear();
        super.finalize();
    }

    public Class loadClass(String className, ClassBytes[] bytes) throws ClassNotFoundException, IOException {
        Class<?> cl;
        this.performMaintenance();
        if (log.isTraceEnabled()) {
            log.trace((Object)("loadClass: " + className + ", bytes: " + bytes));
        }
        if (bytes != null) {
            for (int c = 0; c < bytes.length; ++c) {
                this.addClass(bytes[c]);
            }
        }
        if ((cl = this.lookupCachedClass(className)) != null) {
            return cl;
        }
        cl = this.findLoadedClass(className);
        if (cl != null) {
            return cl;
        }
        cl = Class.forName(className, false, ClassByteClassLoader.getSystemClassLoaderPrivate());
        if (cl != null) {
            return cl;
        }
        cl = Class.forName(className, false, this.getParent());
        if (cl != null) {
            return cl;
        }
        cl = this.loadFromNetwork(className);
        if (cl != null) {
            return cl;
        }
        throw new ClassNotFoundException("Could not load class " + className);
    }

    private void addClassResource(String name, byte[] buf) throws IOException {
        this.performMaintenance();
        OutputStream out = null;
        File file = null;
        try {
            file = ClassByteClassLoader.createTempFile("cbc", ".class", true);
            if (log.isTraceEnabled()) {
                log.trace((Object)("adding resource at: " + name + " to file: " + file));
            }
            out = ClassByteClassLoader.getFileOutputStream(file);
            out.write(buf);
            out.flush();
        }
        catch (IOException ex) {
            file = null;
            throw ex;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception ig) {}
                out = null;
            }
            if (file != null) {
                this.loadedResources.put(name, file);
            }
        }
    }

    public InputStream getResourceAsStream(String name) {
        this.performMaintenance();
        String denormalized = name.replace('/', '.').substring(0, name.length() - 6);
        File file = (File)this.loadedResources.get(denormalized);
        if (log.isTraceEnabled()) {
            log.trace((Object)("getResourceAsStream =>" + denormalized + " = " + file));
        }
        if (file != null && ClassByteClassLoader.fileExists(file)) {
            try {
                FileInputStream is = ClassByteClassLoader.getFileInputStream(file);
                return new BufferedInputStream(is);
            }
            catch (Exception ex) {
                log.debug((Object)"file doesn't exist", (Throwable)ex);
            }
        }
        return super.getResourceAsStream(name);
    }

    public Class addClass(ClassBytes classBytes) throws IOException {
        this.performMaintenance();
        Class<?> cl = null;
        String name = classBytes.getClassName();
        if (!this.loadedClasses.containsKey(name)) {
            String cn;
            byte[] buf = classBytes.getClassBytes();
            boolean array = ClassUtil.isArrayClass(name);
            String string = cn = array ? ClassUtil.getArrayClassPart(name) : name;
            if (log.isTraceEnabled()) {
                log.trace((Object)("  add class: " + name + ", array?" + array + ", using as: " + cn));
            }
            cl = this.defineClass(cn, buf, 0, buf.length);
            this.resolveClass(cl);
            this.addClassResource(cn, buf);
            this.loadedClasses.put(cn, new MyRef(cn, cl));
        }
        return cl;
    }

    private Class lookupCachedClass(String cn) {
        Class cl = null;
        MyRef ref = (MyRef)this.loadedClasses.get(cn);
        if (ref != null && (cl = (Class)ref.get()) == null) {
            this.clean(ref);
        }
        return cl;
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        Class cl;
        String cn;
        this.performMaintenance();
        boolean array = ClassUtil.isArrayClass(name);
        String string = cn = array ? ClassUtil.getArrayClassPart(name) : name;
        if (log.isTraceEnabled()) {
            log.trace((Object)("++ loadClass: " + name + ", array?" + array + ", normalized: [" + cn + "]"));
        }
        if ((cl = this.lookupCachedClass(cn)) == null) {
            cl = this.findLoadedClass(cn);
        }
        if (cl != null) {
            if (array) {
                Object obj = Array.newInstance(cl, 1);
                return obj.getClass();
            }
            return cl;
        }
        cl = this.loadFromNetwork(cn);
        if (cl != null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Loaded " + cn + " can class is " + cl));
            }
            return cl;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("++ findClass: " + name + " not found, throwing ClassNotFoundException"));
        }
        throw new ClassNotFoundException(name);
    }

    private Class loadFromNetwork(String className) {
        Class loadedClass;
        block8: {
            loadedClass = null;
            if (this.loaderClient != null) {
                String marshallerMethodName = "load_class";
                HashMap<String, String> metadata = new HashMap<String, String>();
                metadata.put("classname", className);
                try {
                    if (!this.loaderClient.isConnected()) {
                        this.loaderClient.connect();
                    }
                    log.debug((Object)("attempting to load from network: " + className));
                    Object obj = this.loaderClient.invoke(marshallerMethodName, metadata);
                    log.debug((Object)("loaded from network: " + obj));
                    if (obj != null) {
                        if (obj instanceof ClassBytes) {
                            ClassBytes classBytes = (ClassBytes)obj;
                            String name = classBytes.getClassName();
                            loadedClass = this.addClass(classBytes);
                        } else {
                            log.error((Object)("Can not load remote class bytes.  Returned object (" + obj + ") is not ClassBytes."));
                        }
                        break block8;
                    }
                    log.error((Object)"Can not load remote class bytes.");
                }
                catch (Throwable throwable) {
                    log.error((Object)"Error loading remote class.", throwable);
                }
            } else {
                log.trace((Object)"Remoting Client for ClassByteClassLoader is null.  Can not load class remotely.");
            }
        }
        return loadedClass;
    }

    private static File createTempFile(final String prefix, final String suffix, final boolean deleteOnExit) throws IOException {
        if (SecurityUtility.skipAccessControl()) {
            File file = File.createTempFile(prefix, suffix);
            if (deleteOnExit) {
                file.deleteOnExit();
            }
            return file;
        }
        try {
            return (File)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    File file = File.createTempFile(prefix, suffix);
                    if (deleteOnExit) {
                        file.deleteOnExit();
                    }
                    return file;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getCause();
        }
    }

    private static boolean fileExists(final File file) {
        if (file == null) {
            return false;
        }
        if (SecurityUtility.skipAccessControl()) {
            return file.exists();
        }
        return (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return new Boolean(file.exists());
            }
        });
    }

    private static FileInputStream getFileInputStream(final File file) throws FileNotFoundException {
        if (SecurityUtility.skipAccessControl()) {
            return new FileInputStream(file);
        }
        try {
            return (FileInputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws FileNotFoundException {
                    return new FileInputStream(file);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (FileNotFoundException)e.getCause();
        }
    }

    private static FileOutputStream getFileOutputStream(final File file) throws FileNotFoundException {
        if (SecurityUtility.skipAccessControl()) {
            return new FileOutputStream(file);
        }
        try {
            return (FileOutputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws FileNotFoundException {
                    return new FileOutputStream(file);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (FileNotFoundException)e.getCause();
        }
    }

    private static ClassLoader getSystemClassLoaderPrivate() {
        if (SecurityUtility.skipAccessControl()) {
            return ClassLoader.getSystemClassLoader();
        }
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return ClassLoader.getSystemClassLoader();
            }
        });
    }

    private final class MyRef
    extends WeakReference {
        private final String key;

        MyRef(String key, Object obj) {
            super(obj);
            this.key = key;
        }
    }
}

