/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.cache.server;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.plugins.cache.server.ServerCache;

public class ServerCacheHitFilter
implements ContainerRequestFilter {
    protected ServerCache cache;
    public static final String DO_NOT_CACHE_RESPONSE = "DO NOT CACHE RESPONSE";
    @Context
    protected Request validation;

    public ServerCacheHitFilter(ServerCache cache) {
        this.cache = cache;
    }

    public void filter(ContainerRequestContext request) throws IOException {
        String key = request.getUriInfo().getRequestUri().toString();
        if (request.getMethod().equalsIgnoreCase("GET")) {
            this.handleGET(request, key);
        } else if (!request.getMethod().equalsIgnoreCase("HEAD")) {
            this.cache.remove(key);
        }
    }

    private void handleGET(ContainerRequestContext request, String key) {
        ServerCache.Entry entry = null;
        List acceptableMediaTypes = request.getAcceptableMediaTypes();
        entry = acceptableMediaTypes != null && acceptableMediaTypes.size() > 0 ? this.cache.get(key, (MediaType)acceptableMediaTypes.get(0), (MultivaluedMap<String, String>)request.getHeaders()) : this.cache.get(key, MediaType.WILDCARD_TYPE, (MultivaluedMap<String, String>)request.getHeaders());
        if (entry != null) {
            if (entry.isExpired()) {
                this.cache.remove(key);
                return;
            }
            Response.ResponseBuilder builder = this.validation.evaluatePreconditions(new EntityTag(entry.getEtag()));
            CacheControl cc = new CacheControl();
            cc.setMaxAge(entry.getExpirationInSeconds());
            if (builder != null) {
                request.abortWith(builder.cacheControl(cc).build());
                return;
            }
            builder = Response.ok();
            builder.entity((Object)entry.getCached());
            for (Map.Entry header : entry.getHeaders().entrySet()) {
                for (Object val : (List)header.getValue()) {
                    builder.header((String)header.getKey(), val);
                }
            }
            builder.cacheControl(cc);
            request.setProperty(DO_NOT_CACHE_RESPONSE, (Object)true);
            request.abortWith(builder.build());
        }
    }
}

