/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.spi.config;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.security.AccessController;
import java.util.Optional;
import java.util.function.Function;
import org.jboss.resteasy.resteasy_jaxrs.i18n.LogMessages;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.spi.ResteasyConfiguration;
import org.jboss.resteasy.spi.config.Configuration;

public class DefaultConfiguration
implements Configuration {
    private static final Function<String, String> DEFAULT_RESOLVER;
    private static final Method GET_CONFIG;
    private static final Method GET_OPTIONAL_VALUE;
    private static final Method GET_VALUE;
    private final Function<String, String> resolver;

    public DefaultConfiguration() {
        this(null);
    }

    public DefaultConfiguration(ResteasyConfiguration config) {
        this.resolver = config == null ? DEFAULT_RESOLVER : new Resolver(config);
    }

    @Override
    public <T> Optional<T> getOptionalValue(String name, Class<T> type) {
        Object typedValue;
        String value;
        if (GET_CONFIG != null) {
            try {
                Object config = GET_CONFIG.invoke(null, DefaultConfiguration.getClassLoader());
                return (Optional)GET_OPTIONAL_VALUE.invoke(config, name, type);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                LogMessages.LOGGER.debugf(e, "Failed to invoke the configuration API method %s.", GET_OPTIONAL_VALUE);
            }
        }
        if ((value = this.resolver.apply(name)) == null) {
            return Optional.empty();
        }
        if (type == String.class) {
            typedValue = type.cast(value);
        } else if (type == Boolean.class || type == Boolean.TYPE) {
            typedValue = Boolean.valueOf(value);
        } else if (type == Character.class || type == Character.TYPE) {
            if (value.isEmpty()) {
                return Optional.empty();
            }
            typedValue = Character.valueOf(value.charAt(0));
        } else if (type == Byte.class || type == Byte.TYPE) {
            typedValue = Byte.valueOf(value.trim());
        } else if (type == Short.class || type == Short.TYPE) {
            typedValue = Short.valueOf(value);
        } else if (type == Integer.class || type == Integer.TYPE) {
            typedValue = Integer.valueOf(value);
        } else if (type == Long.class || type == Long.TYPE) {
            typedValue = Long.valueOf(value);
        } else if (type == Float.class || type == Float.TYPE) {
            typedValue = Float.valueOf(value);
        } else if (type == Double.class || type == Double.TYPE) {
            typedValue = Double.valueOf(value);
        } else if (type == BigDecimal.class) {
            typedValue = new BigDecimal(value);
        } else if (type.isEnum()) {
            typedValue = Enum.valueOf(type.asSubclass(Enum.class), value);
        } else {
            throw Messages.MESSAGES.cannotConvertParameter(value, type, name);
        }
        return Optional.of(typedValue);
    }

    @Override
    public <T> T getValue(String name, Class<T> type) {
        if (GET_CONFIG != null) {
            try {
                Object config = GET_CONFIG.invoke(null, DefaultConfiguration.getClassLoader());
                return (T)GET_VALUE.invoke(config, name, type);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                LogMessages.LOGGER.debugf(e, "Failed to invoke the configuration API method %s.", GET_VALUE);
            }
        }
        return this.getOptionalValue(name, type).orElseThrow(() -> Messages.MESSAGES.propertyNotFound(name));
    }

    private static ClassLoader getClassLoader() {
        if (System.getSecurityManager() == null) {
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            return tccl != null ? tccl : DefaultConfiguration.class.getClassLoader();
        }
        return AccessController.doPrivileged(() -> {
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            return tccl != null ? tccl : DefaultConfiguration.class.getClassLoader();
        });
    }

    static {
        Method getValue;
        Method getOptionalValue;
        Method getConfig;
        DEFAULT_RESOLVER = new Resolver(null);
        try {
            ClassLoader classLoader = DefaultConfiguration.getClassLoader();
            Class<?> configProvider = Class.forName("org.eclipse.microprofile.config.ConfigProvider", false, classLoader);
            getConfig = configProvider.getDeclaredMethod("getConfig", ClassLoader.class);
            Class<?> config = Class.forName("org.eclipse.microprofile.config.Config", false, classLoader);
            getOptionalValue = config.getDeclaredMethod("getOptionalValue", String.class, Class.class);
            getValue = config.getDeclaredMethod("getValue", String.class, Class.class);
        }
        catch (Throwable ignore) {
            getConfig = null;
            getOptionalValue = null;
            getValue = null;
        }
        GET_CONFIG = getConfig;
        GET_OPTIONAL_VALUE = getOptionalValue;
        GET_VALUE = getValue;
    }

    private static class Resolver
    implements Function<String, String> {
        private final ResteasyConfiguration config;

        private Resolver(ResteasyConfiguration config) {
            this.config = config;
        }

        @Override
        public String apply(String name) {
            String value = System.getProperty(name);
            if (value == null && (value = System.getenv(name)) == null && this.config != null) {
                value = this.config.getInitParameter(name);
            }
            return value;
        }
    }
}

