/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.microprofile.config;

import java.util.Collections;
import java.util.Map;
import org.eclipse.microprofile.config.spi.ConfigSource;

public class BaseServletConfigSource {
    protected ConfigSource source;
    protected final boolean available;
    private volatile String name;

    public BaseServletConfigSource(boolean available, Class<?> sourceClass) {
        this.available = available;
        if (available) {
            try {
                this.source = (ConfigSource)sourceClass.newInstance();
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
    }

    public Map<String, String> getProperties() {
        if (!this.available) {
            return Collections.emptyMap();
        }
        return this.source.getProperties();
    }

    public String getValue(String propertyName) {
        if (!this.available) {
            return null;
        }
        return this.source.getValue(propertyName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getName() {
        if (this.name == null) {
            BaseServletConfigSource baseServletConfigSource = this;
            synchronized (baseServletConfigSource) {
                if (this.name == null) {
                    if (!this.available) {
                        this.name = this.toString();
                    }
                    this.name = this.source.getName();
                }
            }
        }
        return this.name;
    }
}

