/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.util;

import java.util.regex.Pattern;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.core.ResteasyContext;
import org.jboss.resteasy.specimpl.ResteasyUriInfo;

public class StringContextReplacement {
    private static final Pattern basepath = Pattern.compile("\\$\\{basepath\\}");
    private static final Pattern absolutepath = Pattern.compile("\\$\\{absolutepath\\}");
    private static final Pattern absoluteUri = Pattern.compile("\\$\\{absoluteuri\\}");
    private static final Pattern baseUri = Pattern.compile("\\$\\{baseuri\\}");
    private static final Pattern contextPath = Pattern.compile("\\$\\{contextpath\\}");

    public static String replace(String original) {
        UriInfo uriInfo = ResteasyContext.getContextData(UriInfo.class);
        if (uriInfo != null) {
            String base = uriInfo.getBaseUri().getRawPath();
            String abs = uriInfo.getAbsolutePath().getRawPath();
            String absU = uriInfo.getAbsolutePath().toString();
            String baseU = uriInfo.getBaseUri().toString();
            original = basepath.matcher(original).replaceAll(base);
            original = absolutepath.matcher(original).replaceAll(abs);
            original = absoluteUri.matcher(original).replaceAll(absU);
            original = baseUri.matcher(original).replaceAll(baseU);
            if (uriInfo instanceof ResteasyUriInfo) {
                original = contextPath.matcher(original).replaceAll(((ResteasyUriInfo)uriInfo).getContextPath());
            }
        }
        return original;
    }
}

