/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.tracing;

import jakarta.annotation.Priority;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.resteasy.tracing.RESTEasyTracingLogger;
import org.jboss.resteasy.tracing.api.RESTEasyMsgTraceEvent;
import org.jboss.resteasy.tracing.api.RESTEasyServerTracingEvent;
import org.jboss.resteasy.tracing.api.RESTEasyTracing;
import org.jboss.resteasy.tracing.api.RESTEasyTracingEvent;
import org.jboss.resteasy.tracing.api.RESTEasyTracingInfo;
import org.jboss.resteasy.tracing.api.RESTEasyTracingLevel;
import org.jboss.resteasy.tracing.api.RESTEasyTracingMessage;

class RESTEasyTracingLoggerImpl
extends RESTEasyTracing
implements RESTEasyTracingLogger {
    private final Logger logger;
    private final RESTEasyTracingLevel threshold;
    private final RESTEasyTracingInfo tracingInfo;
    private final String requestId;
    private static final Map<String, RESTEasyTracingEvent> string2event = new HashMap<String, RESTEasyTracingEvent>();

    RESTEasyTracingLoggerImpl(String requestId, RESTEasyTracingLevel threshold, String loggerNameSuffix) {
        this(requestId, threshold, loggerNameSuffix, null);
    }

    RESTEasyTracingLoggerImpl(String requestId, RESTEasyTracingLevel threshold, String loggerNameSuffix, String format) {
        this.requestId = requestId;
        this.threshold = threshold;
        this.logger = loggerNameSuffix != null ? Logger.getLogger((String)("org.jboss.resteasy.tracing." + loggerNameSuffix)) : Logger.getLogger((String)"org.jboss.resteasy.tracing.general");
        this.tracingInfo = RESTEasyTracingInfo.get((String)format);
    }

    private RESTEasyTracingEvent getEvent(String eventName) {
        RESTEasyTracingEvent e = string2event.get(eventName);
        if (e == null) {
            throw new IllegalArgumentException();
        }
        return e;
    }

    @Override
    public boolean isLogEnabled(String eventName) {
        return this.isLogEnabled(this.getEvent(eventName));
    }

    @Override
    public void log(String eventName, Object ... args) {
        this.log(this.getEvent(eventName), args);
    }

    @Override
    public void logDuration(String eventName, long fromTimestamp, Object ... args) {
        this.logDuration(this.getEvent(eventName), fromTimestamp, args);
    }

    @Override
    public long timestamp(String eventName) {
        return this.timestamp(this.getEvent(eventName));
    }

    private boolean isEnabled(RESTEasyTracingLevel level) {
        return this.threshold.ordinal() >= level.ordinal();
    }

    public boolean isLogEnabled(RESTEasyTracingEvent event) {
        return this.isEnabled(event.level());
    }

    public void log(RESTEasyTracingEvent event, Object ... args) {
        this.logDuration(event, -1L, args);
    }

    public void logDuration(RESTEasyTracingEvent event, long fromTimestamp, Object ... args) {
        if (this.isEnabled(event.level())) {
            long toTimestamp = fromTimestamp == -1L ? -1L : System.nanoTime();
            long duration = 0L;
            if (fromTimestamp != -1L && toTimestamp != -1L) {
                duration = toTimestamp - fromTimestamp;
            }
            this.logImpl(event, duration, args);
        }
    }

    private void logImpl(RESTEasyTracingEvent event, long duration, Object ... messageArgs) {
        if (this.isEnabled(event.level())) {
            Logger.Level loggingLevel;
            String[] messageArgsStr = new String[messageArgs.length];
            for (int i = 0; i < messageArgs.length; ++i) {
                messageArgsStr[i] = this.formatInstance(messageArgs[i]);
            }
            RESTEasyTracingMessage message = new RESTEasyTracingMessage(event, this.requestId, duration, messageArgsStr);
            this.tracingInfo.addMessage(message);
            switch (event.level()) {
                case SUMMARY: {
                    loggingLevel = Logger.Level.INFO;
                    break;
                }
                case TRACE: {
                    loggingLevel = Logger.Level.DEBUG;
                    break;
                }
                case VERBOSE: {
                    loggingLevel = Logger.Level.TRACE;
                    break;
                }
                default: {
                    loggingLevel = Logger.Level.INFO;
                }
            }
            if (this.logger.isEnabled(loggingLevel)) {
                this.logger.log(loggingLevel, (Object)(this.requestId + ' ' + event.name() + ' ' + message.toString() + " [" + this.tracingInfo.formatDuration(duration) + " ms]"));
            }
        }
    }

    private static void formatInstance(Object instance, StringBuilder text) {
        text.append(instance.getClass().getName()).append(" @").append(Integer.toHexString(System.identityHashCode(instance)));
    }

    private static void formatResponse(Response response, StringBuilder text) {
        Object entity;
        text.append(" <").append(RESTEasyTracingLoggerImpl.formatStatusInfo(response.getStatusInfo())).append('|');
        try {
            entity = response.getEntity();
        }
        catch (IllegalStateException ise) {
            entity = null;
        }
        if (entity != null) {
            RESTEasyTracingLoggerImpl.formatInstance(entity, text);
        } else {
            text.append("-no-entity-");
        }
        text.append('>');
    }

    private static String formatStatusInfo(Response.StatusType statusInfo) {
        return String.valueOf(statusInfo.getStatusCode()) + '/' + statusInfo.getFamily() + '|' + statusInfo.getReasonPhrase();
    }

    private String formatInstance(Object instance) {
        StringBuilder text = new StringBuilder();
        if (instance == null) {
            text.append("null");
        } else if (instance instanceof Number || instance instanceof String || instance instanceof Method) {
            text.append(instance.toString());
        } else if (instance instanceof Response.StatusType) {
            text.append(RESTEasyTracingLoggerImpl.formatStatusInfo((Response.StatusType)instance));
        } else {
            text.append('[');
            RESTEasyTracingLoggerImpl.formatInstance(instance, text);
            if (instance.getClass().isAnnotationPresent(Priority.class)) {
                text.append(" #").append(instance.getClass().getAnnotation(Priority.class).value());
            }
            if (instance instanceof WebApplicationException) {
                RESTEasyTracingLoggerImpl.formatResponse(((WebApplicationException)((Object)instance)).getResponse(), text);
            } else if (instance instanceof Response) {
                RESTEasyTracingLoggerImpl.formatResponse((Response)instance, text);
            }
            text.append(']');
        }
        return text.toString();
    }

    public long timestamp(RESTEasyTracingEvent event) {
        if (this.isEnabled(event.level())) {
            return System.nanoTime();
        }
        return -1L;
    }

    @Override
    public void flush(MultivaluedMap<String, Object> headers) {
        String[] messages = this.tracingInfo.getMessages();
        for (int i = 0; i < messages.length; ++i) {
            headers.putSingle((Object)String.format("X-RESTEasy-Tracing-%03d", i), (Object)messages[i]);
        }
    }

    static {
        for (RESTEasyServerTracingEvent rESTEasyServerTracingEvent : RESTEasyServerTracingEvent.values()) {
            string2event.put(rESTEasyServerTracingEvent.name(), (RESTEasyTracingEvent)rESTEasyServerTracingEvent);
        }
        for (RESTEasyServerTracingEvent rESTEasyServerTracingEvent : RESTEasyMsgTraceEvent.values()) {
            string2event.put(rESTEasyServerTracingEvent.name(), (RESTEasyTracingEvent)rESTEasyServerTracingEvent);
        }
    }
}

