/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core.providerfactory;

import jakarta.ws.rs.ConstrainedTo;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.RuntimeType;
import jakarta.ws.rs.SeBootstrap;
import jakarta.ws.rs.client.ClientRequestFilter;
import jakarta.ws.rs.client.ClientResponseFilter;
import jakarta.ws.rs.client.RxInvoker;
import jakarta.ws.rs.client.RxInvokerProvider;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.container.DynamicFeature;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.core.CacheControl;
import jakarta.ws.rs.core.Configurable;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Cookie;
import jakarta.ws.rs.core.EntityPart;
import jakarta.ws.rs.core.EntityTag;
import jakarta.ws.rs.core.Feature;
import jakarta.ws.rs.core.FeatureContext;
import jakarta.ws.rs.core.Link;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.NewCookie;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.core.Variant;
import jakarta.ws.rs.ext.ContextResolver;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.ParamConverter;
import jakarta.ws.rs.ext.ParamConverterProvider;
import jakarta.ws.rs.ext.Providers;
import jakarta.ws.rs.ext.ReaderInterceptor;
import jakarta.ws.rs.ext.RuntimeDelegate;
import jakarta.ws.rs.ext.WriterInterceptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URI;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.jboss.resteasy.core.InjectorFactoryImpl;
import org.jboss.resteasy.core.MediaTypeMap;
import org.jboss.resteasy.core.ResteasyContext;
import org.jboss.resteasy.core.providerfactory.ClientHelper;
import org.jboss.resteasy.core.providerfactory.DefaultExceptionMapper;
import org.jboss.resteasy.core.providerfactory.ExtSortedKey;
import org.jboss.resteasy.core.providerfactory.NOOPClientHelper;
import org.jboss.resteasy.core.providerfactory.NOOPServerHelper;
import org.jboss.resteasy.core.providerfactory.ServerHelper;
import org.jboss.resteasy.core.providerfactory.SortedKey;
import org.jboss.resteasy.core.providerfactory.Utils;
import org.jboss.resteasy.core.se.ResteasySeConfiguration;
import org.jboss.resteasy.core.se.ResteasySeInstance;
import org.jboss.resteasy.plugins.delegates.CacheControlDelegate;
import org.jboss.resteasy.plugins.delegates.CookieHeaderDelegate;
import org.jboss.resteasy.plugins.delegates.DateDelegate;
import org.jboss.resteasy.plugins.delegates.EntityTagDelegate;
import org.jboss.resteasy.plugins.delegates.LinkDelegate;
import org.jboss.resteasy.plugins.delegates.LinkHeaderDelegate;
import org.jboss.resteasy.plugins.delegates.LocaleDelegate;
import org.jboss.resteasy.plugins.delegates.MediaTypeHeaderDelegate;
import org.jboss.resteasy.plugins.delegates.NewCookieHeaderDelegate;
import org.jboss.resteasy.plugins.delegates.UriHeaderDelegate;
import org.jboss.resteasy.plugins.providers.RegisterBuiltin;
import org.jboss.resteasy.resteasy_jaxrs.i18n.LogMessages;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.spi.AsyncClientResponseProvider;
import org.jboss.resteasy.spi.AsyncResponseProvider;
import org.jboss.resteasy.spi.AsyncStreamProvider;
import org.jboss.resteasy.spi.ConstructorInjector;
import org.jboss.resteasy.spi.ContextInjector;
import org.jboss.resteasy.spi.Dispatcher;
import org.jboss.resteasy.spi.HeaderValueProcessor;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.InjectorFactory;
import org.jboss.resteasy.spi.LinkHeader;
import org.jboss.resteasy.spi.PriorityServiceLoader;
import org.jboss.resteasy.spi.PropertyInjector;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.spi.StringParameterUnmarshaller;
import org.jboss.resteasy.spi.concurrent.ThreadContext;
import org.jboss.resteasy.spi.concurrent.ThreadContexts;
import org.jboss.resteasy.spi.config.Options;
import org.jboss.resteasy.spi.interception.JaxrsInterceptorRegistry;
import org.jboss.resteasy.spi.metadata.ResourceBuilder;
import org.jboss.resteasy.spi.metadata.ResourceClassProcessor;
import org.jboss.resteasy.spi.statistics.StatisticsController;
import org.jboss.resteasy.spi.util.PickConstructor;
import org.jboss.resteasy.spi.util.Types;
import org.jboss.resteasy.statistics.StatisticsControllerImpl;
import org.jboss.resteasy.tracing.RESTEasyTracingLogger;
import org.jboss.resteasy.util.FeatureContextDelegate;
import org.jboss.resteasy.util.snapshot.SnapshotMap;
import org.jboss.resteasy.util.snapshot.SnapshotSet;

public class ResteasyProviderFactoryImpl
extends ResteasyProviderFactory
implements Providers,
HeaderValueProcessor,
Configurable<ResteasyProviderFactory>,
Configuration {
    protected ClientHelper clientHelper;
    protected ServerHelper serverHelper;
    protected SnapshotSet<Class<?>> providerClasses;
    protected SnapshotSet<Object> providerInstances;
    protected SnapshotMap<Class<?>, Map<Class<?>, Integer>> classContracts;
    protected SnapshotMap<String, Object> properties;
    protected SnapshotMap<Class<?>, RuntimeDelegate.HeaderDelegate> headerDelegates;
    protected SnapshotMap<Type, ContextInjector> contextInjectors;
    protected SnapshotMap<Type, ContextInjector> asyncContextInjectors;
    protected SnapshotMap<Class<?>, Class<? extends StringParameterUnmarshaller>> stringParameterUnmarshallers;
    protected SnapshotSet<Feature> enabledFeatures;
    protected boolean attachedContextResolvers;
    protected Map<Class<?>, MediaTypeMap<SortedKey<ContextResolver>>> contextResolvers;
    protected boolean attachedParamConverterProviders;
    protected Set<ExtSortedKey<ParamConverterProvider>> sortedParamConverterProviders;
    protected Set<Class<?>> alreadyEstablishedNullHeaderDelegate = ConcurrentHashMap.newKeySet();
    protected boolean builtinsRegistered = false;
    protected boolean registerBuiltins = true;
    protected InjectorFactory injectorFactory;
    protected ResourceBuilder resourceBuilder;
    protected boolean initialized = false;
    protected boolean lockSnapshots;
    protected StatisticsControllerImpl statisticsController = new StatisticsControllerImpl();
    private final boolean defaultExceptionManagerEnabled;

    public ResteasyProviderFactoryImpl() {
        this((Boolean)ResteasyProviderFactoryImpl.getOptionValue(Options.ENABLE_DEFAULT_EXCEPTION_MAPPER));
    }

    public ResteasyProviderFactoryImpl(boolean defaultExceptionManagerEnabled) {
        this.initialize();
        this.defaultExceptionManagerEnabled = defaultExceptionManagerEnabled;
    }

    public ResteasyProviderFactoryImpl(RuntimeType runtimeType) {
        if (runtimeType != RuntimeType.CLIENT) {
            throw new IllegalStateException();
        }
        this.clientHelper = new ClientHelper(this);
        this.serverHelper = NOOPServerHelper.SINGLETON;
        this.initializeCommon(null, true, false);
        this.lockSnapshots();
        this.defaultExceptionManagerEnabled = (Boolean)ResteasyProviderFactoryImpl.getOptionValue(Options.ENABLE_DEFAULT_EXCEPTION_MAPPER);
    }

    public ResteasyProviderFactoryImpl(RuntimeType runtimeType, ResteasyProviderFactory parent) {
        if (runtimeType == RuntimeType.CLIENT) {
            ResteasyProviderFactoryImpl impl = (ResteasyProviderFactoryImpl)parent;
            this.clientHelper = new ClientHelper(this, impl.clientHelper);
            this.serverHelper = NOOPServerHelper.SINGLETON;
            this.lockSnapshots = true;
            this.initializeCommon(impl, true, false);
            this.lockSnapshots();
        } else {
            ResteasyProviderFactoryImpl parentImpl = (ResteasyProviderFactoryImpl)parent;
            this.clientHelper = NOOPClientHelper.SINGLETON;
            this.serverHelper = new ServerHelper(this, parentImpl.serverHelper);
            this.initializeCommon(parentImpl, false, true);
        }
        this.defaultExceptionManagerEnabled = (Boolean)ResteasyProviderFactoryImpl.getOptionValue(Options.ENABLE_DEFAULT_EXCEPTION_MAPPER);
    }

    protected void registerBuiltin() {
        RegisterBuiltin.register(this);
    }

    protected void initializeCommon(ResteasyProviderFactoryImpl parent, boolean lockSnapshots, boolean snapFirst) {
        this.properties = parent == null ? new SnapshotMap(lockSnapshots) : new SnapshotMap<String, Object>(parent.properties, true, lockSnapshots, snapFirst);
        this.providerClasses = parent == null ? new SnapshotSet(lockSnapshots) : new SnapshotSet(parent.providerClasses, true, lockSnapshots, snapFirst);
        this.providerInstances = parent == null ? new SnapshotSet(lockSnapshots) : new SnapshotSet<Object>(parent.providerInstances, true, lockSnapshots, snapFirst);
        this.classContracts = parent == null ? new SnapshotMap(lockSnapshots) : new SnapshotMap(parent.classContracts, true, lockSnapshots, snapFirst);
        SnapshotSet<Object> snapshotSet = this.enabledFeatures = parent == null ? new SnapshotSet(lockSnapshots) : new SnapshotSet<Feature>(parent.enabledFeatures, true, lockSnapshots, snapFirst);
        if (parent != null) {
            if (snapFirst) {
                this.attachedParamConverterProviders = true;
                this.sortedParamConverterProviders = parent.sortedParamConverterProviders;
                this.attachedContextResolvers = true;
                this.contextResolvers = parent.contextResolvers;
            } else {
                this.contextResolvers = new ConcurrentHashMap();
                for (Map.Entry<Class<?>, MediaTypeMap<SortedKey<ContextResolver>>> entry : parent.contextResolvers.entrySet()) {
                    this.contextResolvers.put(entry.getKey(), new MediaTypeMap<SortedKey<ContextResolver>>(entry.getValue()));
                }
                this.sortedParamConverterProviders = Collections.synchronizedSortedSet(new TreeSet<ExtSortedKey<ParamConverterProvider>>(parent.sortedParamConverterProviders));
            }
        } else {
            this.contextResolvers = new ConcurrentHashMap();
            this.sortedParamConverterProviders = Collections.synchronizedSortedSet(new TreeSet());
        }
        this.resourceBuilder = new ResourceBuilder();
        SnapshotMap<Object, Object> snapshotMap = this.headerDelegates = parent == null ? new SnapshotMap(lockSnapshots) : new SnapshotMap(parent.getHeaderDelegates(), true, lockSnapshots, snapFirst);
        if (parent == null) {
            this.addHeaderDelegateIfAbsent(MediaType.class, MediaTypeHeaderDelegate.INSTANCE);
            this.addHeaderDelegateIfAbsent(NewCookie.class, NewCookieHeaderDelegate.INSTANCE);
            this.addHeaderDelegateIfAbsent(Cookie.class, CookieHeaderDelegate.INSTANCE);
            this.addHeaderDelegateIfAbsent(URI.class, UriHeaderDelegate.INSTANCE);
            this.addHeaderDelegateIfAbsent(EntityTag.class, EntityTagDelegate.INSTANCE);
            this.addHeaderDelegateIfAbsent(CacheControl.class, CacheControlDelegate.INSTANCE);
            this.addHeaderDelegateIfAbsent(Locale.class, LocaleDelegate.INSTANCE);
            this.addHeaderDelegateIfAbsent(LinkHeader.class, LinkHeaderDelegate.INSTANCE);
            this.addHeaderDelegateIfAbsent(Link.class, LinkDelegate.INSTANCE);
            this.addHeaderDelegateIfAbsent(Date.class, DateDelegate.INSTANCE);
        }
        this.builtinsRegistered = false;
        this.registerBuiltins = true;
        this.stringParameterUnmarshallers = parent == null ? new SnapshotMap(lockSnapshots) : new SnapshotMap(parent.stringParameterUnmarshallers, true, lockSnapshots, snapFirst);
        this.contextInjectors = parent == null ? new SnapshotMap(lockSnapshots) : new SnapshotMap<Type, ContextInjector>(parent.contextInjectors, true, lockSnapshots, snapFirst);
        this.asyncContextInjectors = parent == null ? new SnapshotMap(lockSnapshots) : new SnapshotMap<Type, ContextInjector>(parent.asyncContextInjectors, true, lockSnapshots, snapFirst);
        this.injectorFactory = parent == null ? InjectorFactoryImpl.INSTANCE : parent.getInjectorFactory();
        this.initialized = true;
    }

    private void copyResolversIfNeeded() {
        if (!this.attachedContextResolvers) {
            return;
        }
        ConcurrentHashMap newResolvers = new ConcurrentHashMap();
        for (Map.Entry<Class<?>, MediaTypeMap<SortedKey<ContextResolver>>> entry : this.contextResolvers.entrySet()) {
            newResolvers.put(entry.getKey(), new MediaTypeMap<SortedKey<ContextResolver>>(entry.getValue()));
        }
        this.contextResolvers = newResolvers;
        this.attachedContextResolvers = false;
    }

    protected void initialize() {
        this.initializeCommon(null, false, false);
        this.clientHelper = new ClientHelper(this);
        this.serverHelper = new ServerHelper(this);
    }

    public void lockSnapshots() {
        this.lockSnapshots = true;
        if (this.providerClasses != null) {
            this.providerClasses.lockSnapshots();
        }
        if (this.providerInstances != null) {
            this.providerInstances.lockSnapshots();
        }
        if (this.classContracts != null) {
            this.classContracts.lockSnapshots();
        }
        if (this.properties != null) {
            this.properties.lockSnapshots();
        }
        if (this.headerDelegates != null) {
            this.headerDelegates.lockSnapshots();
        }
        if (this.contextInjectors != null) {
            this.contextInjectors.lockSnapshots();
        }
        if (this.asyncContextInjectors != null) {
            this.asyncContextInjectors.lockSnapshots();
        }
        if (this.stringParameterUnmarshallers != null) {
            this.stringParameterUnmarshallers.lockSnapshots();
        }
        if (this.enabledFeatures != null) {
            this.enabledFeatures.lockSnapshots();
        }
        this.clientHelper.lockSnapshots();
        this.serverHelper.lockSnapshots();
    }

    public Set<DynamicFeature> getServerDynamicFeatures() {
        return this.serverHelper.getDynamicFeatures();
    }

    public Set<DynamicFeature> getClientDynamicFeatures() {
        return this.clientHelper.getDynamicFeatures();
    }

    protected MediaTypeMap<SortedKey<MessageBodyReader>> getServerMessageBodyReaders() {
        return this.serverHelper.getMessageBodyReaders();
    }

    protected MediaTypeMap<SortedKey<MessageBodyWriter>> getServerMessageBodyWriters() {
        return this.serverHelper.getMessageBodyWriters();
    }

    protected MediaTypeMap<SortedKey<MessageBodyReader>> getClientMessageBodyReaders() {
        return this.clientHelper.getMessageBodyReaders();
    }

    protected MediaTypeMap<SortedKey<MessageBodyWriter>> getClientMessageBodyWriters() {
        return this.clientHelper.getMessageBodyWriters();
    }

    private Map<Class<?>, SortedKey<ExceptionMapper>> getSortedExceptionMappers() {
        return this.serverHelper.getExceptionMappers();
    }

    public Map<Class<?>, AsyncResponseProvider> getAsyncResponseProviders() {
        return this.serverHelper.getAsyncResponseProviders();
    }

    public Map<Class<?>, AsyncStreamProvider> getAsyncStreamProviders() {
        return this.serverHelper.getAsyncStreamProviders();
    }

    public Map<Class<?>, AsyncClientResponseProvider> getAsyncClientResponseProviders() {
        return this.clientHelper.getAsyncClientResponseProviders();
    }

    public Map<Type, ContextInjector> getContextInjectors() {
        return this.contextInjectors;
    }

    public Map<Type, ContextInjector> getAsyncContextInjectors() {
        return this.asyncContextInjectors;
    }

    protected Map<Class<?>, MediaTypeMap<SortedKey<ContextResolver>>> getContextResolvers() {
        return this.contextResolvers;
    }

    protected Set<ExtSortedKey<ParamConverterProvider>> getSortedParamConverterProviders() {
        return this.sortedParamConverterProviders;
    }

    protected Map<Class<?>, Class<? extends StringParameterUnmarshaller>> getStringParameterUnmarshallers() {
        return this.stringParameterUnmarshallers;
    }

    public Set<Class<?>> getProviderClasses() {
        return Collections.unmodifiableSet(this.providerClasses);
    }

    public Set<Object> getProviderInstances() {
        return Collections.unmodifiableSet(this.providerInstances);
    }

    public Map<Class<?>, Map<Class<?>, Integer>> getClassContracts() {
        return this.classContracts;
    }

    public <T> T getContextData(Class<T> rawType, Type genericType, Annotation[] annotations, boolean unwrapAsync) {
        Object ret = ResteasyContext.getContextDataMap().get(rawType);
        if (ret != null) {
            return (T)ret;
        }
        ContextInjector contextInjector = this.getContextInjectors().get(genericType);
        boolean async = false;
        if (contextInjector == null && unwrapAsync) {
            contextInjector = this.getAsyncContextInjectors().get(Types.boxPrimitives((Type)genericType));
            async = true;
        }
        if (contextInjector != null) {
            ret = contextInjector.resolve(rawType, genericType, annotations);
            if (async && ret != null) {
                Type wrappedType = Types.getActualTypeArgumentsOfAnInterface((Class)contextInjector.getClass(), ContextInjector.class)[0];
                Class rawWrappedType = Types.getRawType((Type)wrappedType);
                AsyncResponseProvider<T> converter = this.getAsyncResponseProvider(rawWrappedType);
                ret = converter.toCompletionStage(ret);
            }
        }
        return (T)ret;
    }

    public boolean isRegisterBuiltins() {
        return this.registerBuiltins;
    }

    public void setRegisterBuiltins(boolean registerBuiltins) {
        this.registerBuiltins = registerBuiltins;
    }

    public InjectorFactory getInjectorFactory() {
        return this.injectorFactory;
    }

    public void setInjectorFactory(InjectorFactory injectorFactory) {
        this.injectorFactory = injectorFactory;
    }

    public JaxrsInterceptorRegistry<ReaderInterceptor> getServerReaderInterceptorRegistry() {
        return this.serverHelper.getReaderInterceptorRegistry();
    }

    public JaxrsInterceptorRegistry<WriterInterceptor> getServerWriterInterceptorRegistry() {
        return this.serverHelper.getWriterInterceptorRegistry();
    }

    public JaxrsInterceptorRegistry<ContainerRequestFilter> getContainerRequestFilterRegistry() {
        return this.serverHelper.getRequestFilters();
    }

    public JaxrsInterceptorRegistry<ContainerResponseFilter> getContainerResponseFilterRegistry() {
        return this.serverHelper.getResponseFilters();
    }

    public JaxrsInterceptorRegistry<ReaderInterceptor> getClientReaderInterceptorRegistry() {
        return this.clientHelper.getReaderInterceptorRegistry();
    }

    public JaxrsInterceptorRegistry<WriterInterceptor> getClientWriterInterceptorRegistry() {
        return this.clientHelper.getWriterInterceptorRegistry();
    }

    public JaxrsInterceptorRegistry<ClientRequestFilter> getClientRequestFilterRegistry() {
        return this.clientHelper.getRequestFilters();
    }

    public JaxrsInterceptorRegistry<ClientResponseFilter> getClientResponseFilters() {
        return this.clientHelper.getResponseFilters();
    }

    public boolean isBuiltinsRegistered() {
        return this.builtinsRegistered;
    }

    public void setBuiltinsRegistered(boolean builtinsRegistered) {
        this.builtinsRegistered = builtinsRegistered;
    }

    public UriBuilder createUriBuilder() {
        return Utils.createUriBuilder();
    }

    public Response.ResponseBuilder createResponseBuilder() {
        return Utils.createResponseBuilder();
    }

    public Variant.VariantListBuilder createVariantListBuilder() {
        return Utils.createVariantListBuilder();
    }

    public <T> RuntimeDelegate.HeaderDelegate<T> createHeaderDelegate(Class<T> tClass) {
        if (tClass == null) {
            throw new IllegalArgumentException(Messages.MESSAGES.tClassParameterNull());
        }
        return Utils.createHeaderDelegate(this.headerDelegates, this.alreadyEstablishedNullHeaderDelegate, tClass);
    }

    protected Map<Class<?>, RuntimeDelegate.HeaderDelegate> getHeaderDelegates() {
        return this.headerDelegates;
    }

    public void addHeaderDelegate(Class clazz, RuntimeDelegate.HeaderDelegate header) {
        this.headerDelegates.put(clazz, header);
    }

    protected void addHeaderDelegateIfAbsent(Class clazz, RuntimeDelegate.HeaderDelegate header) {
        if (!this.headerDelegates.containsKey(clazz)) {
            this.addHeaderDelegate(clazz, header);
        }
    }

    @Deprecated
    public <T> MessageBodyReader<T> getServerMessageBodyReader(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        MediaTypeMap<SortedKey<MessageBodyReader>> availableReaders = this.getServerMessageBodyReaders();
        return this.resolveMessageBodyReader(type, genericType, annotations, mediaType, availableReaders);
    }

    public <T> MessageBodyReader<T> getServerMessageBodyReader(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType, RESTEasyTracingLogger tracingLogger) {
        MediaTypeMap<SortedKey<MessageBodyReader>> availableReaders = this.getServerMessageBodyReaders();
        return this.resolveMessageBodyReader(type, genericType, annotations, mediaType, availableReaders, tracingLogger);
    }

    public <T> MessageBodyReader<T> getMessageBodyReader(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        MediaTypeMap<SortedKey<MessageBodyReader>> availableReaders = this.getServerMessageBodyReaders();
        MessageBodyReader<T> reader = this.resolveMessageBodyReader(type, genericType, annotations, mediaType, availableReaders);
        if (reader != null) {
            LogMessages.LOGGER.debugf("MessageBodyReader: %s", (Object)reader.getClass().getName());
        }
        return reader;
    }

    public <T> MessageBodyReader<T> getClientMessageBodyReader(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        MediaTypeMap<SortedKey<MessageBodyReader>> availableReaders = this.getClientMessageBodyReaders();
        if (availableReaders == null) {
            return null;
        }
        return this.resolveMessageBodyReader(type, genericType, annotations, mediaType, availableReaders);
    }

    @Deprecated
    private <T> MessageBodyReader<T> resolveMessageBodyReader(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType, MediaTypeMap<SortedKey<MessageBodyReader>> availableReaders) {
        if (availableReaders == null) {
            return null;
        }
        List<SortedKey<MessageBodyReader>> readers = availableReaders.getPossible(mediaType, type);
        for (SortedKey<MessageBodyReader> reader : readers) {
            if (!reader.getObj().isReadable(type, genericType, annotations, mediaType)) continue;
            LogMessages.LOGGER.debugf("MessageBodyReader: %s", (Object)reader.getClass().getName());
            return reader.getObj();
        }
        return null;
    }

    private <T> MessageBodyReader<T> resolveMessageBodyReader(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType, MediaTypeMap<SortedKey<MessageBodyReader>> availableReaders, RESTEasyTracingLogger tracingLogger) {
        SortedKey<MessageBodyReader> reader;
        if (availableReaders == null) {
            return null;
        }
        List<SortedKey<MessageBodyReader>> readers = availableReaders.getPossible(mediaType, type);
        if (tracingLogger.isLogEnabled("MBR_FIND")) {
            tracingLogger.log("MBR_FIND", type.getName(), genericType instanceof Class ? ((Class)genericType).getName() : genericType, mediaType, Arrays.toString(annotations));
        }
        MessageBodyReader result = null;
        Iterator<SortedKey<MessageBodyReader>> iterator = readers.iterator();
        while (iterator.hasNext()) {
            reader = iterator.next();
            if (reader.getObj().isReadable(type, genericType, annotations, mediaType)) {
                LogMessages.LOGGER.debugf("MessageBodyReader: %s", (Object)reader.getClass().getName());
                result = reader.getObj();
                tracingLogger.log("MBR_SELECTED", reader);
                break;
            }
            tracingLogger.log("MBR_NOT_READABLE", result);
        }
        if (tracingLogger.isLogEnabled("MBR_SKIPPED")) {
            while (iterator.hasNext()) {
                reader = iterator.next();
                tracingLogger.log("MBR_SKIPPED", reader.getObj());
            }
        }
        return result;
    }

    private void addContextInjector(ContextInjector provider, Class providerClass) {
        Type[] typeArgs = Types.getActualTypeArgumentsOfAnInterface((Class)providerClass, ContextInjector.class);
        Utils.injectProperties(this, provider.getClass(), provider);
        this.contextInjectors.put(typeArgs[0], provider);
        if (!Objects.equals(typeArgs[0], typeArgs[1])) {
            this.asyncContextInjectors.put(typeArgs[1], provider);
        }
    }

    private void addContextResolver(ContextResolver provider, int priority, Class providerClass, boolean builtin) {
        if (providerClass.getName().contains("$$Lambda$")) {
            throw new RuntimeException(Messages.MESSAGES.registeringContextResolverAsLambda());
        }
        this.copyResolversIfNeeded();
        Type[] typeParameters = Types.getActualTypeArgumentsOfAnInterface((Class)providerClass, ContextResolver.class);
        if (typeParameters.length == 0) {
            Class superType = providerClass.getSuperclass();
            if (superType == null) {
                throw Messages.MESSAGES.couldNotDetermineGenericType(providerClass.getName(), ContextResolver.class.getName());
            }
            typeParameters = Types.getActualTypeArgumentsOfAnInterface(superType, ContextResolver.class);
            if (typeParameters.length == 0) {
                throw Messages.MESSAGES.couldNotDetermineGenericType(providerClass.getName(), ContextResolver.class.getName());
            }
        }
        Type typeParameter = typeParameters[0];
        Utils.injectProperties(this, providerClass, provider);
        Class parameterClass = Types.getRawType((Type)typeParameter);
        MediaTypeMap<SortedKey<Object>> resolvers = this.contextResolvers.get(parameterClass);
        if (resolvers == null) {
            resolvers = new MediaTypeMap();
            this.contextResolvers.put(parameterClass, resolvers);
        }
        Produces produces = provider.getClass().getAnnotation(Produces.class);
        SortedKey<ContextResolver> key = new SortedKey<ContextResolver>(ContextResolver.class, provider, providerClass, priority, builtin);
        if (produces != null) {
            for (String produce : produces.value()) {
                resolvers.add(produce, key);
            }
        } else {
            resolvers.add("*/*", key);
        }
    }

    public void addStringParameterUnmarshaller(Class<? extends StringParameterUnmarshaller> provider) {
        Type[] intfs;
        for (Type type : intfs = provider.getGenericInterfaces()) {
            ParameterizedType pt;
            if (!(type instanceof ParameterizedType) || !(pt = (ParameterizedType)type).getRawType().equals(StringParameterUnmarshaller.class)) continue;
            Class aClass = Types.getRawType((Type)pt.getActualTypeArguments()[0]);
            this.stringParameterUnmarshallers.put(aClass, provider);
        }
    }

    public List<ContextResolver> getContextResolvers(Class<?> clazz, MediaType type) {
        if (this.getContextResolvers() == null) {
            return null;
        }
        MediaTypeMap<SortedKey<ContextResolver>> resolvers = this.getContextResolvers().get(clazz);
        if (resolvers == null) {
            return null;
        }
        ArrayList<ContextResolver> rtn = new ArrayList<ContextResolver>();
        List<SortedKey<ContextResolver>> list = resolvers.getPossible(type);
        list.forEach(resolver -> rtn.add((ContextResolver)resolver.getObj()));
        return rtn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ParamConverter getParamConverter(Class clazz, Type genericType, Annotation[] annotations) {
        try {
            ResteasyContext.pushContext(ResteasyProviderFactory.class, this);
            for (SortedKey sortedKey : this.getSortedParamConverterProviders()) {
                ParamConverter converter = ((ParamConverterProvider)sortedKey.getObj()).getConverter(clazz, genericType, annotations);
                if (converter == null) continue;
                ParamConverter paramConverter = converter;
                return paramConverter;
            }
            Iterator<ExtSortedKey<ParamConverterProvider>> iterator = null;
            return iterator;
        }
        finally {
            ResteasyContext.popContextData(ResteasyProviderFactory.class);
        }
    }

    public <T> StringParameterUnmarshaller<T> createStringParameterUnmarshaller(Class<T> clazz) {
        if (this.getStringParameterUnmarshallers() == null || this.getStringParameterUnmarshallers().isEmpty()) {
            return null;
        }
        Class<? extends StringParameterUnmarshaller> un = this.getStringParameterUnmarshallers().get(clazz);
        if (un == null) {
            return null;
        }
        StringParameterUnmarshaller provider = this.injectedInstance(un);
        return provider;
    }

    public void registerProvider(Class provider) {
        this.registerProvider(provider, false);
    }

    public String toString(Object object, Class clazz, Type genericType, Annotation[] annotations) {
        if (object instanceof String) {
            return (String)object;
        }
        ParamConverter paramConverter = this.getParamConverter(clazz, genericType, annotations);
        if (paramConverter != null) {
            return paramConverter.toString(object);
        }
        return object.toString();
    }

    public String toHeaderString(Object object) {
        if (object == null) {
            return "";
        }
        if (object instanceof String) {
            return (String)object;
        }
        Class<?> aClass = object.getClass();
        ParamConverter paramConverter = this.getParamConverter(aClass, null, null);
        if (paramConverter != null) {
            return paramConverter.toString(object);
        }
        RuntimeDelegate.HeaderDelegate delegate = this.getHeaderDelegate(aClass);
        if (delegate != null) {
            return delegate.toString(object);
        }
        return object.toString();
    }

    public RuntimeDelegate.HeaderDelegate getHeaderDelegate(Class<?> aClass) {
        RuntimeDelegate.HeaderDelegate delegate = null;
        delegate = RuntimeDelegate.getInstance() instanceof ResteasyProviderFactory ? this.createHeaderDelegate(aClass) : RuntimeDelegate.getInstance().createHeaderDelegate(aClass);
        return delegate;
    }

    public void registerProvider(Class provider, boolean isBuiltin) {
        this.registerProvider(provider, null, isBuiltin, null);
    }

    public void registerProvider(Class provider, Integer priorityOverride, boolean isBuiltin, Map<Class<?>, Integer> contracts) {
        Map<Class<?>, Map<Class<?>, Integer>> classContracts = this.getClassContracts();
        if (classContracts.containsKey(provider)) {
            LogMessages.LOGGER.providerClassAlreadyRegistered(provider.getName());
            return;
        }
        HashMap newContracts = new HashMap();
        this.processProviderContracts(provider, priorityOverride, isBuiltin, contracts, newContracts);
        this.providerClasses.add(provider);
        classContracts.put(provider, newContracts);
    }

    public Set<Class<?>> getMutableProviderClasses() {
        return this.providerClasses;
    }

    private void processProviderContracts(Class provider, Integer priorityOverride, boolean isBuiltin, Map<Class<?>, Integer> contracts, Map<Class<?>, Integer> newContracts) {
        int priority;
        this.clientHelper.processProviderContracts(provider, priorityOverride, isBuiltin, contracts, newContracts);
        this.serverHelper.processProviderContracts(provider, priorityOverride, isBuiltin, contracts, newContracts);
        if (Utils.isA(provider, ParamConverterProvider.class, contracts)) {
            priority = Utils.getPriority(priorityOverride, contracts, ParamConverterProvider.class, provider);
            this.addParameterConverterProvider(provider, isBuiltin, priority);
            newContracts.put(ParamConverterProvider.class, priority);
        }
        if (Utils.isA(provider, ContextResolver.class, contracts)) {
            try {
                priority = Utils.getPriority(priorityOverride, contracts, ContextResolver.class, provider);
                this.addContextResolver(provider, isBuiltin, priority);
                newContracts.put(ContextResolver.class, priority);
            }
            catch (Exception e) {
                throw new RuntimeException(Messages.MESSAGES.unableToInstantiateContextResolver(), e);
            }
        }
        if (Utils.isA(provider, ContextInjector.class, contracts)) {
            try {
                this.addContextInjector(provider);
                priority = Utils.getPriority(priorityOverride, contracts, ContextInjector.class, provider);
                newContracts.put(ContextInjector.class, priority);
            }
            catch (Exception e) {
                throw new RuntimeException(Messages.MESSAGES.unableToInstantiateContextInjector(), e);
            }
        }
        if (Utils.isA(provider, StringParameterUnmarshaller.class, contracts)) {
            this.addStringParameterUnmarshaller(provider);
            priority = Utils.getPriority(priorityOverride, contracts, StringParameterUnmarshaller.class, provider);
            newContracts.put(StringParameterUnmarshaller.class, priority);
        }
        if (Utils.isA(provider, InjectorFactory.class, contracts)) {
            try {
                this.addInjectorFactory(provider);
                newContracts.put(InjectorFactory.class, 0);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (Utils.isA(provider, Feature.class, contracts)) {
            ConstrainedTo constrainedTo = provider.getAnnotation(ConstrainedTo.class);
            int priority2 = Utils.getPriority(priorityOverride, contracts, Feature.class, provider);
            if (constrainedTo == null || constrainedTo.value() == this.getRuntimeType()) {
                this.addFeature(provider);
            }
            newContracts.put(Feature.class, priority2);
        }
        if (Utils.isA(provider, ResourceClassProcessor.class, contracts)) {
            int priority3 = Utils.getPriority(priorityOverride, contracts, ResourceClassProcessor.class, provider);
            this.addResourceClassProcessor(provider, priority3);
            newContracts.put(ResourceClassProcessor.class, priority3);
        }
        if (Utils.isA(provider, RuntimeDelegate.HeaderDelegate.class, contracts)) {
            this.addHeaderDelegate(provider);
        }
        if (Utils.isA(provider, ThreadContext.class, contracts)) {
            ResteasyContext.computeIfAbsent(ThreadContexts.class, ThreadContexts::new).add((ThreadContext)this.createProviderInstance(provider));
        }
    }

    public void addHeaderDelegate(Class provider) {
        Type[] headerTypes = Types.getActualTypeArgumentsOfAnInterface((Class)provider, RuntimeDelegate.HeaderDelegate.class);
        if (headerTypes.length == 0) {
            LogMessages.LOGGER.cannotRegisterheaderDelegate(provider);
        } else {
            Class headerClass = Types.getRawType((Type)headerTypes[0]);
            this.addHeaderDelegate((Class<? extends RuntimeDelegate.HeaderDelegate>)provider, headerClass);
        }
    }

    public ClientHelper getClientHelper() {
        return this.clientHelper;
    }

    public ServerHelper getServerHelper() {
        return this.serverHelper;
    }

    public void addHeaderDelegate(Class<? extends RuntimeDelegate.HeaderDelegate> provider, Class<?> headerClass) {
        RuntimeDelegate.HeaderDelegate delegate = this.createProviderInstance(provider);
        this.addHeaderDelegate(headerClass, delegate);
    }

    public void addFeature(Class<? extends Feature> provider) {
        Feature feature = this.injectedInstance(provider);
        if (feature.configure((FeatureContext)new FeatureContextDelegate(this))) {
            this.enabledFeatures.add(feature);
        }
    }

    public void addInjectorFactory(Class provider) throws InstantiationException, IllegalAccessException {
        this.injectorFactory = (InjectorFactory)provider.newInstance();
    }

    public void addContextInjector(Class provider) {
        this.addContextInjector((ContextInjector)this.createProviderInstance(provider), provider);
    }

    public void addContextResolver(Class provider, boolean isBuiltin, int priority) {
        this.addContextResolver((ContextResolver)this.createProviderInstance(provider), priority, provider, isBuiltin);
    }

    public void addParameterConverterProvider(Class provider, boolean isBuiltin, int priority) {
        ParamConverterProvider paramConverterProvider = (ParamConverterProvider)this.injectedInstance(provider);
        this.injectProperties(provider);
        this.copyParamConvertsIfNeeded();
        this.sortedParamConverterProviders.add(new ExtSortedKey<ParamConverterProvider>(null, paramConverterProvider, provider, priority, isBuiltin));
    }

    private void copyParamConvertsIfNeeded() {
        if (this.attachedParamConverterProviders) {
            this.sortedParamConverterProviders = Collections.synchronizedSortedSet(new TreeSet<ExtSortedKey<ParamConverterProvider>>(this.sortedParamConverterProviders));
            this.attachedParamConverterProviders = false;
        }
    }

    public void registerProviderInstance(Object provider) {
        this.registerProviderInstance(provider, null, null, false);
    }

    public void registerProviderInstance(Object provider, Map<Class<?>, Integer> contracts, Integer priorityOverride, boolean builtIn) {
        Class<?> providerClass = provider.getClass();
        Map<Class<?>, Map<Class<?>, Integer>> classContracts = this.getClassContracts();
        if (classContracts.containsKey(providerClass)) {
            LogMessages.LOGGER.providerInstanceAlreadyRegistered(providerClass.getName());
            return;
        }
        HashMap newContracts = new HashMap();
        this.processProviderInstanceContracts(provider, contracts, priorityOverride, builtIn, newContracts);
        this.providerInstances.add(provider);
        classContracts.put(providerClass, newContracts);
    }

    private void processProviderInstanceContracts(Object provider, Map<Class<?>, Integer> contracts, Integer priorityOverride, boolean builtIn, Map<Class<?>, Integer> newContracts) {
        int priority;
        this.clientHelper.processProviderInstanceContracts(provider, contracts, priorityOverride, builtIn, newContracts);
        this.serverHelper.processProviderInstanceContracts(provider, contracts, priorityOverride, builtIn, newContracts);
        if (Utils.isA(provider, ParamConverterProvider.class, contracts)) {
            this.injectProperties(provider);
            priority = Utils.getPriority(priorityOverride, contracts, ParamConverterProvider.class, provider.getClass());
            this.copyParamConvertsIfNeeded();
            this.sortedParamConverterProviders.add(new ExtSortedKey<ParamConverterProvider>(null, (ParamConverterProvider)provider, provider.getClass(), priority, builtIn));
            newContracts.put(ParamConverterProvider.class, priority);
        }
        if (Utils.isA(provider, ContextResolver.class, contracts)) {
            try {
                priority = Utils.getPriority(priorityOverride, contracts, ContextResolver.class, provider.getClass());
                this.addContextResolver((ContextResolver)provider, priority, provider.getClass(), false);
                newContracts.put(ContextResolver.class, priority);
            }
            catch (Exception e) {
                throw new RuntimeException(Messages.MESSAGES.unableToInstantiateContextResolver(), e);
            }
        }
        if (Utils.isA(provider, ContextInjector.class, contracts)) {
            try {
                this.addContextInjector((ContextInjector)provider, provider.getClass());
                priority = Utils.getPriority(priorityOverride, contracts, ContextInjector.class, provider.getClass());
                newContracts.put(ContextInjector.class, priority);
            }
            catch (Exception e) {
                throw new RuntimeException(Messages.MESSAGES.unableToInstantiateContextInjector(), e);
            }
        }
        if (Utils.isA(provider, InjectorFactory.class, contracts)) {
            this.injectorFactory = (InjectorFactory)provider;
            newContracts.put(InjectorFactory.class, 0);
        }
        if (Utils.isA(provider, Feature.class, contracts)) {
            Feature feature = (Feature)provider;
            Utils.injectProperties(this, provider.getClass(), provider);
            ConstrainedTo constrainedTo = provider.getClass().getAnnotation(ConstrainedTo.class);
            if ((constrainedTo == null || constrainedTo.value() == this.getRuntimeType()) && feature.configure((FeatureContext)new FeatureContextDelegate(this))) {
                this.enabledFeatures.add(feature);
            }
            int priority2 = Utils.getPriority(priorityOverride, contracts, Feature.class, provider.getClass());
            newContracts.put(Feature.class, priority2);
        }
        if (Utils.isA(provider, ResourceClassProcessor.class, contracts)) {
            int priority3 = Utils.getPriority(priorityOverride, contracts, ResourceClassProcessor.class, provider.getClass());
            this.addResourceClassProcessor((ResourceClassProcessor)provider, priority3);
            newContracts.put(ResourceClassProcessor.class, priority3);
        }
        if (Utils.isA(provider, RuntimeDelegate.HeaderDelegate.class, contracts)) {
            Type[] headerTypes = Types.getActualTypeArgumentsOfAnInterface(provider.getClass(), RuntimeDelegate.HeaderDelegate.class);
            if (headerTypes.length == 0) {
                LogMessages.LOGGER.cannotRegisterheaderDelegate(provider.getClass());
            } else {
                Class headerClass = Types.getRawType((Type)headerTypes[0]);
                this.addHeaderDelegate(headerClass, (RuntimeDelegate.HeaderDelegate)provider);
            }
        }
        if (Utils.isA(provider, ThreadContext.class, contracts)) {
            ResteasyContext.computeIfAbsent(ThreadContexts.class, ThreadContexts::new).add((ThreadContext)provider);
        }
    }

    public <T extends Throwable> ExceptionMapper<T> getExceptionMapper(Class<T> type) {
        Class<T> exceptionType = type;
        SortedKey<ExceptionMapper> mapper = null;
        Map<Class<?>, SortedKey<ExceptionMapper>> mappers = this.getSortedExceptionMappers();
        boolean defaultExceptionManagerEnabled = this.isDefaultExceptionManagerEnabled();
        if (mappers == null && defaultExceptionManagerEnabled) {
            return DefaultExceptionMapper.INSTANCE;
        }
        while (mapper == null && exceptionType != null) {
            mapper = mappers.get(exceptionType);
            if (mapper != null) continue;
            exceptionType = exceptionType.getSuperclass();
        }
        return mapper != null ? (ExceptionMapper)mapper.getObj() : (defaultExceptionManagerEnabled ? DefaultExceptionMapper.INSTANCE : null);
    }

    public <T extends Throwable> ExceptionMapper<T> getExceptionMapperForClass(Class<T> type) {
        Map<Class<?>, SortedKey<ExceptionMapper>> mappers = this.getSortedExceptionMappers();
        if (mappers == null) {
            return null;
        }
        SortedKey<ExceptionMapper> mapper = mappers.get(type);
        return mapper != null ? mapper.getObj() : null;
    }

    public <T> AsyncResponseProvider<T> getAsyncResponseProvider(Class<T> type) {
        Class<T> asyncType = type;
        AsyncResponseProvider mapper = null;
        while (mapper == null && asyncType != null) {
            mapper = this.findProvider(asyncType, this.getAsyncResponseProviders());
            if (mapper != null) continue;
            asyncType = asyncType.getSuperclass();
        }
        return mapper;
    }

    public <T> AsyncClientResponseProvider<T> getAsyncClientResponseProvider(Class<T> type) {
        Class<T> asyncType = type;
        AsyncClientResponseProvider mapper = null;
        while (mapper == null && asyncType != null) {
            mapper = this.findProvider(asyncType, this.getAsyncClientResponseProviders());
            if (mapper != null) continue;
            asyncType = asyncType.getSuperclass();
        }
        return mapper;
    }

    public <T> AsyncStreamProvider<T> getAsyncStreamProvider(Class<T> type) {
        Class<T> asyncType = type;
        AsyncStreamProvider mapper = null;
        while (mapper == null && asyncType != null) {
            mapper = this.findProvider(asyncType, this.getAsyncStreamProviders());
            if (mapper != null) continue;
            asyncType = asyncType.getSuperclass();
        }
        return mapper;
    }

    public MediaType getConcreteMediaTypeFromMessageBodyWriters(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        List<SortedKey<MessageBodyWriter>> writers = this.getServerMessageBodyWriters().getPossible(mediaType, type);
        for (SortedKey<MessageBodyWriter> writer : writers) {
            Produces produces;
            MessageBodyWriter mbw;
            Class writerType;
            if (!writer.getObj().isWriteable(type, genericType, annotations, mediaType) || (writerType = Types.getTemplateParameterOfInterface((Class)(mbw = writer.getObj()).getClass(), MessageBodyWriter.class)) == null || writerType.equals(Object.class) || !writerType.isAssignableFrom(type) || (produces = mbw.getClass().getAnnotation(Produces.class)) == null) continue;
            for (String produce : produces.value()) {
                MediaType mt = MediaType.valueOf((String)produce);
                if (mt.isWildcardType() || mt.isWildcardSubtype()) continue;
                return mt;
            }
        }
        return null;
    }

    public Map<MessageBodyWriter<?>, Class<?>> getPossibleMessageBodyWritersMap(Class type, Type genericType, Annotation[] annotations, MediaType accept) {
        HashMap map = new HashMap();
        MediaTypeMap<SortedKey<MessageBodyWriter>> serverMessageBodyWriters = this.getServerMessageBodyWriters();
        if (serverMessageBodyWriters == null) {
            return map;
        }
        List<SortedKey<MessageBodyWriter>> writers = serverMessageBodyWriters.getPossible(accept, type);
        for (SortedKey<MessageBodyWriter> writer : writers) {
            Class writerType;
            if (!writer.getObj().isWriteable(type, genericType, annotations, accept)) continue;
            Class mbwc = writer.getObj().getClass();
            if (!mbwc.isInterface() && mbwc.getSuperclass() != null && !mbwc.getSuperclass().equals(Object.class) && mbwc.isSynthetic()) {
                mbwc = mbwc.getSuperclass();
            }
            if ((writerType = Types.getTemplateParameterOfInterface((Class)mbwc, MessageBodyWriter.class)) == null || !writerType.isAssignableFrom(type)) continue;
            map.put(writer.getObj(), writerType);
        }
        return map;
    }

    @Deprecated
    public <T> MessageBodyWriter<T> getServerMessageBodyWriter(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        MediaTypeMap<SortedKey<MessageBodyWriter>> availableWriters = this.getServerMessageBodyWriters();
        return this.resolveMessageBodyWriter(type, genericType, annotations, mediaType, availableWriters);
    }

    public <T> MessageBodyWriter<T> getServerMessageBodyWriter(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType, RESTEasyTracingLogger tracingLogger) {
        MediaTypeMap<SortedKey<MessageBodyWriter>> availableWriters = this.getServerMessageBodyWriters();
        return this.resolveMessageBodyWriter(type, genericType, annotations, mediaType, availableWriters, tracingLogger);
    }

    public <T> MessageBodyWriter<T> getMessageBodyWriter(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        MediaTypeMap<SortedKey<MessageBodyWriter>> availableWriters = this.getServerMessageBodyWriters();
        MessageBodyWriter<T> writer = this.resolveMessageBodyWriter(type, genericType, annotations, mediaType, availableWriters);
        if (writer != null) {
            LogMessages.LOGGER.debugf("MessageBodyWriter: %s", (Object)writer.getClass().getName());
        }
        return writer;
    }

    public <T> MessageBodyWriter<T> getClientMessageBodyWriter(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        MediaTypeMap<SortedKey<MessageBodyWriter>> availableWriters = this.getClientMessageBodyWriters();
        return this.resolveMessageBodyWriter(type, genericType, annotations, mediaType, availableWriters);
    }

    private <T> T findProvider(Class asyncType, Map<Class<?>, T> asyncResponseProviders) {
        if (asyncResponseProviders != null) {
            for (Class<?> aClass : asyncResponseProviders.keySet()) {
                if (!aClass.isAssignableFrom(asyncType)) continue;
                return asyncResponseProviders.get(aClass);
            }
        }
        return null;
    }

    @Deprecated
    private <T> MessageBodyWriter<T> resolveMessageBodyWriter(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType, MediaTypeMap<SortedKey<MessageBodyWriter>> availableWriters) {
        if (availableWriters == null) {
            return null;
        }
        List<SortedKey<MessageBodyWriter>> writers = availableWriters.getPossible(mediaType, type);
        for (SortedKey<MessageBodyWriter> writer : writers) {
            if (!writer.getObj().isWriteable(type, genericType, annotations, mediaType)) continue;
            LogMessages.LOGGER.debugf("MessageBodyWriter: %s", (Object)writer.getClass().getName());
            return writer.getObj();
        }
        return null;
    }

    private <T> MessageBodyWriter<T> resolveMessageBodyWriter(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType, MediaTypeMap<SortedKey<MessageBodyWriter>> availableWriters, RESTEasyTracingLogger tracingLogger) {
        SortedKey<MessageBodyWriter> writer;
        if (availableWriters == null) {
            return null;
        }
        List<SortedKey<MessageBodyWriter>> writers = availableWriters.getPossible(mediaType, type);
        if (tracingLogger.isLogEnabled("MBW_FIND")) {
            tracingLogger.log("MBW_FIND", type.getName(), genericType instanceof Class ? ((Class)genericType).getName() : genericType, mediaType, Arrays.toString(annotations));
        }
        MessageBodyWriter result = null;
        Iterator<SortedKey<MessageBodyWriter>> iterator = writers.iterator();
        while (iterator.hasNext()) {
            writer = iterator.next();
            if (writer.getObj().isWriteable(type, genericType, annotations, mediaType)) {
                LogMessages.LOGGER.debugf("MessageBodyWriter: %s", (Object)writer.getClass().getName());
                result = writer.getObj();
                tracingLogger.log("MBW_SELECTED", result);
                break;
            }
            tracingLogger.log("MBW_NOT_WRITEABLE", result);
        }
        if (tracingLogger.isLogEnabled("MBW_SKIPPED")) {
            while (iterator.hasNext()) {
                writer = iterator.next();
                tracingLogger.log("MBW_SKIPPED", writer.getObj());
            }
        }
        return result;
    }

    public <T> T createEndpoint(Application applicationConfig, Class<T> endpointType) throws IllegalArgumentException, UnsupportedOperationException {
        if (applicationConfig == null) {
            throw new IllegalArgumentException(Messages.MESSAGES.applicationParamNull());
        }
        throw new UnsupportedOperationException();
    }

    public <T> ContextResolver<T> getContextResolver(Class<T> contextType, MediaType mediaType) {
        final List<ContextResolver> resolvers = this.getContextResolvers(contextType, mediaType);
        if (resolvers == null) {
            return null;
        }
        if (resolvers.size() == 1) {
            return resolvers.get(0);
        }
        return new ContextResolver<T>(){

            public T getContext(Class type) {
                for (ContextResolver resolver : resolvers) {
                    Object rtn = resolver.getContext(type);
                    if (rtn == null) continue;
                    return rtn;
                }
                return null;
            }
        };
    }

    public <T> T createProviderInstance(Class<? extends T> clazz) {
        return Utils.createProviderInstance(this, clazz);
    }

    public <T> T injectedInstance(Class<? extends T> clazz) {
        Constructor constructor = PickConstructor.pickSingletonConstructor(clazz);
        ConstructorInjector constructorInjector = this.getInjectorFactory().createConstructor(constructor, (ResteasyProviderFactory)this);
        Object obj = constructorInjector.construct(false);
        PropertyInjector propertyInjector = this.getInjectorFactory().createPropertyInjector(clazz, (ResteasyProviderFactory)this);
        if (obj instanceof CompletionStage) {
            CompletionStage stage = (CompletionStage)obj;
            return stage.thenCompose(target -> {
                CompletionStage propertyStage = propertyInjector.inject(target, false);
                if (propertyStage != null) {
                    return propertyStage.thenApply(v -> target);
                }
                return CompletableFuture.completedFuture(target);
            }).toCompletableFuture().getNow(null);
        }
        CompletionStage propertyStage = propertyInjector.inject(obj, false);
        if (propertyStage == null) {
            return (T)obj;
        }
        return propertyStage.thenApply(v -> obj).toCompletableFuture().getNow(null);
    }

    public <T> T injectedInstance(Class<? extends T> clazz, HttpRequest request, HttpResponse response) {
        PropertyInjector propertyInjector;
        CompletionStage propertyStage;
        Constructor constructor = PickConstructor.pickSingletonConstructor(clazz);
        Object obj = null;
        if (constructor == null) {
            throw new IllegalArgumentException(Messages.MESSAGES.unableToFindPublicConstructorForClass(clazz.getName()));
        }
        ConstructorInjector constructorInjector = this.getInjectorFactory().createConstructor(constructor, (ResteasyProviderFactory)this);
        obj = constructorInjector.construct(request, response, false);
        if (obj instanceof CompletionStage) {
            obj = ((CompletionStage)obj).toCompletableFuture().getNow(null);
        }
        if ((propertyStage = (propertyInjector = this.getInjectorFactory().createPropertyInjector(clazz, (ResteasyProviderFactory)this)).inject(request, response, obj, false)) != null) {
            propertyStage.toCompletableFuture().getNow(null);
        }
        return (T)obj;
    }

    public Map<String, Object> getMutableProperties() {
        return this.properties;
    }

    public Map<String, Object> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public Object getProperty(String name) {
        return this.properties.get(name);
    }

    public ResteasyProviderFactory setProperties(Map<String, Object> properties) {
        this.properties = new SnapshotMap<String, Object>(properties, false, this.lockSnapshots, false);
        return this;
    }

    public ResteasyProviderFactory property(String name, Object value) {
        if (value == null) {
            this.properties.remove(name);
        } else {
            this.properties.put(name, value);
        }
        return this;
    }

    public Collection<Feature> getEnabledFeatures() {
        return Collections.unmodifiableSet(this.enabledFeatures);
    }

    public ResteasyProviderFactory register(Class<?> providerClass) {
        this.registerProvider(providerClass);
        return this;
    }

    public ResteasyProviderFactory register(Object provider) {
        this.registerProviderInstance(provider);
        return this;
    }

    public ResteasyProviderFactory register(Class<?> componentClass, int priority) {
        this.registerProvider(componentClass, priority, false, null);
        return this;
    }

    public ResteasyProviderFactory register(Class<?> componentClass, Class<?> ... contracts) {
        if (contracts == null || contracts.length == 0) {
            LogMessages.LOGGER.attemptingToRegisterEmptyContracts(componentClass.getName());
            return this;
        }
        HashMap cons = new HashMap();
        for (Class<?> contract : contracts) {
            if (!contract.isAssignableFrom(componentClass)) {
                LogMessages.LOGGER.attemptingToRegisterUnassignableContract(componentClass.getName());
                return this;
            }
            cons.put(contract, 5000);
        }
        this.registerProvider(componentClass, null, false, cons);
        return this;
    }

    public ResteasyProviderFactory register(Object component, int priority) {
        this.registerProviderInstance(component, null, priority, false);
        return this;
    }

    public ResteasyProviderFactory register(Object component, Class<?> ... contracts) {
        if (contracts == null || contracts.length == 0) {
            LogMessages.LOGGER.attemptingToRegisterEmptyContracts(component.getClass().getName());
            return this;
        }
        HashMap cons = new HashMap();
        for (Class<?> contract : contracts) {
            if (!contract.isAssignableFrom(component.getClass())) {
                LogMessages.LOGGER.attemptingToRegisterUnassignableContract(component.getClass().getName());
                return this;
            }
            cons.put(contract, 5000);
        }
        this.registerProviderInstance(component, cons, null, false);
        return this;
    }

    public ResteasyProviderFactory register(Class<?> componentClass, Map<Class<?>, Integer> contracts) {
        for (Class<?> contract : contracts.keySet()) {
            if (contract.isAssignableFrom(componentClass)) continue;
            LogMessages.LOGGER.attemptingToRegisterUnassignableContract(componentClass.getName());
            return this;
        }
        this.registerProvider(componentClass, null, false, contracts);
        return this;
    }

    public ResteasyProviderFactory register(Object component, Map<Class<?>, Integer> contracts) {
        for (Class<?> contract : contracts.keySet()) {
            if (contract.isAssignableFrom(component.getClass())) continue;
            LogMessages.LOGGER.attemptingToRegisterUnassignableContract(component.getClass().getName());
            return this;
        }
        this.registerProviderInstance(component, contracts, null, false);
        return this;
    }

    public Configuration getConfiguration() {
        return this;
    }

    public RuntimeType getRuntimeType() {
        return RuntimeType.SERVER;
    }

    public Collection<String> getPropertyNames() {
        return this.getProperties().keySet();
    }

    public boolean isEnabled(Feature feature) {
        return this.getEnabledFeatures().contains(feature);
    }

    public boolean isEnabled(Class<? extends Feature> featureClass) {
        Collection<Feature> enabled = this.getEnabledFeatures();
        if (enabled == null) {
            return false;
        }
        for (Feature feature : enabled) {
            if (!featureClass.equals(feature.getClass())) continue;
            return true;
        }
        return false;
    }

    public boolean isRegistered(Object component) {
        return this.getProviderInstances().contains(component);
    }

    public boolean isRegistered(Class<?> componentClass) {
        return this.getClassContracts().containsKey(componentClass);
    }

    public Map<Class<?>, Integer> getContracts(Class<?> componentClass) {
        Map<Class<?>, Integer> classIntegerMap = this.classContracts.get(componentClass);
        if (classIntegerMap == null) {
            return Collections.emptyMap();
        }
        return classIntegerMap;
    }

    public Set<Class<?>> getClasses() {
        Set<Class<?>> providerClasses = this.getProviderClasses();
        return providerClasses == null || providerClasses.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(providerClasses);
    }

    public Set<Object> getInstances() {
        Set<Object> providerInstances = this.getProviderInstances();
        return providerInstances == null || providerInstances.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(providerInstances);
    }

    public Link.Builder createLinkBuilder() {
        return Utils.createLinkBuilder();
    }

    public boolean hasProperty(String name) {
        return this.properties.containsKey(name);
    }

    public SeBootstrap.Configuration.Builder createConfigurationBuilder() {
        return ResteasySeConfiguration.builder();
    }

    public CompletionStage<SeBootstrap.Instance> bootstrap(Application application, SeBootstrap.Configuration configuration) {
        return ResteasySeInstance.create(Objects.requireNonNull(application, Messages.MESSAGES.nullParameter("application")), configuration);
    }

    public CompletionStage<SeBootstrap.Instance> bootstrap(Class<? extends Application> clazz, SeBootstrap.Configuration configuration) {
        return ResteasySeInstance.create(Objects.requireNonNull(clazz, Messages.MESSAGES.nullParameter("clazz")), configuration);
    }

    public EntityPart.Builder createEntityPartBuilder(String partName) throws IllegalArgumentException {
        if (partName == null) {
            throw new IllegalArgumentException(Messages.MESSAGES.nullParameter("partName"));
        }
        Function<Class, EntityPart.Builder> constructor = builderClass -> {
            try {
                Constructor c = builderClass.getConstructor(String.class);
                return (EntityPart.Builder)c.newInstance(partName);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw Messages.MESSAGES.failedToConstructClass((Throwable)e, builderClass);
            }
        };
        Optional found = System.getSecurityManager() == null ? PriorityServiceLoader.load(EntityPart.Builder.class, constructor).first() : AccessController.doPrivileged(() -> PriorityServiceLoader.load(EntityPart.Builder.class, (Function)constructor).first());
        return (EntityPart.Builder)found.orElseThrow(() -> Messages.MESSAGES.noImplementationFound(EntityPart.Builder.class.getName()));
    }

    public <I extends RxInvoker> RxInvokerProvider<I> getRxInvokerProvider(Class<I> clazz) {
        for (Map.Entry<Class<?>, Map<Class<?>, Integer>> entry : this.classContracts.entrySet()) {
            RxInvokerProvider rip;
            if (!entry.getValue().containsKey(RxInvokerProvider.class) || !(rip = (RxInvokerProvider)this.createProviderInstance(entry.getKey())).isProviderFor(clazz)) continue;
            return rip;
        }
        return null;
    }

    public RxInvokerProvider<?> getRxInvokerProviderFromReactiveClass(Class<?> clazz) {
        return this.clientHelper.getRxInvokerProviderFromReactiveClass(clazz);
    }

    public boolean isReactive(Class<?> clazz) {
        return this.clientHelper.isReactive(clazz);
    }

    public void addResourceClassProcessor(Class<ResourceClassProcessor> processorClass, int priority) {
        ResourceClassProcessor processor = this.createProviderInstance(processorClass);
        this.addResourceClassProcessor(processor, priority);
    }

    private void addResourceClassProcessor(ResourceClassProcessor processor, int priority) {
        this.resourceBuilder.registerResourceClassProcessor(processor, priority);
    }

    public ResourceBuilder getResourceBuilder() {
        return this.resourceBuilder;
    }

    public <T> T getContextData(Class<T> type) {
        return ResteasyContext.getContextData(type);
    }

    public void initializeClientProviders(ResteasyProviderFactory factory) {
        this.clientHelper.initializeClientProviders(factory);
    }

    public void injectProperties(Object obj) {
        Utils.injectProperties(this, obj);
    }

    public void injectProperties(Object obj, HttpRequest request, HttpResponse response) {
        Utils.injectProperties(this, obj, request, response);
    }

    public StatisticsController getStatisticsController() {
        return this.statisticsController;
    }

    public ExceptionMapper<Throwable> getThrowableExceptionMapper() {
        DefaultExceptionMapper result = this.getExceptionMapperForClass(Throwable.class);
        return result != null ? result : DefaultExceptionMapper.INSTANCE;
    }

    protected boolean isOnServer() {
        return ResteasyContext.searchContextData(Dispatcher.class) != null;
    }

    public boolean isDefaultExceptionManagerEnabled() {
        return this.defaultExceptionManagerEnabled;
    }

    private static <T> T getOptionValue(Options<T> option) {
        if (System.getSecurityManager() == null) {
            return (T)option.getValue();
        }
        return (T)AccessController.doPrivileged(() -> option.getValue());
    }
}

