/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.sse;

import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.sse.OutboundSseEvent;
import jakarta.ws.rs.sse.SseEventSink;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.lang.annotation.Annotation;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.logging.Logger;
import org.jboss.resteasy.annotations.SseElementType;
import org.jboss.resteasy.annotations.Stream;
import org.jboss.resteasy.core.ResourceMethodInvoker;
import org.jboss.resteasy.core.ResteasyContext;
import org.jboss.resteasy.core.ServerResponseWriter;
import org.jboss.resteasy.core.SynchronousDispatcher;
import org.jboss.resteasy.plugins.providers.sse.OutboundSseEventImpl;
import org.jboss.resteasy.plugins.providers.sse.SseConstants;
import org.jboss.resteasy.plugins.server.Cleanable;
import org.jboss.resteasy.plugins.server.Cleanables;
import org.jboss.resteasy.resteasy_jaxrs.i18n.LogMessages;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.specimpl.BuiltResponse;
import org.jboss.resteasy.spi.AsyncOutputStream;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.ResteasyAsynchronousContext;
import org.jboss.resteasy.spi.ResteasyAsynchronousResponse;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.spi.config.Options;
import org.jboss.resteasy.spi.util.FindAnnotation;

public class SseEventOutputImpl
extends GenericType<OutboundSseEvent>
implements SseEventSink {
    private static final Logger LOG = Logger.getLogger(SseEventOutputImpl.class);
    private static final int READY = 0;
    private static final int PROCESSING = 1;
    private static final int PASSTHROUGH = 2;
    private static final int CLOSED = 3;
    private final MessageBodyWriter<OutboundSseEvent> writer;
    private final ResteasyAsynchronousContext asyncContext;
    private final HttpResponse response;
    private final HttpRequest request;
    private final Map<Class<?>, Object> contextDataMap;
    private volatile boolean responseFlushed = false;
    private final Object lock;
    private final ResteasyProviderFactory providerFactory;
    private final AtomicInteger state;
    private final Deque<FutureEvent> events;

    @Deprecated
    public SseEventOutputImpl(MessageBodyWriter<OutboundSseEvent> writer) {
        this(writer, ResteasyProviderFactory.getInstance());
    }

    public SseEventOutputImpl(MessageBodyWriter<OutboundSseEvent> writer, ResteasyProviderFactory providerFactory) {
        this.writer = writer;
        this.contextDataMap = ResteasyContext.getContextDataMap();
        this.providerFactory = providerFactory;
        this.request = ResteasyContext.getRequiredContextData(HttpRequest.class);
        this.asyncContext = this.request.getAsyncContext();
        if (!this.asyncContext.isSuspended()) {
            try {
                this.asyncContext.suspend();
            }
            catch (IllegalStateException ex) {
                LogMessages.LOGGER.failedToSetRequestAsync();
            }
        }
        this.response = ResteasyContext.getRequiredContextData(HttpResponse.class);
        try {
            this.lock = this.response.getAsyncOutputStream();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        this.state = new AtomicInteger(0);
        this.events = new ConcurrentLinkedDeque<FutureEvent>();
    }

    public void close() {
        this.close(true, null);
    }

    @Deprecated
    protected void close(boolean flushBeforeClose) {
        this.close(flushBeforeClose, null);
    }

    public void clearContextData() {
        Cleanables cleanables;
        Map<Class<?>, Object> map = ResteasyContext.getContextDataMap(false);
        Cleanables cleanables2 = cleanables = map != null ? (Cleanables)map.get(Cleanables.class) : null;
        if (cleanables != null) {
            Iterator<Cleanable> it = cleanables.getCleanables().iterator();
            while (it.hasNext()) {
                try {
                    it.next().clean();
                }
                catch (Exception exception) {}
            }
            ResteasyContext.clearContextData();
        }
    }

    protected void flushResponseToClient() {
        this.internalFlushResponseToClient(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletionStage<Void> internalFlushResponseToClient(boolean throwIOException) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.responseFlushed) {
                BuiltResponse jaxrsResponse = this.createResponse();
                try {
                    CompletableFuture<Void> ret = new CompletableFuture<Void>();
                    ServerResponseWriter.writeNomapResponse(jaxrsResponse, this.request, this.response, this.providerFactory, t -> {
                        AsyncOutputStream aos;
                        try {
                            aos = this.response.getAsyncOutputStream();
                        }
                        catch (IOException x) {
                            this.close(false, x);
                            ret.completeExceptionally(x);
                            return;
                        }
                        CompletionStage a = aos.asyncWrite(SseConstants.DOUBLE_EOL).thenCompose(v -> aos.asyncFlush());
                        this.responseFlushed = true;
                        a.thenAccept(v -> ret.complete(null)).exceptionally(e -> {
                            if (e instanceof CompletionException) {
                                e = e.getCause();
                            }
                            if (e instanceof IOException) {
                                this.close(false, (Throwable)e);
                            }
                            if (throwIOException) {
                                ret.completeExceptionally((Throwable)e);
                            } else {
                                ret.completeExceptionally((Throwable)new ProcessingException(Messages.MESSAGES.failedToCreateSseEventOutput(), e));
                            }
                            return null;
                        });
                    }, true);
                    return ret;
                }
                catch (IOException e) {
                    this.close(false, e);
                    CompletableFuture<Void> ret = new CompletableFuture<Void>();
                    if (throwIOException) {
                        ret.completeExceptionally(e);
                    } else {
                        ret.completeExceptionally((Throwable)new ProcessingException(Messages.MESSAGES.failedToCreateSseEventOutput(), (Throwable)e));
                    }
                    return ret;
                }
            }
        }
        return CompletableFuture.completedFuture(null);
    }

    public boolean isClosed() {
        return this.state.get() == 3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletionStage<?> send(OutboundSseEvent event) {
        int state = this.state.get();
        if (state == 3) {
            throw new IllegalStateException(Messages.MESSAGES.sseEventSinkIsClosed());
        }
        if (state == 2) {
            Object object = this.lock;
            synchronized (object) {
                return this.internalWriteEvent(event);
            }
        }
        if (state == 1) {
            FutureEvent futureEvent = new FutureEvent(event);
            this.events.addLast(futureEvent);
            return futureEvent.future.thenRun(this::drainQueue);
        }
        FutureEvent futureEvent = new FutureEvent(event);
        this.events.addLast(futureEvent);
        return this.internalFlushResponseToClient(true).thenRun(this::drainQueue).exceptionally(e -> {
            if (e instanceof CompletionException) {
                e = e.getCause();
            }
            if (e instanceof IOException) {
                this.close(false, (Throwable)e);
            }
            LogMessages.LOGGER.failedToWriteSseEvent(event.toString(), e);
            SynchronousDispatcher.rethrow(e);
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    protected CompletionStage<Void> writeEvent(OutboundSseEvent event) {
        Object object = this.lock;
        synchronized (object) {
            return this.internalWriteEvent(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CompletionStage<Void> internalWriteEvent(OutboundSseEvent event) {
        Object object = this.lock;
        synchronized (object) {
            try (ResteasyContext.CloseableContext c = ResteasyContext.addCloseableContextDataLevel(this.contextDataMap);){
                Object o;
                boolean mediaTypeSet;
                if (event == null) return CompletableFuture.completedFuture(null);
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                MediaType mediaType = event.getMediaType();
                boolean bl = mediaTypeSet = !(event instanceof OutboundSseEventImpl) || ((OutboundSseEventImpl)event).isMediaTypeSet();
                if (!(mediaType != null && mediaTypeSet || (o = this.response.getOutputHeaders().getFirst((Object)"Content-Type")) == null)) {
                    if (o instanceof MediaType) {
                        mt = (MediaType)o;
                        String s = (String)mt.getParameters().get("element-type");
                        if (s != null) {
                            mediaType = MediaType.valueOf((String)s);
                        }
                    } else {
                        if (!(o instanceof String)) throw new RuntimeException(Messages.MESSAGES.expectedStringOrMediaType(o));
                        mt = MediaType.valueOf((String)((String)o));
                        String s = (String)mt.getParameters().get("element-type");
                        if (s != null) {
                            mediaType = MediaType.valueOf((String)s);
                        }
                    }
                }
                if (mediaType == null) {
                    mediaType = MediaType.TEXT_PLAIN_TYPE;
                }
                if (event instanceof OutboundSseEventImpl) {
                    ((OutboundSseEventImpl)event).setMediaType(mediaType);
                }
                this.writer.writeTo((Object)event, event.getClass(), null, new Annotation[0], mediaType, null, (OutputStream)bout);
                AsyncOutputStream aos = this.response.getAsyncOutputStream();
                CompletionStage<Void> completionStage = aos.asyncWrite(bout.toByteArray()).thenCompose(v -> aos.asyncFlush()).exceptionally(e -> {
                    if (e instanceof CompletionException) {
                        e = e.getCause();
                    }
                    if (e instanceof IOException) {
                        this.close(false, (Throwable)e);
                    }
                    LogMessages.LOGGER.failedToWriteSseEvent(event.toString(), e);
                    SynchronousDispatcher.rethrow(e);
                    return null;
                });
                return completionStage;
            }
            catch (IOException e2) {
                this.close(false, e2);
                LogMessages.LOGGER.failedToWriteSseEvent(event.toString(), (Throwable)e2);
                CompletableFuture<Void> ret = new CompletableFuture<Void>();
                ret.completeExceptionally(e2);
                return ret;
            }
            catch (Exception e3) {
                LogMessages.LOGGER.failedToWriteSseEvent(event.toString(), (Throwable)e3);
                CompletableFuture<Void> ret = new CompletableFuture<Void>();
                ret.completeExceptionally((Throwable)new ProcessingException((Throwable)e3));
                return ret;
            }
        }
    }

    private BuiltResponse createResponse() {
        BuiltResponse jaxrsResponse;
        int responseCode = this.state.get() == 3 ? (Integer)Options.SSE_CLOSED_RESPONSE_CODE.getValue() : 200;
        ResourceMethodInvoker method = (ResourceMethodInvoker)this.request.getAttribute(ResourceMethodInvoker.class.getName());
        MediaType[] mediaTypes = method.getProduces();
        if (mediaTypes != null && this.getSseEventType(mediaTypes) != null) {
            SseElementType sseElementType = (SseElementType)FindAnnotation.findAnnotation((Annotation[])method.getMethodAnnotations(), SseElementType.class);
            if (sseElementType != null) {
                HashMap<String, String> parameterMap = new HashMap<String, String>();
                parameterMap.put("element-type", sseElementType.value());
                MediaType mediaType = new MediaType(MediaType.SERVER_SENT_EVENTS_TYPE.getType(), MediaType.SERVER_SENT_EVENTS_TYPE.getSubtype(), parameterMap);
                jaxrsResponse = (BuiltResponse)Response.status((int)responseCode).type(mediaType).build();
            } else {
                jaxrsResponse = (BuiltResponse)Response.status((int)responseCode).type(this.getSseEventType(mediaTypes)).build();
            }
        } else {
            Stream stream = (Stream)FindAnnotation.findAnnotation((Annotation[])method.getMethodAnnotations(), Stream.class);
            if (stream != null) {
                jaxrsResponse = (BuiltResponse)Response.ok((Object)"").build();
                MediaType elementType = ServerResponseWriter.getResponseMediaType(jaxrsResponse, this.request, this.response, this.providerFactory, method);
                HashMap<String, String> parameterMap = new HashMap<String, String>();
                parameterMap.put("element-type", elementType.toString());
                String[] streamType = this.getStreamType(method);
                MediaType mediaType = new MediaType(streamType[0], streamType[1], parameterMap);
                jaxrsResponse = (BuiltResponse)Response.status((int)responseCode).type(mediaType).build();
            } else {
                throw new RuntimeException(Messages.MESSAGES.expectedStreamOrSseMediaType());
            }
        }
        return jaxrsResponse;
    }

    private String[] getStreamType(ResourceMethodInvoker method) {
        Stream.MODE mode;
        Stream stream = (Stream)FindAnnotation.findAnnotation((Annotation[])method.getMethodAnnotations(), Stream.class);
        Stream.MODE mODE = mode = stream != null ? stream.value() : null;
        if (mode == null) {
            return new String[]{"text", "event-stream"};
        }
        if (Stream.MODE.GENERAL.equals((Object)mode)) {
            return new String[]{"application", "x-stream-general"};
        }
        if (Stream.MODE.RAW.equals((Object)mode)) {
            return new String[]{"application", "x-stream-raw"};
        }
        throw new RuntimeException(Messages.MESSAGES.expectedStreamModeGeneralOrRaw(mode));
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public int hashCode() {
        return super.hashCode();
    }

    private MediaType getSseEventType(MediaType[] mediaTypes) {
        for (MediaType type : mediaTypes) {
            if (!type.getType().equalsIgnoreCase(MediaType.SERVER_SENT_EVENTS_TYPE.getType()) || !type.getSubtype().equalsIgnoreCase(MediaType.SERVER_SENT_EVENTS_TYPE.getSubtype())) continue;
            return type;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close(boolean flushBeforeClose, Throwable error) {
        if (this.state.getAndSet(3) != 3) {
            block20: {
                ResteasyAsynchronousResponse asyncResponse;
                if (error != null) {
                    this.drainQueue(error);
                }
                if (flushBeforeClose && this.responseFlushed) {
                    try {
                        c = ResteasyContext.addCloseableContextDataLevel(this.contextDataMap);
                        try {
                            AsyncOutputStream aos = this.response.getAsyncOutputStream();
                            ((CompletableFuture)aos.asyncFlush().toCompletableFuture().thenRun(() -> this.drainQueue(null))).get();
                        }
                        finally {
                            if (c != null) {
                                c.close();
                            }
                        }
                    }
                    catch (IOException | InterruptedException | ExecutionException c) {}
                } else {
                    c = this.lock;
                    synchronized (c) {
                        this.events.clear();
                    }
                }
                if (this.asyncContext.isSuspended() && (asyncResponse = this.asyncContext.getAsyncResponse()) != null) {
                    try {
                        asyncResponse.complete();
                    }
                    catch (RuntimeException x) {
                        Throwable cause;
                        for (cause = x; cause.getCause() != null && cause.getCause() != cause; cause = cause.getCause()) {
                        }
                        if (cause instanceof IOException) break block20;
                        LOG.debug((Object)cause.getMessage());
                        return;
                    }
                }
            }
            this.clearContextData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drainQueue() {
        this.state.compareAndSet(0, 1);
        Object object = this.lock;
        synchronized (object) {
            this.drainQueue(null);
        }
        object = this.lock;
        synchronized (object) {
            if (this.state.compareAndSet(1, 2)) {
                this.drainQueue(null);
            }
        }
    }

    private void drainQueue(Throwable throwable) {
        FutureEvent event;
        AtomicReference<Object> thrown = new AtomicReference<Object>(null);
        while ((event = this.events.pollFirst()) != null) {
            Throwable t;
            Throwable throwable2 = t = throwable == null ? (Throwable)thrown.get() : throwable;
            if (t != null) {
                event.future.completeExceptionally(t);
                continue;
            }
            OutboundSseEvent e = event.event;
            CompletableFuture<Void> future = event.future;
            this.internalWriteEvent(e).thenRun(() -> future.complete(null)).exceptionally(error -> {
                LOG.debugf("Failed to process event %s - %s", (Object)future, (Object)e);
                thrown.set(error);
                future.completeExceptionally((Throwable)error);
                SynchronousDispatcher.rethrow(error);
                return null;
            });
        }
    }

    private static class FutureEvent {
        final CompletableFuture<Void> future;
        final OutboundSseEvent event;

        private FutureEvent(OutboundSseEvent event) {
            this.event = event;
            this.future = new CompletableFuture();
        }
    }
}

