/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.ext.Providers;
import org.jboss.resteasy.core.ThreadLocalResteasyProviderFactory;
import org.jboss.resteasy.plugins.interceptors.encoding.AcceptEncodingGZIPFilter;
import org.jboss.resteasy.plugins.interceptors.encoding.GZIPDecodingInterceptor;
import org.jboss.resteasy.plugins.interceptors.encoding.GZIPEncodingInterceptor;
import org.jboss.resteasy.resteasy_jaxrs.i18n.LogMessages;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public class RegisterBuiltin {
    public static void register(ResteasyProviderFactory factory) {
        RegisterBuiltin.register(factory, Collections.emptySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(ResteasyProviderFactory factory, Set<String> disabledProviders) {
        ResteasyProviderFactory monitor;
        ResteasyProviderFactory resteasyProviderFactory = monitor = factory instanceof ThreadLocalResteasyProviderFactory ? ((ThreadLocalResteasyProviderFactory)factory).getDelegate() : factory;
        synchronized (resteasyProviderFactory) {
            if (factory.isBuiltinsRegistered() || !factory.isRegisterBuiltins()) {
                return;
            }
            try {
                RegisterBuiltin.registerProviders(factory, disabledProviders);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            factory.setBuiltinsRegistered(true);
        }
    }

    public static void registerProviders(ResteasyProviderFactory factory) throws Exception {
        RegisterBuiltin.registerProviders(factory, Collections.emptySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerProviders(ResteasyProviderFactory factory, Set<String> disabledProviders) throws Exception {
        Enumeration<URL> en = System.getSecurityManager() == null ? Thread.currentThread().getContextClassLoader().getResources("META-INF/services/" + Providers.class.getName()) : AccessController.doPrivileged(new PrivilegedExceptionAction<Enumeration<URL>>(){

            @Override
            public Enumeration<URL> run() throws IOException {
                return Thread.currentThread().getContextClassLoader().getResources("META-INF/services/" + Providers.class.getName());
            }
        });
        HashMap<String, URL> origins = new HashMap<String, URL>();
        while (en.hasMoreElements()) {
            final URL url = en.nextElement();
            try (InputStream is = System.getSecurityManager() == null ? url.openStream() : AccessController.doPrivileged(new PrivilegedExceptionAction<InputStream>(){

                @Override
                public InputStream run() throws IOException {
                    return url.openStream();
                }
            });){
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
                while ((line = reader.readLine()) != null) {
                    if ((line = line.trim()).equals("") || disabledProviders.contains(line)) continue;
                    origins.put(line, url);
                }
            }
        }
        for (Map.Entry entry : origins.entrySet()) {
            final String line = (String)entry.getKey();
            try {
                Class clazz = System.getSecurityManager() == null ? Thread.currentThread().getContextClassLoader().loadClass(line) : AccessController.doPrivileged(new PrivilegedExceptionAction<Class>(){

                    @Override
                    public Class run() throws ClassNotFoundException {
                        return Thread.currentThread().getContextClassLoader().loadClass(line);
                    }
                });
                factory.registerProvider(clazz, true);
            }
            catch (NoClassDefFoundError e) {
                LogMessages.LOGGER.noClassDefFoundErrorError(line, (URL)entry.getValue(), e);
            }
            catch (ClassNotFoundException | PrivilegedActionException ex) {
                LogMessages.LOGGER.classNotFoundException(line, (URL)entry.getValue(), ex);
            }
        }
        if (AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                String value = System.getProperty("resteasy.allowGzip");
                if ("".equals(value)) {
                    return Boolean.FALSE;
                }
                return Boolean.parseBoolean(value);
            }
        }).booleanValue()) {
            factory.registerProvider(AcceptEncodingGZIPFilter.class, true);
            factory.registerProvider(GZIPDecodingInterceptor.class, true);
            factory.registerProvider(GZIPEncodingInterceptor.class, true);
        }
    }
}

