/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.multipart;

import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.jboss.resteasy.plugins.providers.multipart.AbstractMultipartWriter;
import org.jboss.resteasy.plugins.providers.multipart.ContentIDUtils;
import org.jboss.resteasy.plugins.providers.multipart.MultipartRelatedOutput;
import org.jboss.resteasy.plugins.providers.multipart.OutputPart;

public class AbstractMultipartRelatedWriter
extends AbstractMultipartWriter {
    protected void writeRelated(MultipartRelatedOutput multipartRelatedOutput, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        for (OutputPart outputPart : multipartRelatedOutput.getParts()) {
            if (outputPart.getHeaders().get((Object)"Content-ID") != null) continue;
            outputPart.getHeaders().putSingle((Object)"Content-ID", (Object)ContentIDUtils.generateContentID());
        }
        OutputPart rootOutputPart = multipartRelatedOutput.getRootPart();
        LinkedHashMap<String, String> mediaTypeParameters = new LinkedHashMap<String, String>(mediaType.getParameters());
        if (mediaTypeParameters.containsKey("boundary")) {
            multipartRelatedOutput.setBoundary((String)mediaTypeParameters.get("boundary"));
        }
        mediaTypeParameters.put("start", (String)rootOutputPart.getHeaders().getFirst((Object)"Content-ID"));
        mediaTypeParameters.put("type", rootOutputPart.getMediaType().getType() + "/" + rootOutputPart.getMediaType().getSubtype());
        if (multipartRelatedOutput.getStartInfo() != null) {
            mediaTypeParameters.put("start-info", multipartRelatedOutput.getStartInfo());
        }
        MediaType modifiedMediaType = new MediaType(mediaType.getType(), mediaType.getSubtype(), mediaTypeParameters);
        this.write(multipartRelatedOutput, modifiedMediaType, httpHeaders, entityStream);
    }
}

