/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.springboot;

import jakarta.ws.rs.Path;
import jakarta.ws.rs.ext.Provider;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.PriorityOrdered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.ClassUtils;

public class JAXRSResourcesAndProvidersScannerPostProcessor
implements BeanFactoryPostProcessor,
PriorityOrdered {
    private static final Logger logger = LoggerFactory.getLogger(JAXRSResourcesAndProvidersScannerPostProcessor.class);
    private static final String JAXRS_SCAN_PACKAGES_PROPERTY = "resteasy.jaxrs.scan-packages";

    public int getOrder() {
        return 0;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        ConfigurableEnvironment configurableEnvironment = (ConfigurableEnvironment)beanFactory.getBean(ConfigurableEnvironment.class);
        String jaxrsScanPackages = configurableEnvironment.getProperty(JAXRS_SCAN_PACKAGES_PROPERTY);
        Set<Class<?>> provicerClasses = JAXRSResourcesAndProvidersScannerPostProcessor.findJaxrsResourcesOrProviderClasses(jaxrsScanPackages, Provider.class);
        for (Class<?> providerClazz : provicerClasses) {
            this.registerScannedBean(beanFactory, providerClazz);
        }
        Set<Class<?>> resourceClasses = JAXRSResourcesAndProvidersScannerPostProcessor.findJaxrsResourcesOrProviderClasses(jaxrsScanPackages, Path.class);
        for (Class<?> resourceClazz : resourceClasses) {
            this.registerScannedBean(beanFactory, resourceClazz);
        }
    }

    private void registerScannedBean(ConfigurableListableBeanFactory beanFactory, Class<?> clazz) {
        BeanDefinitionRegistry registry = (BeanDefinitionRegistry)beanFactory;
        GenericBeanDefinition bean = new GenericBeanDefinition();
        bean.setBeanClass(clazz);
        bean.setAutowireCandidate(true);
        bean.setScope("singleton");
        registry.registerBeanDefinition(clazz.getName(), (BeanDefinition)bean);
    }

    private static Set<Class<?>> findJaxrsResourcesOrProviderClasses(String packagesToBeScanned, Class<? extends Annotation> annotationType) {
        logger.info("Scanning classpath to find JAX-RS classes annotated with {}", annotationType);
        ClassPathScanningCandidateComponentProvider scanner = new ClassPathScanningCandidateComponentProvider(false);
        scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(annotationType));
        HashSet candidates = new HashSet();
        for (String packageToScan : packagesToBeScanned.split(",")) {
            Set candidatesSubSet = scanner.findCandidateComponents(packageToScan.trim());
            candidates.addAll(candidatesSubSet);
        }
        HashSet classes = new HashSet();
        ClassLoader classLoader = JAXRSResourcesAndProvidersScannerPostProcessor.class.getClassLoader();
        for (BeanDefinition candidate : candidates) {
            try {
                Class type = ClassUtils.forName((String)candidate.getBeanClassName(), (ClassLoader)classLoader);
                classes.add(type);
            }
            catch (ClassNotFoundException e) {
                logger.error("JAX-RS Resource/Provider could not be loaded", (Throwable)e);
            }
        }
        return classes;
    }
}

