/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.mock;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.el.ELResolver;
import javax.el.ValueExpression;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.ApplicationFactory;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.mail.internet.MimeMessage;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.transaction.UserTransaction;
import javax.validation.ConstraintViolation;
import org.jboss.seam.Component;
import org.jboss.seam.Seam;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.contexts.FacesLifecycle;
import org.jboss.seam.contexts.ServletLifecycle;
import org.jboss.seam.contexts.TestLifecycle;
import org.jboss.seam.core.Expressions;
import org.jboss.seam.core.Init;
import org.jboss.seam.core.Manager;
import org.jboss.seam.core.Validators;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.faces.Renderer;
import org.jboss.seam.init.Initialization;
import org.jboss.seam.jsf.SeamPhaseListener;
import org.jboss.seam.mail.MailSession;
import org.jboss.seam.mock.MockApplicationFactory;
import org.jboss.seam.mock.MockExternalContext;
import org.jboss.seam.mock.MockFacesContext;
import org.jboss.seam.mock.MockFacesContextFactory;
import org.jboss.seam.mock.MockFilterConfig;
import org.jboss.seam.mock.MockHttpServletRequest;
import org.jboss.seam.mock.MockHttpServletResponse;
import org.jboss.seam.mock.MockHttpSession;
import org.jboss.seam.mock.MockLifecycle;
import org.jboss.seam.mock.MockServletContext;
import org.jboss.seam.mock.MockTransport;
import org.jboss.seam.mock.ServletContextWrapper;
import org.jboss.seam.pageflow.Pageflow;
import org.jboss.seam.servlet.SeamFilter;
import org.jboss.seam.servlet.ServletSessionMap;
import org.jboss.seam.transaction.Transaction;
import org.jboss.seam.util.Naming;
import org.jboss.seam.util.Reflections;

public class AbstractSeamTest {
    private Application application;
    private ApplicationFactory applicationFactory;
    protected ServletContext servletContext;
    private static SeamPhaseListener phases;
    protected MockHttpSession session;
    private Map<String, Map> conversationViewRootAttributes;
    protected Filter seamFilter;
    private static ServletContext realServletContext;
    private static boolean started;

    protected boolean isSessionInvalid() {
        return this.session.isInvalid();
    }

    protected HttpSession getSession() {
        return this.session;
    }

    protected Object getInstance(Class clazz) {
        return Component.getInstance(clazz);
    }

    protected Object getInstance(String name) {
        return Component.getInstance(name);
    }

    protected boolean isLongRunningConversation() {
        return Manager.instance().isLongRunningConversation();
    }

    public Object lookup(String name) {
        return Contexts.lookupInStatefulContexts(name);
    }

    public void begin() {
        this.session = new MockHttpSession(this.servletContext);
        ServletLifecycle.beginSession(this.session);
    }

    public void end() {
        ServletLifecycle.endSession(this.session);
        this.session = null;
    }

    protected void startSeam() throws Exception {
        if (realServletContext == null && ServletLifecycle.getServletContext() != null) {
            realServletContext = ServletLifecycle.getServletContext();
        }
        ServletContext realContext = realServletContext;
        this.servletContext = this.createServletContext(realContext);
        ServletLifecycle.beginApplication(this.servletContext);
        FactoryFinder.setFactory((String)"javax.faces.application.ApplicationFactory", (String)MockApplicationFactory.class.getName());
        new Initialization(this.servletContext).create().init();
        ((Init)this.servletContext.getAttribute(Seam.getComponentName(Init.class))).setDebug(false);
    }

    protected ServletContext createServletContext(ServletContext realContext) {
        if (realContext != null) {
            ServletContextWrapper wrappedServletContext = new ServletContextWrapper(realContext);
            return wrappedServletContext;
        }
        MockServletContext mockServletContext = new MockServletContext();
        this.initServletContext(mockServletContext.getInitParameters());
        return mockServletContext;
    }

    protected void stopSeam() throws Exception {
        ServletLifecycle.endApplication();
    }

    protected void setupClass() throws Exception {
        this.servletContext = ServletLifecycle.getServletContext();
        this.applicationFactory = (ApplicationFactory)FactoryFinder.getFactory((String)"javax.faces.application.ApplicationFactory");
        this.application = this.applicationFactory.getApplication();
        this.conversationViewRootAttributes = new HashMap<String, Map>();
        this.seamFilter = this.createSeamFilter();
        FactoryFinder.setFactory((String)"javax.faces.context.FacesContextFactory", (String)MockFacesContextFactory.class.getName());
        for (ELResolver elResolver : this.getELResolvers()) {
            this.application.addELResolver(elResolver);
        }
    }

    protected void cleanupClass() throws Exception {
        this.seamFilter.destroy();
        this.conversationViewRootAttributes = null;
    }

    protected Filter createSeamFilter() throws ServletException {
        SeamFilter seamFilter = new SeamFilter();
        seamFilter.init(new MockFilterConfig(this.servletContext));
        return seamFilter;
    }

    public void initServletContext(Map initParams) {
    }

    protected InitialContext getInitialContext() throws NamingException {
        return Naming.getInitialContext();
    }

    protected UserTransaction getUserTransaction() throws NamingException {
        return Transaction.instance();
    }

    protected Object getField(Object object, String fieldName) {
        Field field = Reflections.getField(object.getClass(), fieldName);
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        return Reflections.getAndWrap(field, object);
    }

    protected void setField(Object object, String fieldName, Object value) {
        Field field = Reflections.getField(object.getClass(), fieldName);
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        Reflections.setAndWrap(field, object, value);
    }

    protected ELResolver[] getELResolvers() {
        return new ELResolver[0];
    }

    protected void installMockTransport() {
        Contexts.getApplicationContext().set(Seam.getComponentName(MailSession.class), new MailSession("mock").create());
    }

    static {
        realServletContext = null;
        phases = new SeamPhaseListener();
    }

    public class FacesRequest
    extends Request {
        public FacesRequest() {
        }

        public FacesRequest(String viewId) {
            this.setViewId(viewId);
        }

        public FacesRequest(String viewId, String conversationId) {
            super(conversationId);
            this.setViewId(viewId);
        }

        protected final boolean isGetRequest() {
            return false;
        }
    }

    public class NonFacesRequest
    extends Request {
        public NonFacesRequest() {
        }

        public NonFacesRequest(String viewId) {
            this.setViewId(viewId);
        }

        public NonFacesRequest(String viewId, String conversationId) {
            super(conversationId);
            this.setViewId(viewId);
        }

        protected final boolean isGetRequest() {
            return true;
        }

        protected final void applyRequestValues() throws Exception {
            throw new UnsupportedOperationException();
        }

        protected final void processValidations() throws Exception {
            throw new UnsupportedOperationException();
        }

        protected final void updateModelValues() throws Exception {
            throw new UnsupportedOperationException();
        }

        protected final void invokeApplication() throws Exception {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class Request {
        private String conversationId;
        private String outcome;
        private String action;
        private boolean validationFailed;
        private String viewId;
        private boolean renderResponseBegun;
        private boolean renderResponseComplete;
        private boolean invokeApplicationBegun;
        private boolean invokeApplicationComplete;
        private HttpServletRequest request;
        private HttpServletResponse response;
        private MockFacesContext facesContext;
        private MockExternalContext externalContext;
        private Map<String, Object> pageParameters = new HashMap<String, Object>();

        protected void setPageParameter(String name, Object value) {
            this.pageParameters.put(name, value);
        }

        protected void setParameter(String name, String value) {
            this.getParameters().put(name, new String[]{value});
        }

        protected Map<String, String[]> getParameters() {
            return ((MockHttpServletRequest)this.externalContext.getRequest()).getParameters();
        }

        protected Map<String, String[]> getHeaders() {
            return ((MockHttpServletRequest)this.externalContext.getRequest()).getHeaders();
        }

        public String getPrincipalName() {
            return "gavin";
        }

        public Set<String> getPrincipalRoles() {
            return new AbstractSet<String>(){

                @Override
                public boolean contains(Object o) {
                    return true;
                }

                @Override
                public Iterator<String> iterator() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public int size() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public List<Cookie> getCookies() {
            return Collections.EMPTY_LIST;
        }

        protected Request() {
        }

        protected Request(String conversationId) {
            this.conversationId = conversationId;
        }

        protected boolean isGetRequest() {
            return false;
        }

        protected String getViewId() {
            return this.viewId;
        }

        protected void setViewId(String viewId) {
            this.viewId = viewId;
        }

        protected void afterRestoreViewPhase() throws Exception {
        }

        protected void applyRequestValues() throws Exception {
        }

        protected void processValidations() throws Exception {
        }

        protected void updateModelValues() throws Exception {
        }

        protected void invokeApplication() throws Exception {
        }

        protected void setOutcome(String outcome) {
            this.outcome = outcome;
        }

        protected String getOutcome() {
            return this.outcome;
        }

        protected String getInvokeApplicationOutcome() {
            return this.outcome;
        }

        protected void renderResponse() throws Exception {
        }

        protected void afterRequest() {
        }

        protected void beforeRequest() {
        }

        protected String getRenderedViewId() {
            if (Init.instance().isJbpmInstalled() && Pageflow.instance().isInProcess()) {
                return Pageflow.instance().getPageViewId();
            }
            return this.getFacesContext().getViewRoot().getViewId();
        }

        protected boolean isValidationFailure() {
            return this.validationFailed;
        }

        protected FacesContext getFacesContext() {
            return this.facesContext;
        }

        protected String getConversationId() {
            return this.conversationId;
        }

        protected Object getValue(String valueExpression) {
            return AbstractSeamTest.this.application.evaluateExpressionGet((FacesContext)this.facesContext, valueExpression, Object.class);
        }

        protected void setValue(String valueExpression, Object value) {
            AbstractSeamTest.this.application.getExpressionFactory().createValueExpression(this.facesContext.getELContext(), valueExpression, Object.class).setValue(this.facesContext.getELContext(), value);
        }

        protected boolean validateValue(String valueExpression, Object value) {
            ValueExpression ve = AbstractSeamTest.this.application.getExpressionFactory().createValueExpression(this.facesContext.getELContext(), valueExpression, Object.class);
            Set<ConstraintViolation<Object>> ivs = Validators.instance().validate(ve, this.facesContext.getELContext(), value);
            if (ivs.size() > 0) {
                this.validationFailed = true;
                String message = ivs.iterator().next().getMessage();
                this.facesContext.addMessage(null, FacesMessages.createFacesMessage(FacesMessage.SEVERITY_ERROR, message, new Object[0]));
                return false;
            }
            return true;
        }

        protected void onException(Exception e) {
            throw new AssertionError((Object)e);
        }

        protected Object invokeMethod(String methodExpression) {
            return AbstractSeamTest.this.application.getExpressionFactory().createMethodExpression(this.facesContext.getELContext(), methodExpression, Object.class, new Class[0]).invoke(this.facesContext.getELContext(), null);
        }

        protected Object invokeAction(String actionMethodExpression) {
            this.action = actionMethodExpression;
            Object result = this.invokeMethod(actionMethodExpression);
            if (result != null) {
                this.setOutcome(result.toString());
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String run() throws Exception {
            try {
                this.init();
                this.beforeRequest();
                this.setStandardJspVariables();
                AbstractSeamTest.this.seamFilter.doFilter((ServletRequest)this.request, (ServletResponse)this.response, new FilterChain(){

                    public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
                        try {
                            if (Request.this.emulateJsfLifecycle()) {
                                Request.this.saveConversationViewRoot();
                            }
                        }
                        catch (Exception e) {
                            Request.this.onException(e);
                            throw new ServletException((Throwable)e);
                        }
                    }
                });
                AbstractSeamTest.this.seamFilter.destroy();
                this.afterRequest();
                this.facesContext.release();
                String string = this.conversationId;
                return string;
            }
            finally {
                if (Contexts.isEventContextActive()) {
                    FacesLifecycle.endRequest(this.externalContext);
                }
            }
        }

        private void saveConversationViewRoot() {
            Map renderedViewRootAttributes = this.facesContext.getViewRoot().getViewMap();
            if (renderedViewRootAttributes != null && this.conversationId != null) {
                HashMap conversationState = new HashMap();
                conversationState.putAll(renderedViewRootAttributes);
                AbstractSeamTest.this.conversationViewRootAttributes.put(this.conversationId, conversationState);
            }
        }

        protected void init() {
            this.request = this.createRequest();
            this.response = this.createResponse();
            this.externalContext = new MockExternalContext(AbstractSeamTest.this.servletContext, this.request, this.response);
            this.facesContext = new MockFacesContext(this.externalContext, AbstractSeamTest.this.application);
            this.facesContext.setCurrent();
        }

        protected HttpServletRequest createRequest() {
            Cookie[] cookieArray = this.getCookies().toArray(new Cookie[0]);
            return new MockHttpServletRequest(AbstractSeamTest.this.session, this.getPrincipalName(), this.getPrincipalRoles(), cookieArray, this.isGetRequest() ? "GET" : "POST");
        }

        protected HttpServletResponse createResponse() {
            return new MockHttpServletResponse();
        }

        private void setStandardJspVariables() {
            HashMap params = new HashMap();
            for (Map.Entry e : this.request.getParameterMap().entrySet()) {
                if (((String[])e.getValue()).length != 1) continue;
                params.put(e.getKey(), ((String[])e.getValue())[0]);
            }
            this.request.setAttribute("param", params);
        }

        private boolean emulateJsfLifecycle() throws Exception {
            this.restoreViewPhase();
            if (!this.isGetRequest() && !this.skipToRender()) {
                this.afterRestoreViewPhase();
                this.applyRequestValuesPhase();
                if (!this.skipToRender()) {
                    this.processValidationsPhase();
                    if (!this.skipToRender()) {
                        this.updateModelValuesPhase();
                        if (!this.skipToRender()) {
                            this.invokeApplicationPhase();
                        }
                    }
                }
            }
            if (this.skipRender()) {
                return false;
            }
            this.renderResponsePhase();
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void renderResponsePhase() throws Exception {
            phases.beforePhase(new PhaseEvent((FacesContext)this.facesContext, PhaseId.RENDER_RESPONSE, MockLifecycle.INSTANCE));
            try {
                this.updateConversationId();
                this.renderResponseBegun = true;
                this.renderResponse();
                this.renderResponseComplete = true;
                this.facesContext.getApplication().getStateManager().saveView((FacesContext)this.facesContext);
                this.updateConversationId();
            }
            finally {
                phases.afterPhase(new PhaseEvent((FacesContext)this.facesContext, PhaseId.RENDER_RESPONSE, MockLifecycle.INSTANCE));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void invokeApplicationPhase() throws Exception {
            phases.beforePhase(new PhaseEvent((FacesContext)this.facesContext, PhaseId.INVOKE_APPLICATION, MockLifecycle.INSTANCE));
            try {
                this.updateConversationId();
                this.invokeApplicationBegun = true;
                this.invokeApplication();
                this.invokeApplicationComplete = true;
                String outcome = this.getInvokeApplicationOutcome();
                this.facesContext.getApplication().getNavigationHandler().handleNavigation((FacesContext)this.facesContext, this.action, outcome);
                this.viewId = this.getRenderedViewId();
                this.updateConversationId();
            }
            finally {
                phases.afterPhase(new PhaseEvent((FacesContext)this.facesContext, PhaseId.INVOKE_APPLICATION, MockLifecycle.INSTANCE));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateModelValuesPhase() throws Exception {
            phases.beforePhase(new PhaseEvent((FacesContext)this.facesContext, PhaseId.UPDATE_MODEL_VALUES, MockLifecycle.INSTANCE));
            try {
                this.updateConversationId();
                this.updateModelValues();
                this.updateConversationId();
            }
            finally {
                phases.afterPhase(new PhaseEvent((FacesContext)this.facesContext, PhaseId.UPDATE_MODEL_VALUES, MockLifecycle.INSTANCE));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processValidationsPhase() throws Exception {
            phases.beforePhase(new PhaseEvent((FacesContext)this.facesContext, PhaseId.PROCESS_VALIDATIONS, MockLifecycle.INSTANCE));
            try {
                this.updateConversationId();
                this.processValidations();
                this.updateConversationId();
                if (this.isValidationFailure()) {
                    this.facesContext.renderResponse();
                }
            }
            finally {
                phases.afterPhase(new PhaseEvent((FacesContext)this.facesContext, PhaseId.PROCESS_VALIDATIONS, MockLifecycle.INSTANCE));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void applyRequestValuesPhase() throws Exception {
            phases.beforePhase(new PhaseEvent((FacesContext)this.facesContext, PhaseId.APPLY_REQUEST_VALUES, MockLifecycle.INSTANCE));
            try {
                this.updateConversationId();
                this.applyRequestValues();
                this.updateConversationId();
            }
            finally {
                phases.afterPhase(new PhaseEvent((FacesContext)this.facesContext, PhaseId.APPLY_REQUEST_VALUES, MockLifecycle.INSTANCE));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void restoreViewPhase() {
            phases.beforePhase(new PhaseEvent((FacesContext)this.facesContext, PhaseId.RESTORE_VIEW, MockLifecycle.INSTANCE));
            try {
                UIViewRoot viewRoot = this.facesContext.getApplication().getViewHandler().createView((FacesContext)this.facesContext, this.getViewId());
                this.facesContext.setViewRoot(viewRoot);
                Map restoredViewRootAttributes = this.facesContext.getViewRoot().getViewMap();
                if (this.conversationId != null) {
                    if (this.isGetRequest()) {
                        this.setParameter(Manager.instance().getConversationIdParameter(), this.conversationId);
                    } else if (AbstractSeamTest.this.conversationViewRootAttributes.containsKey(this.conversationId)) {
                        Map state = (Map)AbstractSeamTest.this.conversationViewRootAttributes.get(this.conversationId);
                        restoredViewRootAttributes.putAll(state);
                    }
                }
                if (this.isGetRequest()) {
                    this.facesContext.renderResponse();
                } else {
                    restoredViewRootAttributes.putAll(this.pageParameters);
                }
            }
            finally {
                phases.afterPhase(new PhaseEvent((FacesContext)this.facesContext, PhaseId.RESTORE_VIEW, MockLifecycle.INSTANCE));
            }
        }

        private void updateConversationId() {
            Manager manager = Manager.instance();
            this.conversationId = manager.isLongRunningConversation() ? manager.getCurrentConversationId() : manager.getParentConversationId();
        }

        private boolean skipRender() {
            return FacesContext.getCurrentInstance().getResponseComplete();
        }

        private boolean skipToRender() {
            return FacesContext.getCurrentInstance().getRenderResponse() || FacesContext.getCurrentInstance().getResponseComplete();
        }

        protected boolean isInvokeApplicationBegun() {
            return this.invokeApplicationBegun;
        }

        protected boolean isInvokeApplicationComplete() {
            return this.invokeApplicationComplete;
        }

        protected boolean isRenderResponseBegun() {
            return this.renderResponseBegun;
        }

        protected boolean isRenderResponseComplete() {
            return this.renderResponseComplete;
        }

        protected MimeMessage getRenderedMailMessage(String viewId) {
            AbstractSeamTest.this.installMockTransport();
            MockTransport.clearMailMessage();
            Renderer.instance().render(viewId);
            return MockTransport.getMailMessage();
        }
    }

    public abstract class ComponentTest {
        protected Object invokeMethod(String methodExpression) {
            return Expressions.instance().createMethodExpression(methodExpression).invoke(new Object[0]);
        }

        protected Object getValue(String valueExpression) {
            return Expressions.instance().createValueExpression(valueExpression).getValue();
        }

        protected void setValue(String valueExpression, Object value) {
            Expressions.instance().createValueExpression(valueExpression).setValue(value);
        }

        protected abstract void testComponents() throws Exception;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() throws Exception {
            TestLifecycle.beginTest(AbstractSeamTest.this.servletContext, new ServletSessionMap(AbstractSeamTest.this.session));
            try {
                this.testComponents();
            }
            finally {
                TestLifecycle.endTest();
            }
        }
    }
}

