/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.log;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.seam.log.LogProvider;

class JDKProvider
implements LogProvider {
    private final Logger logger;
    private final boolean isWrapped;

    JDKProvider(String category, boolean wrapped) {
        this.logger = Logger.getLogger(category);
        this.isWrapped = wrapped;
    }

    private void log(Level level, Object object, Throwable ex) {
        if (this.logger.isLoggable(level)) {
            int depth;
            Throwable dummyException = new Throwable();
            StackTraceElement[] locations = dummyException.getStackTrace();
            String className = "unknown";
            String methodName = "unknown";
            int n = depth = this.isWrapped ? 3 : 2;
            if (locations != null && locations.length > depth) {
                StackTraceElement caller = locations[depth];
                className = caller.getClassName();
                methodName = caller.getMethodName();
            }
            if (ex == null) {
                this.logger.logp(level, className, methodName, String.valueOf(object));
            } else {
                this.logger.logp(level, className, methodName, String.valueOf(object), ex);
            }
        }
    }

    @Override
    public void debug(Object object, Throwable t) {
        this.log(Level.FINE, object, t);
    }

    @Override
    public void debug(Object object) {
        this.log(Level.FINE, object, null);
    }

    @Override
    public void error(Object object, Throwable t) {
        this.log(Level.SEVERE, object, t);
    }

    @Override
    public void error(Object object) {
        this.log(Level.SEVERE, object, null);
    }

    @Override
    public void fatal(Object object, Throwable t) {
        this.log(Level.SEVERE, object, t);
    }

    @Override
    public void fatal(Object object) {
        this.log(Level.SEVERE, object, null);
    }

    @Override
    public void info(Object object, Throwable t) {
        this.log(Level.INFO, object, t);
    }

    @Override
    public void info(Object object) {
        this.log(Level.INFO, object, null);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isLoggable(Level.FINE);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isLoggable(Level.SEVERE);
    }

    @Override
    public boolean isFatalEnabled() {
        return this.logger.isLoggable(Level.SEVERE);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isLoggable(Level.INFO);
    }

    @Override
    public boolean isTraceEnabled() {
        return this.logger.isLoggable(Level.FINER);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isLoggable(Level.WARNING);
    }

    @Override
    public void trace(Object object, Throwable t) {
        this.log(Level.FINER, object, t);
    }

    @Override
    public void trace(Object object) {
        this.log(Level.FINER, object, null);
    }

    @Override
    public void warn(Object object, Throwable t) {
        this.log(Level.WARNING, object, t);
    }

    @Override
    public void warn(Object object) {
        this.log(Level.WARNING, object, null);
    }
}

