/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.jsf;

import java.util.Map;
import java.util.Set;
import javax.faces.application.ConfigurableNavigationHandler;
import javax.faces.application.NavigationCase;
import javax.faces.application.NavigationHandler;
import javax.faces.context.FacesContext;
import javax.faces.context.PartialViewContext;
import org.jboss.seam.core.Init;
import org.jboss.seam.faces.FacesManager;
import org.jboss.seam.navigation.Pages;
import org.jboss.seam.pageflow.Pageflow;

public class SeamNavigationHandler
extends ConfigurableNavigationHandler {
    private final NavigationHandler baseNavigationHandler;

    public SeamNavigationHandler(NavigationHandler navigationHandler) {
        this.baseNavigationHandler = navigationHandler;
    }

    public void handleNavigation(FacesContext context, String fromAction, String outcome) {
        if (!context.getResponseComplete()) {
            PartialViewContext pctx;
            String oldView;
            String string = oldView = context.getViewRoot() != null ? context.getViewRoot().getViewId() : "";
            if (SeamNavigationHandler.isOutcomeViewId(outcome)) {
                FacesManager.instance().interpolateAndRedirect(outcome);
            } else if (Init.instance().isJbpmInstalled() && Pageflow.instance().isInProcess() && Pageflow.instance().hasTransition(outcome)) {
                Pageflow.instance().navigate(context, outcome);
            } else if (!Pages.instance().navigate(context, fromAction, outcome)) {
                this.baseNavigationHandler.handleNavigation(context, fromAction, outcome);
            } else if (!oldView.equals(context.getViewRoot().getViewId()) && !(pctx = context.getPartialViewContext()).isRenderAll()) {
                pctx.setRenderAll(true);
            }
        }
    }

    private static boolean isOutcomeViewId(String outcome) {
        return outcome != null && outcome.startsWith("/");
    }

    public NavigationCase getNavigationCase(FacesContext context, String fromAction, String outcome) {
        if (this.baseNavigationHandler instanceof ConfigurableNavigationHandler) {
            return ((ConfigurableNavigationHandler)this.baseNavigationHandler).getNavigationCase(context, fromAction, outcome);
        }
        return null;
    }

    public Map<String, Set<NavigationCase>> getNavigationCases() {
        if (this.baseNavigationHandler instanceof ConfigurableNavigationHandler) {
            return ((ConfigurableNavigationHandler)this.baseNavigationHandler).getNavigationCases();
        }
        return null;
    }
}

