/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.rest;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import org.jboss.logging.Logger;
import org.jboss.seam.rest.client.RestClientExtension;
import org.jboss.seam.rest.exceptions.ExceptionMappingExtension;
import org.jboss.seam.rest.exceptions.RestResource;
import org.jboss.seam.rest.exceptions.SeamExceptionMapper;
import org.jboss.seam.rest.templating.TemplatingMessageBodyWriter;

@ApplicationScoped
public class SeamRestStartup {
    private static final Logger log = Logger.getLogger(SeamRestStartup.class);
    @Inject
    private RestClientExtension restClientExtension;
    @Inject
    private ExceptionMappingExtension exceptionMappingExtension;
    @Inject
    private SeamExceptionMapper exceptionMapper;
    @Inject
    private TemplatingMessageBodyWriter templating;
    @Inject
    @RestResource
    private Event<ServletContext> event;
    private boolean initialized = false;

    public synchronized void init(ServletContext sc) {
        if (this.initialized) {
            return;
        }
        this.event.fire((Object)sc);
        log.infov("Seam REST {0} (Client integration: {1}, Catch integration: {2}, {3} exception mapping rules, Templating provider: {4})", new Object[]{this.getClass().getPackage().getSpecificationVersion(), this.restClientExtension.isClientIntegrationEnabled() ? "enabled" : "disabled", this.exceptionMappingExtension.isCatchIntegrationEnabled() ? "enabled" : "disabled", this.exceptionMapper.getMappings().size(), this.templating.getProvider() == null ? "null" : this.templating.getProvider().toString()});
        this.initialized = true;
    }
}

